/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemPanel;
import codechicken.nei.ItemSorter;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.ThreadOperationTimer;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.guihook.GuiContainerManager;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemList {
    public static List<ItemStack> items = new ArrayList<ItemStack>();
    public static ListMultimap<Item, ItemStack> itemMap = ArrayListMultimap.create();
    public static final List<ItemFilter.ItemFilterProvider> itemFilterers = new LinkedList<ItemFilter.ItemFilterProvider>();
    public static final List<ItemsLoadedCallback> loadCallbacks = new LinkedList<ItemsLoadedCallback>();
    private static boolean loading = false;
    private static boolean reload = false;
    private static boolean filtering = false;
    private static boolean refilter = false;
    private static HashSet<Item> erroredItems = new HashSet();
    private static HashSet<String> stackTraces = new HashSet();

    public static boolean itemMatches(ItemStack item, List<ItemFilter> filters) {
        for (ItemFilter filter : filters) {
            if (filter.matches(item)) continue;
            return false;
        }
        return true;
    }

    public static boolean itemMatches(ItemStack item) {
        return ItemList.itemMatches(item, ItemList.getItemFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemFilter> getItemFilters() {
        LinkedList<ItemFilter> filters = new LinkedList<ItemFilter>();
        List<ItemFilter.ItemFilterProvider> list = itemFilterers;
        synchronized (list) {
            for (ItemFilter.ItemFilterProvider p : itemFilterers) {
                filters.add(p.getFilter());
            }
        }
        return filters;
    }

    public static void updateFilter() {
        if (filtering) {
            refilter = true;
        } else {
            filtering = true;
            new ThreadFilterItems().start();
        }
    }

    public static void loadItems() {
        if (loading) {
            reload = true;
        } else {
            loading = true;
            new ThreadLoadItems().start();
        }
    }

    public static class ThreadFilterItems
    extends Thread {
        public ThreadFilterItems() {
            super("NEI Item Filtering");
        }

        @Override
        public void run() {
            block0: do {
                refilter = false;
                ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
                List<ItemFilter> filters = ItemList.getItemFilters();
                for (ItemStack item : items) {
                    if (refilter) continue block0;
                    if (!ItemList.itemMatches(item, filters)) continue;
                    filtered.add(item);
                }
                ItemSorter.sort(filtered);
                ItemPanel.updateItemList(filtered);
            } while (refilter);
            filtering = false;
        }
    }

    private static class ThreadLoadItems
    extends Thread {
        public ThreadLoadItems() {
            super("NEI Item Loading");
        }

        private void damageSearch(Item item, List<ItemStack> permutations) {
            HashSet<String> damageIconSet = new HashSet<String>();
            for (int damage = 0; damage < 16; ++damage) {
                try {
                    ItemStack itemstack = new ItemStack(item, 1, damage);
                    IIcon icon = item.func_77650_f(itemstack);
                    String name = GuiContainerManager.concatenatedDisplayName(itemstack, false);
                    String s = name + "@" + (icon == null ? 0 : icon.hashCode());
                    if (damageIconSet.contains(s)) continue;
                    damageIconSet.add(s);
                    permutations.add(itemstack);
                    continue;
                }
                catch (ThreadOperationTimer.TimeoutException t) {
                    throw t;
                }
                catch (Throwable t) {
                    NEIServerUtils.logOnce(t, stackTraces, "Ommiting " + item + ":" + damage + " " + item.getClass().getSimpleName(), item.toString());
                }
            }
        }

        @Override
        public void run() {
            ThreadOperationTimer timer = ThreadOperationTimer.start(this, 500);
            block2: do {
                reload = false;
                LinkedList<ItemStack> items = new LinkedList<ItemStack>();
                LinkedList<ItemStack> permutations = new LinkedList<ItemStack>();
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                timer.setLimit(500);
                for (Item item : Item.field_150901_e) {
                    if (reload) continue block2;
                    if (item == null || erroredItems.contains(item)) continue;
                    try {
                        timer.reset(item);
                        permutations.clear();
                        permutations.addAll(ItemInfo.getItemOverrides(item));
                        if (permutations.isEmpty()) {
                            item.func_150895_a(item, null, permutations);
                        }
                        if (permutations.isEmpty()) {
                            this.damageSearch(item, permutations);
                        }
                        timer.reset();
                        items.addAll(permutations);
                        itemMap.putAll((Object)item, permutations);
                    }
                    catch (Throwable t) {
                        NEIServerConfig.logger.error("Removing item: " + item + " from list.", t);
                        erroredItems.add(item);
                    }
                }
                ItemList.items = items;
                ItemList.itemMap = itemMap;
                for (ItemsLoadedCallback callback : loadCallbacks) {
                    callback.itemsLoaded();
                }
                ItemList.updateFilter();
            } while (reload);
            loading = false;
        }
    }

    public static interface ItemsLoadedCallback {
        public void itemsLoaded();
    }

    public static class PatternItemFilter
    implements ItemFilter {
        Pattern pattern;

        public PatternItemFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(ItemStack item) {
            return this.pattern.matcher(ItemInfo.getSearchName(item)).find();
        }
    }

    public static class NothingItemFilter
    implements ItemFilter {
        @Override
        public boolean matches(ItemStack item) {
            return false;
        }
    }

    public static class EverythingItemFilter
    implements ItemFilter {
        @Override
        public boolean matches(ItemStack item) {
            return true;
        }
    }
}

