/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class RedwoodTreeGen
extends WorldGenerator {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand;
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int heightLimit;
    int height;
    double heightAttenuation;
    double field_875_h;
    double field_874_i;
    double field_873_j;
    double field_872_k;
    int trunkSize;
    int heightLimitLimit;
    int leafDistanceLimit;
    int[][] leafNodes;
    Block genWoodID;
    int genWoodMetadata = 0;
    boolean useHeight;

    public RedwoodTreeGen(boolean flag, Block bID) {
        super(flag);
        this.useHeight = flag;
        this.rand = new Random();
        this.heightLimit = 0;
        this.heightAttenuation = 0.618;
        this.field_875_h = 1.0;
        this.field_874_i = 0.381;
        this.field_873_j = 1.0;
        this.field_872_k = 1.0;
        this.trunkSize = 1;
        this.heightLimitLimit = 12;
        this.leafDistanceLimit = 4;
        this.genWoodID = bID;
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = PHNatura.seaLevel + 64;
        do {
            Block underID;
            if ((underID = world.func_147439_a(x, --height, z)) != Blocks.field_150346_d && underID != Blocks.field_150349_c && height >= PHNatura.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return height;
    }

    public boolean isValidSpawn(World world, int x, int y, int z) {
        Block bID = world.func_147439_a(x, y, z);
        boolean ground = bID == Blocks.field_150346_d || bID == Blocks.field_150349_c;
        boolean transparent = !world.func_147439_a(x, y + 1, z).func_149730_j();
        boolean valid = ground && transparent;
        return ground && transparent;
    }

    public boolean func_76484_a(World world, Random random, int x, int yPos, int z) {
        int groundPoint = yPos;
        if (!this.useHeight && !this.isValidSpawn(world, x, groundPoint = this.findGround(world, x, yPos, z), z)) {
            return false;
        }
        int treeHeight = random.nextInt(60) + 80;
        this.worldObj = world;
        long ran = random.nextLong();
        this.rand.setSeed(ran);
        this.basePos[0] = x;
        this.basePos[1] = groundPoint;
        this.basePos[2] = z;
        this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        if (treeHeight > 120) {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight * 1 / 10) {
                    this.genRing13(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 10) {
                    this.genRing12(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 10) {
                    this.genRing11(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 10) {
                    this.genRing10(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 10) {
                    this.genRing9(world, random, x, currentHeight + groundPoint, z);
                    this.growLowBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 6 / 10) {
                    this.genRing8(world, random, x, currentHeight + groundPoint, z);
                    this.growLowBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 7 / 10) {
                    this.genRing7(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 8 / 10) {
                    this.genRing6(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 9 / 10) {
                    this.genRing5(world, random, x, currentHeight + groundPoint, z);
                    this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                this.genRing3(world, random, x, currentHeight + groundPoint, z);
                this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
            }
            this.growBigRoots(world, random, x, groundPoint - 1, z);
            this.growTop(world, random, x, this.height + groundPoint, z);
        } else if (treeHeight > 100) {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight * 1 / 8) {
                    this.genRing11(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 8) {
                    this.genRing10(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 8) {
                    this.genRing9(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 8) {
                    this.genRing8(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 8) {
                    this.genRing7(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 6 / 8) {
                    this.genRing6(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 7 / 8) {
                    this.genRing5(world, random, x, currentHeight + groundPoint, z);
                    this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                this.genRing3(world, random, x, currentHeight + groundPoint, z);
                this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
            }
            this.growMediumRoots(world, random, x, groundPoint - 1, z);
            this.growTop(world, random, x, this.height + groundPoint, z);
        } else {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight * 1 / 6) {
                    this.genRing9(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 6) {
                    this.genRing8(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 6) {
                    this.genRing7(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 6) {
                    this.genRing6(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 6) {
                    this.genRing5(world, random, x, currentHeight + groundPoint, z);
                    this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                this.genRing3(world, random, x, currentHeight + groundPoint, z);
                this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
            }
            this.growSmallRoots(world, random, x, groundPoint - 1, z);
            this.growTop(world, random, x, this.height + groundPoint, z);
        }
        return true;
    }

    public boolean growTop(World world, Random random, int x, int y, int z) {
        this.basePos[0] = x;
        this.basePos[1] = y + 4;
        this.basePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.basePos[0] = x;
        this.basePos[1] = y + 4;
        this.basePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        return false;
    }

    public boolean growHighBranch(World world, Random random, int x, int y, int z) {
        for (int iter = 0; iter < 3; ++iter) {
            this.basePos[0] = x + random.nextInt(21) - 10;
            this.basePos[1] = y;
            this.basePos[2] = z + random.nextInt(21) - 10;
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
        }
        return false;
    }

    public boolean growMiddleBranch(World world, Random random, int x, int y, int z) {
        for (int iter = 0; iter < 6; ++iter) {
            this.basePos[0] = x + random.nextInt(31) - 15;
            this.basePos[1] = y;
            this.basePos[2] = z + random.nextInt(31) - 15;
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
        }
        return false;
    }

    public boolean growLowBranch(World world, Random random, int i, int j, int k) {
        this.basePos[0] = i + random.nextInt(17) - 8;
        this.basePos[1] = j;
        this.basePos[2] = k + random.nextInt(17) - 8;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        if (random.nextInt(2) == 0) {
            this.basePos[0] = i + random.nextInt(17) - 8;
            this.basePos[1] = j;
            this.basePos[2] = k + random.nextInt(17) - 8;
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
        }
        this.basePos[0] = i + random.nextInt(17) - 8;
        this.basePos[1] = j;
        this.basePos[2] = k + random.nextInt(17) - 8;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        return false;
    }

    public boolean growSmallRoots(World world, Random random, int i, int j, int k) {
        this.genRing9(world, random, i, j, k);
        this.smallRoot1(world, random, i, j - 1, k);
        this.smallRoot1(world, random, i, j - 2, k);
        this.smallRoot1(world, random, i, j - 3, k);
        this.smallRoot2(world, random, i, j - 4, k);
        this.smallRoot2(world, random, i, j - 5, k);
        this.smallRoot3(world, random, i, j - 6, k);
        this.smallRoot3(world, random, i, j - 7, k);
        this.smallRoot3(world, random, i, j - 8, k);
        this.smallRoot3(world, random, i, j - 9, k);
        this.smallRoot4(world, random, i, j - 10, k);
        this.smallRoot4(world, random, i, j - 11, k);
        return true;
    }

    public boolean growMediumRoots(World world, Random random, int i, int j, int k) {
        this.genRing11(world, random, i, j, k);
        this.mediumRoot1(world, random, i, j - 1, k);
        this.mediumRoot1(world, random, i, j - 2, k);
        this.mediumRoot1(world, random, i, j - 3, k);
        this.mediumRoot2(world, random, i, j - 4, k);
        this.mediumRoot2(world, random, i, j - 5, k);
        this.mediumRoot3(world, random, i, j - 6, k);
        this.mediumRoot3(world, random, i, j - 7, k);
        this.mediumRoot3(world, random, i, j - 8, k);
        this.mediumRoot3(world, random, i, j - 9, k);
        this.mediumRoot4(world, random, i, j - 10, k);
        this.mediumRoot4(world, random, i, j - 11, k);
        this.mediumRoot5(world, random, i, j - 12, k);
        this.mediumRoot5(world, random, i, j - 13, k);
        this.mediumRoot5(world, random, i, j - 14, k);
        return true;
    }

    public boolean growBigRoots(World world, Random random, int i, int j, int k) {
        this.genRing13(world, random, i, j, k);
        this.bigRoot1(world, random, i, j - 1, k);
        this.bigRoot1(world, random, i, j - 2, k);
        this.bigRoot1(world, random, i, j - 3, k);
        this.bigRoot2(world, random, i, j - 4, k);
        this.bigRoot2(world, random, i, j - 5, k);
        this.bigRoot3(world, random, i, j - 6, k);
        this.bigRoot3(world, random, i, j - 7, k);
        this.bigRoot3(world, random, i, j - 8, k);
        this.bigRoot3(world, random, i, j - 9, k);
        this.bigRoot4(world, random, i, j - 10, k);
        this.bigRoot4(world, random, i, j - 11, k);
        this.bigRoot5(world, random, i, j - 12, k);
        this.bigRoot5(world, random, i, j - 13, k);
        this.bigRoot5(world, random, i, j - 14, k);
        this.bigRoot6(world, random, i, j - 15, k);
        this.bigRoot6(world, random, i, j - 16, k);
        this.bigRoot6(world, random, i, j - 17, k);
        this.bigRoot6(world, random, i, j - 18, k);
        return true;
    }

    public boolean smallRoot1(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean smallRoot2(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean smallRoot3(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean smallRoot4(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot1(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot2(World world, Random random, int i, int j, int k) {
        this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
        this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
        return true;
    }

    public boolean mediumRoot3(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot4(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot5(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot1(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 6, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 6, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 6, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 6, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 6, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 6, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 6, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 6, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot2(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 5, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 5, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 5, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot3(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot4(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot5(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot6(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean genRing13(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 6, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 6, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 6, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 6, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 6, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 5, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 5, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 5, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 5, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing12(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 6, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 6, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 6, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 5, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 5, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 5, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 5, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 5, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 6, j, k + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing11(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 5, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 5, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 5, j, k + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing10(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 4, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing9(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 4, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 4, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 4, j, k + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing8(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 3, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing7(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 3, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 3, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 3, j, k + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing6(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 2, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing5(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i + 1, j, k + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 2, j, k + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing4(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 2, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 2, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing3s(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing3(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, i, j, k + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i + 1, j, k + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing2(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i - 1, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i - 1, j, k, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing1(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, i, j, k, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    void generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.field_872_k * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        ai[0][0] = this.basePos[0];
        ai[0][1] = j--;
        ai[0][2] = this.basePos[2];
        ai[0][3] = l;
        while (i1 >= 0) {
            float f = this.func_528_a(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] ai2;
                int l1;
                double d2;
                double d1 = this.field_873_j * ((double)f * ((double)this.rand.nextFloat() + 0.328));
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * 3.14159) + (double)this.basePos[0] + d));
                int[] ai1 = new int[]{k1, j, l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d))};
                if (this.checkBlockLine(ai1, ai2 = new int[]{k1, j + this.leafDistanceLimit, l1}) != -1) continue;
                int[] ai3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - ai1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - ai1[2]), 2.0));
                double d4 = d3 * this.field_874_i;
                ai3[1] = (double)ai1[1] - d4 > (double)l ? l : (int)((double)ai1[1] - d4);
                if (this.checkBlockLine(ai3, ai1) != -1) continue;
                ai[k][0] = k1;
                ai[k][1] = j;
                ai[k][2] = l1;
                ai[k][3] = ai3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.leafNodes, 0, k);
    }

    void func_523_a(int i, int j, int k, float f, byte byte0, Block l) {
        int i1 = (int)((double)f + 0.618);
        byte byte1 = otherCoordPairs[byte0];
        byte byte2 = otherCoordPairs[byte0 + 3];
        int[] ai = new int[]{i, j, k};
        int[] ai1 = new int[]{0, 0, 0};
        int k1 = -i1;
        ai1[byte0] = ai[byte0];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            ai1[byte1] = ai[byte1] + j1;
            int l1 = -i1;
            while (l1 <= i1) {
                double d = Math.sqrt(Math.pow((double)Math.abs(j1) + 0.5, 2.0) + Math.pow((double)Math.abs(l1) + 0.5, 2.0));
                if (d > (double)f) {
                    ++l1;
                    continue;
                }
                ai1[byte2] = ai[byte2] + l1;
                Block i2 = this.worldObj.func_147439_a(ai1[0], ai1[1], ai1[2]);
                if (i2 != Blocks.field_150350_a && i2 != Blocks.field_150362_t) {
                    ++l1;
                    continue;
                }
                this.func_150516_a(this.worldObj, ai1[0], ai1[1], ai1[2], l, 0);
                ++l1;
            }
        }
    }

    float func_528_a(int i) {
        if ((double)i < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float func_526_b(int i) {
        if (i < 0 || i >= this.leafDistanceLimit) {
            return -1.0f;
        }
        return i == 0 || i == this.leafDistanceLimit - 1 ? 2.0f : 3.0f;
    }

    void generateLeafNode(int i, int j, int k) {
        int i1 = j + this.leafDistanceLimit;
        for (int l = j; l < i1; ++l) {
            float f = this.func_526_b(l - j);
            this.func_523_a(i, l, k, f, (byte)1, (Block)NContent.floraLeaves);
        }
    }

    void placeBlockLine(int[] ai, int[] ai1, Block i) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.func_150516_a(this.worldObj, ai3[0], ai3[1], ai3[2], i, 0);
        }
    }

    void generateLeaves() {
        for (int iter = 0; iter < this.leafNodes.length; ++iter) {
            int posX = this.leafNodes[iter][0];
            int posY = this.leafNodes[iter][1];
            int posZ = this.leafNodes[iter][2];
            this.generateLeafNode(posX, posY, posZ);
        }
    }

    boolean leafNodeNeedsBase(int i) {
        return (double)i >= (double)this.heightLimit * 0.2;
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.leafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(ai, ai2, NContent.redwood);
        }
    }

    int checkBlockLine(int[] ai, int[] ai1) {
        int j;
        int[] ai2 = new int[]{0, 0, 0};
        int i = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[i])) continue;
            i = byte0;
        }
        if (ai2[i] == 0) {
            return -1;
        }
        byte byte1 = otherCoordPairs[i];
        byte byte2 = otherCoordPairs[i + 3];
        int byte3 = ai2[i] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[i];
        double d1 = (double)ai2[byte2] / (double)ai2[i];
        int[] ai3 = new int[]{0, 0, 0};
        int k = ai2[i] + byte3;
        for (j = 0; j != k; j += byte3) {
            ai3[i] = ai[i] + j;
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)j * d));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)j * d1));
            Block l = this.worldObj.func_147439_a(ai3[0], ai3[1], ai3[2]);
            if (l != Blocks.field_150350_a && l != Blocks.field_150362_t) break;
        }
        if (j == k) {
            return -1;
        }
        return Math.abs(j);
    }

    boolean validTreeLocation() {
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] ai1 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        Block i = this.worldObj.func_147439_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        if (i != Blocks.field_150346_d && i != Blocks.field_150359_w) {
            return false;
        }
        int j = this.checkBlockLine(ai, ai1);
        if (j == -1) {
            return true;
        }
        if (j < 6) {
            return false;
        }
        this.heightLimit = j;
        return true;
    }

    public void func_517_a(double d, double d1, double d2) {
        this.heightLimitLimit = (int)(d * 12.0);
        if (d > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.field_873_j = d1;
        this.field_872_k = d2;
    }
}

