/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen.retro;

import java.io.Serializable;
import mantle.world.CoordTuple;
import net.minecraft.world.chunk.Chunk;

public final class ChunkCoord
implements Comparable<ChunkCoord>,
Serializable {
    public int chunkX;
    public int chunkZ;

    public ChunkCoord(Chunk chunk) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
    }

    public ChunkCoord(CoordTuple c) {
        this(c.x >> 4, c.z >> 4);
    }

    public ChunkCoord(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
    }

    public int getCenterX() {
        return (this.chunkX << 4) + 8;
    }

    public int getCenterZ() {
        return (this.chunkZ << 4) + 8;
    }

    public ChunkCoord copy() {
        return new ChunkCoord(this.chunkX, this.chunkZ);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkCoord)) {
            return false;
        }
        ChunkCoord other = (ChunkCoord)obj;
        return this.chunkX == other.chunkX && this.chunkZ == other.chunkZ;
    }

    public int hashCode() {
        int hash = this.chunkX;
        return hash *= 31 + this.chunkZ;
    }

    public String toString() {
        return "[" + this.chunkX + ", " + this.chunkZ + "]";
    }

    @Override
    public int compareTo(ChunkCoord other) {
        return this.chunkX == other.chunkX ? this.chunkZ - other.chunkZ : this.chunkX - other.chunkX;
    }
}

