/*
 * Decompiled with CFR 0.152.
 */
package mods.natura;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import mantle.lib.TabTools;
import mantle.module.ModuleController;
import mods.natura.CloudMaterial;
import mods.natura.common.NContent;
import mods.natura.common.NProxyCommon;
import mods.natura.common.NaturaTab;
import mods.natura.common.PHNatura;
import mods.natura.dimension.NetheriteWorldProvider;
import mods.natura.gui.NGuiHandler;
import mods.natura.plugins.PluginController;
import mods.natura.worldgen.BaseCloudWorldgen;
import mods.natura.worldgen.BaseCropWorldgen;
import mods.natura.worldgen.BaseTreeWorldgen;
import mods.natura.worldgen.retro.TickHandlerWorld;
import mods.natura.worldgen.retro.WorldHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Natura", name="Natura", version="2.2.0", dependencies="required-after:Mantle")
public class Natura {
    @SidedProxy(clientSide="mods.natura.client.NProxyClient", serverSide="mods.natura.common.NProxyCommon")
    public static NProxyCommon proxy;
    @Mod.Instance(value="Natura")
    public static Natura instance;
    public static Material cloud;
    public static Logger logger;
    public static final ModuleController moduleLoader;
    public static BaseCropWorldgen crops;
    public static BaseCloudWorldgen clouds;
    public static BaseTreeWorldgen trees;
    public static boolean retrogen;
    NContent content;
    public static Random random;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PluginController.registerBuiltins();
        PHNatura.initProps(evt.getSuggestedConfigurationFile());
        NaturaTab.tab = new TabTools("natura.plants");
        NaturaTab.woodTab = new TabTools("natura.trees");
        NaturaTab.netherTab = new TabTools("natura.nether");
        this.content = new NContent();
        this.content.preInit();
        this.content.addOredictSupport();
        NaturaTab.tab.init(new ItemStack(NContent.boneBag, 0));
        NaturaTab.woodTab.init(new ItemStack((Block)NContent.floraSapling, 1, 3));
        NaturaTab.netherTab.init(new ItemStack((Block)NContent.floraSapling, 1, 5));
        moduleLoader.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        crops = new BaseCropWorldgen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)crops, (int)20);
        clouds = new BaseCloudWorldgen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)clouds, (int)20);
        trees = new BaseTreeWorldgen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)trees, (int)20);
        proxy.registerRenderer();
        proxy.addNames();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new NGuiHandler());
        GameRegistry.registerFuelHandler((IFuelHandler)this.content);
        if (PHNatura.overrideNether) {
            DimensionManager.unregisterProviderType((int)-1);
            DimensionManager.registerProviderType((int)-1, NetheriteWorldProvider.class, (boolean)true);
        }
        MinecraftForge.EVENT_BUS.register((Object)WorldHandler.instance);
        if (retrogen) {
            FMLCommonHandler.instance().bus().register((Object)new TickHandlerWorld());
        }
        OreDictionary.registerOre((String)"cropVine", (ItemStack)new ItemStack(NContent.thornVines));
        random.setSeed(3244L);
        moduleLoader.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.content.createEntities();
        this.content.modIntegration();
        moduleLoader.postInit();
    }

    @SubscribeEvent
    public void bonemealEvent(BonemealEvent event) {
        if (!event.world.field_72995_K) {
            if (event.block == NContent.glowshroom && NContent.glowshroom.fertilizeMushroom(event.world, event.x, event.y, event.z, event.world.field_73012_v)) {
                event.getResult();
                event.setResult(Event.Result.ALLOW);
            }
            if (event.block == NContent.berryBush && NContent.berryBush.boneFertilize(event.world, event.x, event.y, event.z, event.world.field_73012_v)) {
                event.getResult();
                event.setResult(Event.Result.ALLOW);
            }
            if (event.block == NContent.netherBerryBush && NContent.netherBerryBush.boneFertilize(event.world, event.x, event.y, event.z, event.world.field_73012_v)) {
                event.getResult();
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void interactEvent(EntityInteractEvent event) {
        if (event.target instanceof EntityCow || event.target instanceof EntitySheep) {
            ItemStack equipped = event.entityPlayer.func_71045_bC();
            EntityAnimal creature = (EntityAnimal)event.target;
            if (equipped != null && equipped.func_77973_b() == NContent.plantItem && equipped.func_77960_j() == 0 && creature.func_70874_b() == 0 && creature.func_70880_s()) {
                EntityPlayer player = event.entityPlayer;
                if (!player.field_71075_bZ.field_75098_d) {
                    --equipped.field_77994_a;
                    if (equipped.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                }
                creature.func_146082_f(event.entityPlayer);
                creature.func_70784_b(null);
                for (int i = 0; i < 7; ++i) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    creature.field_70170_p.func_72869_a("heart", creature.field_70165_t + (double)(random.nextFloat() * creature.field_70130_N * 2.0f) - (double)creature.field_70130_N, creature.field_70163_u + 0.5 + (double)(random.nextFloat() * creature.field_70131_O), creature.field_70161_v + (double)(random.nextFloat() * creature.field_70130_N * 2.0f) - (double)creature.field_70130_N, d0, d1, d2);
                }
            }
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityCow || event.entity instanceof EntitySheep) {
            ((EntityLiving)event.entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)event.entity, 0.25, NContent.plantItem, false));
        }
        if (event.entity instanceof EntityChicken) {
            ((EntityLiving)event.entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)event.entity, 0.25, NContent.seeds, false));
        }
    }

    @SubscribeEvent
    public void chunkDataSave(ChunkDataEvent.Save event) {
        event.getData().func_74757_a("Natura.Retrogen", true);
    }

    static {
        cloud = new CloudMaterial();
        logger = LogManager.getLogger((String)"Natura");
        moduleLoader = new ModuleController("Natura-Dynamic.cfg", "Natura");
        random = new Random();
    }
}

