/*
 * Decompiled with CFR 0.152.
 */
package net.boatcake.MyWorldGen.utils;

import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class DirectionUtils {
    public static ForgeDirection[] cardinalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};

    public static ForgeDirection axisForDirection(ForgeDirection rotationDirection) {
        switch (rotationDirection) {
            case UP: {
                return ForgeDirection.EAST;
            }
            case WEST: {
                return ForgeDirection.UP;
            }
            case NORTH: {
                return ForgeDirection.UP;
            }
            case DOWN: {
                return ForgeDirection.WEST;
            }
            case EAST: {
                return ForgeDirection.DOWN;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static float pitchOffsetForDirection(ForgeDirection rotationDirection) {
        switch (rotationDirection) {
            case UP: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 0.0f;
            }
            case DOWN: {
                return -90.0f;
            }
            case EAST: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static int rotationCountForDirection(ForgeDirection rotationDirection) {
        switch (rotationDirection) {
            case UP: {
                return 1;
            }
            case WEST: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case DOWN: {
                return 1;
            }
            case EAST: {
                return 1;
            }
        }
        return 0;
    }

    public static float yawOffsetForDirection(ForgeDirection rotationDirection) {
        switch (rotationDirection) {
            case UP: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case DOWN: {
                return 0.0f;
            }
            case EAST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public static Vec3 rotateCoords(Vec3 coords, Vec3 at, ForgeDirection rotationAxis, int rotationCount) {
        double worldX = coords.field_72450_a;
        double worldY = coords.field_72448_b;
        double worldZ = coords.field_72449_c;
        for (int i = 0; i < rotationCount; ++i) {
            double temp;
            if (rotationAxis.offsetX == 1) {
                temp = worldY;
                worldY = -worldZ;
                worldZ = temp;
            } else if (rotationAxis.offsetX == -1) {
                temp = worldY;
                worldY = worldZ;
                worldZ = -temp;
            }
            if (rotationAxis.offsetY == 1) {
                temp = worldX;
                worldX = -worldZ;
                worldZ = temp;
            } else if (rotationAxis.offsetY == -1) {
                temp = worldX;
                worldX = worldZ;
                worldZ = -temp;
            }
            if (rotationAxis.offsetZ == 1) {
                temp = worldX;
                worldX = -worldY;
                worldY = temp;
                continue;
            }
            if (rotationAxis.offsetZ != -1) continue;
            temp = worldX;
            worldX = worldY;
            worldY = -temp;
        }
        return Vec3.func_72443_a((double)(worldX += at.field_72450_a), (double)(worldY += at.field_72448_b), (double)(worldZ += at.field_72449_c));
    }

    public static ForgeDirection getDirectionFromYaw(float yaw) {
        return cardinalDirections[MathHelper.func_76128_c((double)((double)(yaw * 4.0f / 360.0f) + 0.5)) & 3];
    }
}

