/*
 * Decompiled with CFR 0.152.
 */
package net.boatcake.MyWorldGen;

import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.boatcake.MyWorldGen.MyWorldGen;
import net.boatcake.MyWorldGen.blocks.BlockAnchorLogic;
import net.boatcake.MyWorldGen.blocks.BlockAnchorMaterial;
import net.boatcake.MyWorldGen.blocks.BlockAnchorMaterialLogic;
import net.boatcake.MyWorldGen.blocks.BlockPlacementLogic;
import net.boatcake.MyWorldGen.utils.DirectionUtils;
import net.boatcake.MyWorldGen.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class Schematic
extends WeightedRandom.Item {
    private ArrayList<Integer[]> anchorBlockLocations;
    private int[][][] blocks;
    public String chestType;
    public NBTTagList entities;
    public ArrayList<String> excludeBiomes;
    public short height;
    public Map<Integer, Block> idMap;
    public short length;
    public Map<Integer, BlockAnchorLogic> matchingMap;
    private int[][][] meta;
    public String name;
    public ArrayList<String> onlyIncludeBiomes;
    public Map<Integer, BlockPlacementLogic> placingMap;
    public NBTTagList tileEntities;
    public short width;

    public Schematic() {
        this(0, 0, 0, null);
    }

    public Schematic(NBTTagCompound tag, String n) {
        super(tag.func_74764_b("randomWeight") ? tag.func_74762_e("randomWeight") : 10);
        int i;
        this.name = n;
        if (!tag.func_74779_i("Materials").equals("Alpha")) {
            throw new RuntimeException("Non-Alpha schematics are not supported!");
        }
        this.width = tag.func_74765_d("Width");
        this.height = tag.func_74765_d("Height");
        this.length = tag.func_74765_d("Length");
        this.idMap = new HashMap<Integer, Block>(2);
        this.matchingMap = new HashMap<Integer, BlockAnchorLogic>();
        this.placingMap = new HashMap<Integer, BlockPlacementLogic>();
        if (tag.func_74764_b("MWGIDMap")) {
            NBTTagCompound mapTag = tag.func_74775_l("MWGIDMap");
            for (Object o : mapTag.func_150296_c()) {
                String blockName = (String)o;
                int id = mapTag.func_74762_e(blockName);
                Block block = Block.func_149684_b((String)blockName);
                if (block != null) {
                    this.idMap.put(id, block);
                } else if (!BlockAnchorLogic.isAnchorBlock(blockName) && !BlockPlacementLogic.placementLogicExists(blockName)) {
                    MyWorldGen.log.log(Level.WARN, "Can't find a block named {}", new Object[]{blockName});
                }
                if (BlockAnchorLogic.isAnchorBlock(blockName)) {
                    this.matchingMap.put(id, BlockAnchorLogic.get(blockName));
                }
                if (!BlockPlacementLogic.placementLogicExists(blockName)) continue;
                this.placingMap.put(id, BlockPlacementLogic.get(blockName));
            }
        } else {
            int id;
            if (tag.func_74764_b("ignoreBlockId")) {
                id = tag.func_74762_e("ignoreBlockId");
                if (MyWorldGen.ignoreBlock != null) {
                    this.idMap.put(id, MyWorldGen.ignoreBlock);
                }
                this.placingMap.put(id, BlockPlacementLogic.get("MyWorldGen:ignore"));
            } else {
                MyWorldGen.log.log(Level.WARN, "Schematic file {} has no ignoreBlockId tag, defaulting to ID from config", new Object[]{this.name});
                if (MyWorldGen.ignoreBlock != null) {
                    this.placingMap.put(GameData.getBlockRegistry().getId((Object)MyWorldGen.ignoreBlock), BlockPlacementLogic.get("MyWorldGen:ignore"));
                }
                this.placingMap.put(MyWorldGen.ignoreBlockId, BlockPlacementLogic.get("MyWorldGen:ignore"));
            }
            if (tag.func_74764_b("anchorBlockId")) {
                id = tag.func_74762_e("anchorBlockId");
                if (MyWorldGen.materialAnchorBlock != null) {
                    this.idMap.put(id, MyWorldGen.materialAnchorBlock);
                }
                this.placingMap.put(id, BlockPlacementLogic.get("MyWorldGen:anchor"));
                this.matchingMap.put(id, BlockAnchorLogic.get("MyWorldGen:anchor"));
            } else {
                MyWorldGen.log.log(Level.WARN, "Schematic file {} has no anchorBlockId tag, defaulting to ID from config", new Object[]{this.name});
                if (MyWorldGen.materialAnchorBlock != null) {
                    this.placingMap.put(GameData.getBlockRegistry().getId((Object)MyWorldGen.materialAnchorBlock), BlockPlacementLogic.get("MyWorldGen:anchor"));
                    this.matchingMap.put(GameData.getBlockRegistry().getId((Object)MyWorldGen.materialAnchorBlock), BlockAnchorLogic.get("MyWorldGen:anchor"));
                }
                this.placingMap.put(MyWorldGen.materialAnchorBlockId, BlockPlacementLogic.get("MyWorldGen:anchor"));
                this.matchingMap.put(MyWorldGen.materialAnchorBlockId, BlockAnchorLogic.get("MyWorldGen:anchor"));
            }
            if (MyWorldGen.inventoryAnchorBlock != null) {
                this.placingMap.put(GameData.getBlockRegistry().getId((Object)MyWorldGen.inventoryAnchorBlock), BlockPlacementLogic.get("MyWorldGen:anchorInventory"));
                this.matchingMap.put(GameData.getBlockRegistry().getId((Object)MyWorldGen.inventoryAnchorBlock), BlockAnchorLogic.get("MyWorldGen:anchorInventory"));
            }
            this.placingMap.put(MyWorldGen.inventoryAnchorBlockId, BlockPlacementLogic.get("MyWorldGen:anchorInventory"));
            this.matchingMap.put(MyWorldGen.inventoryAnchorBlockId, BlockAnchorLogic.get("MyWorldGen:anchorInventory"));
        }
        this.anchorBlockLocations = new ArrayList();
        this.blocks = new int[this.width][this.height][this.length];
        this.meta = new int[this.width][this.height][this.length];
        byte[] blockBytes = tag.func_74770_j("Blocks");
        byte[] metaBytes = tag.func_74770_j("Data");
        byte[] blockUpperBits = tag.func_74764_b("AddBlocks") ? tag.func_74770_j("AddBlocks") : null;
        int blockIdx = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.length; ++z) {
                int x = 0;
                while (x < this.width) {
                    this.blocks[x][y][z] = blockBytes[blockIdx] & 0xFF;
                    this.meta[x][y][z] = metaBytes[blockIdx] & 0xF;
                    if (blockUpperBits != null) {
                        int[] nArray = this.blocks[x][y];
                        int n2 = z;
                        nArray[n2] = nArray[n2] | blockUpperBits[blockIdx >> 1] << (blockIdx % 2 == 0 ? 4 : 8) & 0xF00;
                    }
                    if (this.matchingMap.containsKey(this.blocks[x][y][z])) {
                        this.anchorBlockLocations.add(new Integer[]{x, y, z});
                    }
                    ++x;
                    ++blockIdx;
                }
            }
        }
        this.entities = (NBTTagList)tag.func_74781_a("Entities");
        this.tileEntities = (NBTTagList)tag.func_74781_a("TileEntities");
        if (this.anchorBlockLocations.isEmpty() && this.name != null) {
            MyWorldGen.log.log(Level.WARN, "No anchors found in schematic {}", new Object[]{this.name});
        }
        this.chestType = tag.func_74764_b("chestType") ? tag.func_74779_i("chestType") : "dungeonChest";
        if (tag.func_74764_b("excludeBiomes")) {
            NBTTagList l = (NBTTagList)tag.func_74781_a("excludeBiomes");
            this.excludeBiomes = new ArrayList(l.func_74745_c());
            for (i = 0; i < l.func_74745_c(); ++i) {
                this.excludeBiomes.add(l.func_150307_f(i));
            }
        } else {
            this.excludeBiomes = null;
        }
        if (tag.func_74764_b("onlyIncludeBiomes")) {
            NBTTagList l = (NBTTagList)tag.func_74781_a("onlyIncludeBiomes");
            this.onlyIncludeBiomes = new ArrayList(l.func_74745_c());
            for (i = 0; i < l.func_74745_c(); ++i) {
                this.onlyIncludeBiomes.add(l.func_150307_f(i));
            }
        } else {
            this.onlyIncludeBiomes = null;
        }
    }

    public Schematic(short w, short h, short d, String n) {
        super(10);
        this.width = w;
        this.height = h;
        this.length = d;
        this.blocks = new int[w][h][d];
        this.meta = new int[w][h][d];
        this.entities = null;
        this.tileEntities = null;
        this.idMap = new HashMap<Integer, Block>();
        this.matchingMap = new HashMap<Integer, BlockAnchorLogic>();
        this.placingMap = new HashMap<Integer, BlockPlacementLogic>();
        this.anchorBlockLocations = new ArrayList();
        this.chestType = "dungeonChest";
        this.excludeBiomes = new ArrayList();
        this.excludeBiomes.add(BiomeGenBase.field_76778_j.field_76791_y);
        this.excludeBiomes.add(BiomeGenBase.field_76779_k.field_76791_y);
        this.onlyIncludeBiomes = null;
        this.name = n;
    }

    public Schematic(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        this((short)(Math.abs(x2 - x1) + 1), (short)(Math.abs(y2 - y1) + 1), (short)(Math.abs(z2 - z1) + 1), String.format("%s: %d,%d,%d:%d,%d,%d", world.func_72912_H().func_76065_j(), x1, y1, z1, x2, y2, z2));
        int t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        if (z1 > z2) {
            t = z1;
            z1 = z2;
            z2 = t;
        }
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    int id;
                    Block block = world.func_147439_a(x, y, z);
                    this.blocks[x - x1][y - y1][z - z1] = id = Block.func_149682_b((Block)block);
                    this.idMap.put(id, block);
                    this.meta[x - x1][y - y1][z - z1] = world.func_72805_g(x, y, z);
                }
            }
        }
        if (!world.field_72995_K) {
            this.entities = WorldUtils.getEntities(world, x1, y1, z1, x2, y2, z2);
            this.tileEntities = WorldUtils.getTileEntities(world, x1, y1, z1, x2, y2, z2);
        }
    }

    public boolean containsIgnoreCase(List<String> list, String thing) {
        for (String other : list) {
            if (!thing.equalsIgnoreCase(other)) continue;
            return true;
        }
        return false;
    }

    public boolean fitsIntoWorldAt(World world, int atX, int atY, int atZ, ForgeDirection rotationDirection) {
        ForgeDirection rotationAxis = DirectionUtils.axisForDirection(rotationDirection);
        int rotationCount = DirectionUtils.rotationCountForDirection(rotationDirection);
        Vec3 offset = Vec3.func_72443_a((double)atX, (double)atY, (double)atZ);
        if (this.anchorBlockLocations.isEmpty()) {
            Vec3 middle = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)(this.width / 2), (double)0.0, (double)(this.length / 2)), offset, rotationAxis, rotationCount);
            int midX = (int)middle.field_72450_a;
            int midY = (int)middle.field_72448_b;
            int midZ = (int)middle.field_72449_c;
            Block otherBlockBelow = world.func_147439_a(midX, midY, midZ);
            int otherMetaBelow = world.func_72805_g(midX, midY, midZ);
            Block otherBlockAbove = world.func_147439_a(midX, midY + 1, midZ);
            int otherMetaAbove = world.func_72805_g(midX, midY + 1, midZ);
            BiomeGenBase biome = world.func_72807_a(midX, midZ);
            return BlockAnchorMaterialLogic.matchesStatic(BlockAnchorMaterial.AnchorType.GROUND.id, otherBlockBelow, otherMetaBelow, biome) && BlockAnchorMaterialLogic.matchesStatic(BlockAnchorMaterial.AnchorType.AIR.id, otherBlockAbove, otherMetaAbove, biome);
        }
        for (int i = 0; i < this.anchorBlockLocations.size(); ++i) {
            Integer[] origCoords = this.anchorBlockLocations.get(i);
            Vec3 rotatedCoords = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)origCoords[0].intValue(), (double)origCoords[1].intValue(), (double)origCoords[2].intValue()), offset, rotationAxis, rotationCount);
            if (world.func_72899_e((int)rotatedCoords.field_72450_a, (int)rotatedCoords.field_72448_b, (int)rotatedCoords.field_72449_c) && this.matchingMap.get(this.blocks[origCoords[0]][origCoords[1]][origCoords[2]]).matches(this.meta[origCoords[0]][origCoords[1]][origCoords[2]], this.getTileEntityAt(origCoords[0], origCoords[1], origCoords[2]), world, (int)rotatedCoords.field_72450_a, (int)rotatedCoords.field_72448_b, (int)rotatedCoords.field_72449_c)) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound getNBT() {
        NBTTagList t;
        NBTTagCompound base = new NBTTagCompound();
        base.func_74777_a("Width", this.width);
        base.func_74777_a("Height", this.height);
        base.func_74777_a("Length", this.length);
        base.func_74778_a("Materials", "Alpha");
        int size = this.width * this.height * this.length;
        byte[] blockBytes = new byte[size];
        byte[] metaBytes = new byte[size];
        if (size % 2 != 0) {
            ++size;
        }
        byte[] blockUpperBits = new byte[size / 2];
        int blockIdx = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.length; ++z) {
                int x = 0;
                while (x < this.width) {
                    blockBytes[blockIdx] = (byte)(this.blocks[x][y][z] & 0xFF);
                    metaBytes[blockIdx] = (byte)(this.meta[x][y][z] & 0xF);
                    int n = blockIdx >> 1;
                    blockUpperBits[n] = (byte)(blockUpperBits[n] | (byte)((this.blocks[x][y][z] & 0xF00) >> (blockIdx % 2 == 0 ? 4 : 8)));
                    ++x;
                    ++blockIdx;
                }
            }
        }
        base.func_74773_a("Blocks", blockBytes);
        base.func_74773_a("Data", metaBytes);
        base.func_74773_a("AddBlocks", blockUpperBits);
        if (this.entities != null) {
            base.func_74782_a("Entities", (NBTBase)this.entities);
        }
        if (this.tileEntities != null) {
            base.func_74782_a("TileEntities", (NBTBase)this.tileEntities);
        }
        NBTTagCompound idMapTag = new NBTTagCompound();
        for (Map.Entry<Integer, Block> entry : this.idMap.entrySet()) {
            idMapTag.func_74768_a(Block.field_149771_c.func_148750_c((Object)entry.getValue()), entry.getKey().intValue());
        }
        base.func_74782_a("MWGIDMap", (NBTBase)idMapTag);
        base.func_74778_a("chestType", this.chestType);
        if (this.excludeBiomes != null) {
            t = new NBTTagList();
            for (String biome : this.excludeBiomes) {
                t.func_74742_a((NBTBase)new NBTTagString(biome));
            }
            base.func_74782_a("excludeBiomes", (NBTBase)t);
        }
        if (this.onlyIncludeBiomes != null) {
            t = new NBTTagList();
            for (String biome : this.onlyIncludeBiomes) {
                t.func_74742_a((NBTBase)new NBTTagString(biome));
            }
            base.func_74782_a("onlyIncludeBiomes", (NBTBase)t);
        }
        base.func_74768_a("randomWeight", this.field_76292_a);
        return base;
    }

    public TileEntity getTileEntityAt(int x, int y, int z) {
        for (int i = 0; i < this.tileEntities.func_74745_c(); ++i) {
            NBTTagCompound tileEntityTag = this.tileEntities.func_150305_b(i);
            if (tileEntityTag.func_74762_e("x") != x || tileEntityTag.func_74762_e("y") != y || tileEntityTag.func_74762_e("z") != z) continue;
            TileEntity e = TileEntity.func_145827_c((NBTTagCompound)tileEntityTag);
            return e;
        }
        return null;
    }

    public boolean matchesBiome(BiomeGenBase biome) {
        if (this.excludeBiomes != null && this.containsIgnoreCase(this.excludeBiomes, biome.field_76791_y)) {
            return false;
        }
        return this.onlyIncludeBiomes == null || this.containsIgnoreCase(this.onlyIncludeBiomes, biome.field_76791_y);
    }

    public void placeInWorld(World world, int atX, int atY, int atZ, ForgeDirection rotationDirection, boolean generateChests, boolean generateSpawners, Random rand) {
        Vec3 newCoords;
        int i;
        Block block;
        Vec3 rotatedCoords;
        int x;
        ForgeDirection rotationAxis = DirectionUtils.axisForDirection(rotationDirection);
        int rotationCount = DirectionUtils.rotationCountForDirection(rotationDirection);
        float pitchOffset = DirectionUtils.pitchOffsetForDirection(rotationDirection);
        float yawOffset = DirectionUtils.yawOffsetForDirection(rotationDirection);
        Vec3 offset = Vec3.func_72443_a((double)atX, (double)atY, (double)atZ);
        for (x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    rotatedCoords = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)x, (double)y, (double)z), offset, rotationAxis, rotationCount);
                    if (this.placingMap.containsKey(this.blocks[x][y][z])) {
                        this.placingMap.get(this.blocks[x][y][z]).affectWorld(this.meta[x][y][z], this.getTileEntityAt(x, y, z), world, x, y, z);
                        continue;
                    }
                    if (this.idMap.containsKey(this.blocks[x][y][z])) {
                        block = this.idMap.get(this.blocks[x][y][z]);
                        world.func_147465_d((int)rotatedCoords.field_72450_a, (int)rotatedCoords.field_72448_b, (int)rotatedCoords.field_72449_c, block, this.meta[x][y][z], 2);
                        continue;
                    }
                    block = Block.func_149729_e((int)this.blocks[x][y][z]);
                    world.func_147465_d((int)rotatedCoords.field_72450_a, (int)rotatedCoords.field_72448_b, (int)rotatedCoords.field_72449_c, block, this.meta[x][y][z], 2);
                }
            }
        }
        if (this.entities != null) {
            for (i = 0; i < this.entities.func_74745_c(); ++i) {
                NBTTagCompound entityTag = this.entities.func_150305_b(i);
                Entity e = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)world);
                if (e == null) {
                    MyWorldGen.log.log(Level.WARN, "Not loading entity ID {}", new Object[]{entityTag.func_74779_i("id")});
                    continue;
                }
                newCoords = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v), offset, rotationAxis, rotationCount);
                e.func_70080_a(newCoords.field_72450_a, newCoords.field_72448_b, newCoords.field_72449_c, e.field_70125_A + pitchOffset, e.field_70177_z + yawOffset);
                world.func_72838_d(e);
            }
        }
        if (this.tileEntities != null) {
            for (i = 0; i < this.tileEntities.func_74745_c(); ++i) {
                NBTTagCompound tileEntityTag = this.tileEntities.func_150305_b(i);
                TileEntity e = TileEntity.func_145827_c((NBTTagCompound)tileEntityTag);
                if (e == null) {
                    MyWorldGen.log.log(Level.WARN, "Not loading tile entity ID {}", new Object[]{tileEntityTag.func_74779_i("id")});
                    continue;
                }
                newCoords = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)e.field_145851_c, (double)e.field_145848_d, (double)e.field_145849_e), offset, rotationAxis, rotationCount);
                e.field_145851_c = (int)newCoords.field_72450_a;
                e.field_145848_d = (int)newCoords.field_72448_b;
                e.field_145849_e = (int)newCoords.field_72449_c;
                world.func_72938_d((int)newCoords.field_72450_a, (int)newCoords.field_72449_c).func_150813_a(e);
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    rotatedCoords = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)x, (double)y, (double)z), offset, rotationAxis, rotationCount);
                    block = world.func_147439_a((int)rotatedCoords.field_72450_a, (int)rotatedCoords.field_72448_b, (int)rotatedCoords.field_72449_c);
                    TileEntity e = world.func_147438_o((int)rotatedCoords.field_72450_a, (int)rotatedCoords.field_72448_b, (int)rotatedCoords.field_72449_c);
                    if (generateChests && !this.chestType.isEmpty()) {
                        ChestGenHooks info;
                        if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR) {
                            info = ChestGenHooks.getInfo((String)this.chestType);
                            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)((TileEntityChest)e), (int)info.getCount(rand));
                        } else if (block == Blocks.field_150367_z) {
                            info = ChestGenHooks.getInfo((String)"pyramidJungleDispenser");
                            WeightedRandomChestContent.func_150706_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (TileEntityDispenser)((TileEntityDispenser)e), (int)info.getCount(rand));
                        }
                    }
                    if (!generateSpawners || block != Blocks.field_150474_ac) continue;
                    DungeonHooks.getRandomDungeonMob((Random)rand);
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    Block block2 = this.idMap.containsKey(this.blocks[x][y][z]) ? this.idMap.get(this.blocks[x][y][z]) : Block.func_149729_e((int)this.blocks[x][y][z]);
                    if (block2 == null) continue;
                    Vec3 rotatedCoords2 = DirectionUtils.rotateCoords(Vec3.func_72443_a((double)x, (double)y, (double)z), offset, rotationAxis, rotationCount);
                    for (int i2 = 0; i2 < rotationCount; ++i2) {
                        block2.rotateBlock(world, (int)rotatedCoords2.field_72450_a, (int)rotatedCoords2.field_72448_b, (int)rotatedCoords2.field_72449_c, rotationAxis);
                    }
                }
            }
        }
    }
}

