/*
 * Decompiled with CFR 0.152.
 */
package net.boatcake.MyWorldGen;

import cpw.mods.fml.common.IWorldGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.boatcake.MyWorldGen.MyWorldGen;
import net.boatcake.MyWorldGen.Schematic;
import net.boatcake.MyWorldGen.SchematicFilenameFilter;
import net.boatcake.MyWorldGen.utils.DirectionUtils;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class WorldGenerator
implements IWorldGenerator {
    private Map<File, Schematic> schemList = new HashMap<File, Schematic>();

    public void addSchematicsFromDirectory(File schemDirectory) {
        File[] schemFiles;
        for (File schemFile : schemFiles = schemDirectory.listFiles(new SchematicFilenameFilter())) {
            try {
                this.addSchemFromFile(schemFile);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void addSchemFromFile(File schemFile) throws FileNotFoundException, IOException {
        this.addSchemFromStream(new FileInputStream(schemFile), schemFile);
    }

    public void addSchemFromStream(InputStream stream, File schemFile) throws IOException {
        if (!this.schemList.containsKey(schemFile)) {
            Schematic newSchem = new Schematic(CompressedStreamTools.func_74796_a((InputStream)stream), schemFile.getName());
            this.schemList.put(schemFile, newSchem);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.schemList.isEmpty() && random.nextBoolean()) {
            ArrayList<Schematic> applicableSchematics = new ArrayList<Schematic>();
            for (Schematic s : this.schemList.values()) {
                if (!s.matchesBiome(world.func_72807_a(chunkX * 16, chunkZ * 16))) continue;
                applicableSchematics.add(s);
            }
            if (!applicableSchematics.isEmpty()) {
                WeightedRandom.Item noStructureItem = new WeightedRandom.Item(MyWorldGen.generateNothingWeight);
                WeightedRandom.Item selectedItem = WeightedRandom.func_76271_a((Random)random, applicableSchematics);
                if (selectedItem != noStructureItem) {
                    Schematic schemToGenerate = (Schematic)selectedItem;
                    for (int i = 0; i < MyWorldGen.generateTries; ++i) {
                        ForgeDirection randomDirection;
                        int z;
                        int y;
                        int x = random.nextInt(16) + chunkX * 16;
                        if (!schemToGenerate.fitsIntoWorldAt(world, x, y = random.nextInt(world.func_72800_K()), z = random.nextInt(16) + chunkZ * 16, randomDirection = DirectionUtils.cardinalDirections[random.nextInt(4)])) continue;
                        schemToGenerate.placeInWorld(world, x, y, z, randomDirection, true, true, random);
                        MyWorldGen.log.log(Level.OFF, "Generated {} at {}, {}, {}; took {} tries", new Object[]{schemToGenerate.name, x, y, z, i + 1});
                        break;
                    }
                }
            }
        }
    }
}

