/*
 * Decompiled with CFR 0.152.
 */
package net.boatcake.MyWorldGen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.boatcake.MyWorldGen.GuiHandler;
import net.boatcake.MyWorldGen.WorldGenerator;
import net.boatcake.MyWorldGen.blocks.BlockAnchorInventory;
import net.boatcake.MyWorldGen.blocks.BlockAnchorInventoryLogic;
import net.boatcake.MyWorldGen.blocks.BlockAnchorLogic;
import net.boatcake.MyWorldGen.blocks.BlockAnchorMaterial;
import net.boatcake.MyWorldGen.blocks.BlockAnchorMaterialLogic;
import net.boatcake.MyWorldGen.blocks.BlockIgnore;
import net.boatcake.MyWorldGen.blocks.BlockPlacementIgnore;
import net.boatcake.MyWorldGen.blocks.TileEntityAnchorInventory;
import net.boatcake.MyWorldGen.items.BlockAnchorItem;
import net.boatcake.MyWorldGen.items.ItemWandLoad;
import net.boatcake.MyWorldGen.items.ItemWandSave;
import net.boatcake.MyWorldGen.network.MWGCodec;
import net.boatcake.MyWorldGen.utils.FileUtils;
import net.boatcake.MyWorldGen.utils.NetUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Logger;

@Mod(modid="MyWorldGen", name="MyWorldGen", version="1.3", dependencies="after:OpenBlocks")
public class MyWorldGen {
    public static CreativeTabs creativeTab;
    public static int generateNothingWeight;
    public static int generateTries;
    public static File globalSchemDir;
    public static Block ignoreBlock;
    public static int ignoreBlockId;
    @Mod.Instance(value="MyWorldGen")
    public static MyWorldGen instance;
    public static Block inventoryAnchorBlock;
    public static int inventoryAnchorBlockId;
    public static Logger log;
    public static Block materialAnchorBlock;
    public static int materialAnchorBlockId;
    public static final String MODID = "MyWorldGen";
    public static String resourcePath;
    public static Item wandLoad;
    public static Item wandSave;
    public static WorldGenerator worldGen;
    private boolean enableItemsAndBlocks;
    private File sourceFile;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        NetUtils.net = NetworkRegistry.INSTANCE.newChannel(MODID, new ChannelHandler[]{new MWGCodec()});
        if (!globalSchemDir.isDirectory()) {
            globalSchemDir.mkdir();
            try {
                ZipFile zf = new ZipFile(this.sourceFile);
                ZipEntry worldGenDir = zf.getEntry(resourcePath + "/");
                if (worldGenDir != null && worldGenDir.isDirectory()) {
                    Enumeration<? extends ZipEntry> e = zf.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        if (ze.isDirectory() || !ze.getName().startsWith(worldGenDir.getName())) continue;
                        FileUtils.writeStream(zf.getInputStream(ze), ze.getName());
                    }
                }
                zf.close();
            }
            catch (FileNotFoundException e) {
                File f = new File(MyWorldGen.class.getClassLoader().getResource(resourcePath).getPath());
                if (f.isDirectory()) {
                    for (String s : f.list()) {
                        try {
                            FileUtils.writeStream(new FileInputStream(new File(f, s)), s);
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (event.getSide() == Side.CLIENT) {
            File resourcePacksDir = new File(Minecraft.func_71410_x().field_71412_D, "resourcepacks");
            for (File resourcePack : resourcePacksDir.listFiles()) {
                try {
                    ZipFile zf = new ZipFile(resourcePack);
                    ZipEntry worldGenDir = zf.getEntry(resourcePath + "/");
                    if (worldGenDir != null && worldGenDir.isDirectory()) {
                        Enumeration<? extends ZipEntry> e = zf.entries();
                        while (e.hasMoreElements()) {
                            ZipEntry ze = e.nextElement();
                            if (ze.isDirectory() || !ze.getName().startsWith(worldGenDir.getName())) continue;
                            worldGen.addSchemFromStream(zf.getInputStream(ze), new File(resourcePack, ze.getName()));
                        }
                    }
                    zf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=UHDDACLRN2T46&lc=US&item_name=MyWorldGen&currency_code=USD&bn=PP-DonationsBF:btn_donate_SM.gif:NonHosted");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        this.sourceFile = event.getSourceFile();
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        cfg.load();
        this.enableItemsAndBlocks = cfg.get("configuration", "enableItemsAndBlocks", true, "Turn this off if you're running a server and the clients don't have the mod installed").getBoolean(true);
        if (!this.enableItemsAndBlocks) {
            log.info("Skipping block & item registration");
        }
        if (this.enableItemsAndBlocks) {
            creativeTab = new CreativeTabs("tabMyWorldGen"){

                public Item func_78016_d() {
                    return Item.func_150898_a((Block)(materialAnchorBlock == null ? Blocks.field_150349_c : materialAnchorBlock));
                }
            };
        }
        try {
            materialAnchorBlock = this.registerBlock("anchor", BlockAnchorMaterial.class, BlockAnchorItem.class, BlockAnchorMaterialLogic.class);
            Property prop = cfg.get("blocks", "materialAnchorBlock", "Default ID for when an ID map is not found in a schematic");
            materialAnchorBlockId = materialAnchorBlock == null ? prop.getInt(1575) : prop.getInt(GameData.getBlockRegistry().getId((Object)materialAnchorBlock));
            ignoreBlock = this.registerBlock("ignore", BlockIgnore.class, null, null);
            prop = cfg.get("blocks", "ignoreBlock", "Default ID for when an ID map is not found in a schematic");
            ignoreBlockId = ignoreBlock == null ? prop.getInt(1576) : prop.getInt(GameData.getBlockRegistry().getId((Object)ignoreBlock));
            inventoryAnchorBlock = this.registerBlock("anchorInventory", BlockAnchorInventory.class, null, BlockAnchorInventoryLogic.class);
            prop = cfg.get("blocks", "inventoryAnchorBlock", "Default ID for when an ID map is not found in a schematic");
            inventoryAnchorBlockId = inventoryAnchorBlock == null ? prop.getInt(1577) : prop.getInt(GameData.getBlockRegistry().getId((Object)inventoryAnchorBlock));
            wandSave = this.registerItem("wandSave", ItemWandSave.class, cfg);
            wandLoad = this.registerItem("wandLoad", ItemWandLoad.class, cfg);
        }
        catch (RuntimeException e) {
            log.fatal("Could not load configuration");
            e.printStackTrace();
            return;
        }
        catch (ReflectiveOperationException e) {
            log.fatal("Self-reflection failed. Is the mod intact?");
            e.printStackTrace();
            return;
        }
        String worldGenDir = cfg.get("configuration", "schematicDirectory", "worldgen", "Subdirectory of .minecraft").getString();
        switch (event.getSide()) {
            case CLIENT: {
                globalSchemDir = new File(Minecraft.func_71410_x().field_71412_D, worldGenDir);
                break;
            }
            case SERVER: {
                globalSchemDir = MinecraftServer.func_71276_C().func_71209_f(worldGenDir);
            }
        }
        generateNothingWeight = cfg.get("configuration", "generateNothingWeight", 10, "Increase this number to generate fewer structures, decrease to generate more").getInt(10);
        generateTries = cfg.get("configuration", "generateTries", 128, "Increase this if you have structures with complex anchor block layouts. Higher numbers will make longer load times.").getInt(128);
        if (cfg.hasChanged()) {
            cfg.save();
        }
        worldGen = new WorldGenerator();
        GameRegistry.registerTileEntity(TileEntityAnchorInventory.class, (String)"anchorInventory");
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)0);
    }

    private Block registerBlock(String name, Class<? extends Block> blockClass, Class<? extends ItemBlock> itemBlockClass, Class<? extends BlockAnchorLogic> matching) throws RuntimeException, ReflectiveOperationException {
        Block block = null;
        if (this.enableItemsAndBlocks) {
            block = blockClass.getConstructor(Material.class).newInstance(Material.field_151594_q);
            block.func_149663_c(name);
            block.func_149658_d("MyWorldGen:" + name);
            block.func_149647_a(creativeTab);
            GameRegistry.registerBlock((Block)block, itemBlockClass == null ? ItemBlock.class : itemBlockClass, (String)name);
        }
        new BlockPlacementIgnore("MyWorldGen:" + name);
        if (matching != null) {
            matching.getConstructor(String.class).newInstance("MyWorldGen:" + name);
        }
        return block;
    }

    private Item registerItem(String name, Class<? extends Item> itemClass, Configuration cfg) throws RuntimeException, ReflectiveOperationException {
        Item item = null;
        if (this.enableItemsAndBlocks) {
            item = itemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            item.func_77655_b(name);
            item.func_111206_d("MyWorldGen:" + name);
            item.func_77637_a(creativeTab);
            GameRegistry.registerItem((Item)item, (String)name);
        }
        return item;
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        worldGen.addSchematicsFromDirectory(globalSchemDir);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
    }

    static {
        resourcePath = "assets/myworldgen/worldgen";
    }
}

