package net.minecraft.mypeople.item;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.mypeople.MyPeople;

public class ItemNeedle extends ItemSword{
	boolean bloodied = false;
	
	public ItemNeedle(int i, boolean blood){
		super(i, EnumToolMaterial.STONE);
		setMaxDamage(0);
		this.bloodied = blood;
		setCreativeTab(CreativeTabs.tabBrewing);
	}
	
	@Override
	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
		if(itemstack.getItemDamage() != 0 || itemstack.itemID != MyPeople.needleBlood.itemID){
			itemstack = new ItemStack(MyPeople.needleBlood, 1, 0);
			if(!entityplayer.capabilities.disableDamage){
				entityplayer.attackEntityFrom(DamageSource.magic, 2);
				entityplayer.addPotionEffect(new PotionEffect(9, 1200, 0));
				entityplayer.addPotionEffect(new PotionEffect(17, 1200, 0));
				entityplayer.addPotionEffect(new PotionEffect(18, 1200, 0));
			}
			world.playSoundAtEntity(entityplayer, "random.drink", 0.5F, world.rand.nextFloat() * 0.1F + 0.9F);
		}
		return itemstack;
	}
	

	@Override
	public boolean itemInteractionForEntity(ItemStack par1ItemStack, EntityLiving par2EntityLiving) {
		return true;
	}


    public int getColorFromItemStack(ItemStack par1ItemStack, int par2)
    {
        EntityEggInfo var3 = (EntityEggInfo)EntityList.entityEggs.get(Integer.valueOf(par1ItemStack.getItemDamage()));
        return var3 != null ? (par2 == 0 ? var3.primaryColor : var3.secondaryColor) : 16777215;
    }

	@Override
	public int getDamageVsEntity(Entity entity) {
		return 2;
	}

	@Override
	public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
		int idPre = EntityList.getEntityID(entityliving);
		int idPost = idPre;
		if(idPre == MyPeople.instance.cloneID){
			idPost = 0;
		}
		if(idPre > 0 && EntityList.entityEggs.containsKey(idPre) && (itemstack.itemID != MyPeople.needleBlood.itemID || itemstack.getItemDamage()!= idPost)){
			itemstack.itemID = MyPeople.needleBlood.itemID;
			itemstack.setItemDamage(idPost);
			entityliving.attackEntityFrom(DamageSource.magic, 2);
			entityliving.addPotionEffect(new PotionEffect(9, 1200, 0));
			entityliving.addPotionEffect(new PotionEffect(17, 1200, 0));
			entityliving.addPotionEffect(new PotionEffect(18, 1200, 0));
			entityliving.worldObj.playSoundAtEntity(entityliving, "random.drink", 0.5F, entityliving.worldObj.rand.nextFloat() * 0.1F + 0.9F);
			
			
			return true;
		}
		return false;
	}

}
