package net.minecraft.mypeople.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBlaze;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.model.ModelGhast;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelMagmaCube;
import net.minecraft.client.model.ModelOcelot;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.model.MyPeopleModelAccessor;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.MyPeopleRenderLivingAccessor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.mypeople.ModelEntry;
import net.minecraft.mypeople.ModelMixed;
import net.minecraft.mypeople.MyPeople;
import net.minecraft.mypeople.MyPeopleFieldGrabbers;
import net.minecraft.mypeople.MyPeoplePacketType;
import net.minecraft.mypeople.SpawnData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class EntityCustomized extends EntityLiving{

	int[] mixedIds = new int[0];
	
	int attackStrength, maxHealth = 20, healRate = 1;
	float size = 1.0f, topMoveSpeed = .32f, jumpMultiplier = 1.0f;
	boolean breatheUnderwater = false, catchOnFire = false;
	
	public ModelMixed models;
	
	public EntityCustomized(World par1World) {
		super(par1World);
		this.health = 20;
	}

	@Override
	public int getMaxHealth() {
		return maxHealth;
	}
	
	
	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		NBTTagCompound vars = new NBTTagCompound();
		writeVars(vars);
		nbt.setTag("Variables", vars);
	}
	
	public void writeVars(NBTTagCompound nbt){
		nbt.setIntArray("mixedIds", mixedIds);
		nbt.setInteger("attackStrength", attackStrength);
		nbt.setInteger("maxHealth", maxHealth);
		nbt.setInteger("healRate", healRate);
		nbt.setFloat("size", size);
		nbt.setFloat("topMoveSpeed", topMoveSpeed);
		nbt.setFloat("jumpStrength", jumpMultiplier);
		nbt.setBoolean("breatheUnderwater", breatheUnderwater);
		nbt.setBoolean("catchOnFire", catchOnFire);
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		readVars((NBTTagCompound)nbt.getTag("Variables"));
	}
	
	public void readVars(NBTTagCompound nbt){
		mixedIds = nbt.getIntArray("mixedIds");
		attackStrength = nbt.getInteger("attackStrength");
		maxHealth = nbt.getInteger("maxHealth");
		healRate = nbt.getInteger("healRate");
		size = nbt.getFloat("size");
		topMoveSpeed = nbt.getFloat("topMoveSpeed");
		jumpMultiplier = nbt.getFloat("jumpStrength");
		breatheUnderwater = nbt.getBoolean("breatheUnderwater");
		catchOnFire = nbt.getBoolean("catchOnFire");
		
		if(worldObj != null && worldObj.isRemote && models == null){
//			System.out.println("Loading!!");
			loadRenderModels(worldObj);
		}
	}

	@SideOnly(Side.CLIENT)
	public void loadRenderModels(World world){
//		System.out.println("Loading Render Models!!!!!!Kjaw JKDJD!!");
		if(world == null){
			world = worldObj;
		}
		if(world == null){
			world = Minecraft.getMinecraft().theWorld;
		}
		if(world == null){
			System.out.println("Could not fetch world");
			return;
		}
		if(!world.isRemote){
			System.out.println("Waste of time grabbing models on server. Aborting");
			return;
		}
		
		ArrayList<Render> renders1 = new ArrayList<Render>();
		ArrayList<Integer> entityIds = new ArrayList<Integer>();
		for(int a = 0; a < mixedIds.length; a++){
			Render r = RenderManager.instance.getEntityClassRenderObject(EntityList.getClassFromID(mixedIds[a]));
			if(r != null){
				renders1.add(r);
				entityIds.add(mixedIds[a]);
			}
		}
		Render[] renders = renders1.toArray(new Render[renders1.size()]);
		ArrayList<ModelEntry> heads = new ArrayList<ModelEntry>();
		int headsMax = 1;
		ArrayList<ModelEntry> headWears = new ArrayList<ModelEntry>();
		int headWearsMax = 1;
		ArrayList<ModelEntry> ears = new ArrayList<ModelEntry>();
		int earsMax = 1;
		ArrayList<ModelEntry> bodies = new ArrayList<ModelEntry>();
		int bodiesMax = 1;
		ArrayList<ModelEntry> wings = new ArrayList<ModelEntry>();
		int wingsMax = 1;
		ArrayList<ModelEntry> arms = new ArrayList<ModelEntry>();
		int armsMax = 1;
		ArrayList<ModelEntry> legs = new ArrayList<ModelEntry>();
		int legsMax = 1;
		ArrayList<ModelEntry> randomModels = new ArrayList<ModelEntry>();
		int randomsMax = 1;
		Random random = new Random(1800L);
		for(int a = 0; a < renders.length; a++){
			Render renderBase = renders[a];
			if(renderBase instanceof RenderLiving){
				RenderLiving render = (RenderLiving)renderBase;
				ModelBase modelBase = MyPeopleRenderLivingAccessor.mainModel(render);
				int eId = entityIds.get(a);
				if(modelBase instanceof ModelBiped){
					ModelBiped model = (ModelBiped)modelBase;
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.bipedBody);
					new ModelEntry(eId, world, ears, ModelEntry.EAR).setModels(model.bipedEars);
					new ModelEntry(eId, world, headWears, ModelEntry.HEADWEAR).setModels(model.bipedHeadwear);
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.bipedHead);
					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.bipedLeftArm, model.bipedRightArm);
//					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.bipedRightArm);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.bipedLeftLeg, model.bipedRightLeg);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.bipedRightLeg);
				}else if(modelBase instanceof ModelQuadruped){
					ModelQuadruped model = (ModelQuadruped)modelBase;
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.head);
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.body);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg1, model.leg2, model.leg3, model.leg4);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg2);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg3);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg4);
				}else if(modelBase instanceof ModelSpider){
					ModelSpider model = (ModelSpider)modelBase;
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.spiderHead);
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.spiderBody);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg1, model.spiderLeg2, model.spiderLeg3, 
							model.spiderLeg4, model.spiderLeg5, model.spiderLeg6, model.spiderLeg7, model.spiderLeg8);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg2);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg3);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg4);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg5);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg6);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg7);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.spiderLeg8);
				}else if(modelBase instanceof ModelWolf){
					ModelWolf model = (ModelWolf)modelBase;
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.wolfHeadMain);
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.wolfBody);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.wolfLeg1, model.wolfLeg2, model.wolfLeg3, model.wolfLeg4);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.wolfLeg2);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.wolfLeg3);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.wolfLeg4);
				}else if(modelBase instanceof ModelChicken){
					ModelChicken model = (ModelChicken)modelBase;
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.head, model.chin, model.bill);
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.body);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leftLeg, model.rightLeg);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.rightLeg);
					new ModelEntry(eId, world, wings, ModelEntry.WING).setModels(model.leftWing, model.rightWing);
//					new ModelEntry(eId, world, wings, ModelEntry.WING).setModels(model.rightWing);
				}else if(modelBase instanceof ModelOcelot){
					ModelOcelot model = (ModelOcelot)modelBase;
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(MyPeopleModelAccessor.ocelotHead(model));
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(MyPeopleModelAccessor.ocelotBody(model));
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(MyPeopleModelAccessor.ocelotBackLeftLeg(model),
							MyPeopleModelAccessor.ocelotBackRightLeg(model), MyPeopleModelAccessor.ocelotFrontLeftLeg(model)
							, MyPeopleModelAccessor.ocelotFrontRightLeg(model));
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(MyPeopleModelAccessor.ocelotBackRightLeg(model));
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(MyPeopleModelAccessor.ocelotFrontLeftLeg(model));
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(MyPeopleModelAccessor.ocelotFrontRightLeg(model));
				}else if(modelBase instanceof ModelCreeper){
					ModelCreeper model = (ModelCreeper)modelBase;
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.body);
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.head);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg1, model.leg2, model.leg3, model.leg4);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg2);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg3);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leg4);
				}else if(modelBase instanceof ModelEnderman){
					ModelEnderman model = (ModelEnderman)modelBase;
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.bipedBody);
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.bipedHead);
					new ModelEntry(eId, world, headWears, ModelEntry.HEADWEAR).setModels(model.bipedHeadwear);
					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.bipedLeftArm, model.bipedRightArm);
//					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.bipedRightArm);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.bipedLeftLeg, model.bipedRightLeg);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.bipedRightLeg);
				}else if(modelBase instanceof ModelSnowMan){
					ModelSnowMan model = (ModelSnowMan)modelBase;
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.body);
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.head);
					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.leftHand, model.rightHand);
//					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.rightHand);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.bottomBody);
				}else if(modelBase instanceof ModelVillager){
					ModelVillager model = (ModelVillager)modelBase;
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.villagerBody);
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.villagerHead);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.leftVillagerLeg, model.rightVillagerLeg);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.rightVillagerLeg);
				}else if(modelBase instanceof ModelBlaze){
					ModelBlaze model = (ModelBlaze)modelBase;
					if(model.boxList.size() >= 13){
						ModelRenderer[] rods = new ModelRenderer[12];
						for(int b = 0; b < 12; b++){
							rods[b] = (ModelRenderer)model.boxList.get(b);
						}
						ModelRenderer head = (ModelRenderer)model.boxList.get(12);
						new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(head);
						new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(rods);
					}
				}else if(modelBase instanceof ModelSlime){
					ModelSlime model = (ModelSlime)modelBase;
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(MyPeopleModelAccessor.slimeBodies(model), MyPeopleModelAccessor.slimeMouth(model), MyPeopleModelAccessor.slimeLeftEye(model), MyPeopleModelAccessor.slimeRightEye(model));
				}else if(modelBase instanceof ModelMagmaCube){
					ModelMagmaCube model = (ModelMagmaCube)modelBase;
/*					ArrayList list = null;
					switch(random.nextInt(3)){
					case 0: list = heads; break;
					case 1: list = bodies; break;
					case 2: list = legs; break;
					default: list = heads; break;
					}*/
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(MyPeopleModelAccessor.magmaCubeList(model));
				}else if(modelBase instanceof ModelGhast){
					ModelGhast model = (ModelGhast)modelBase;
					ArrayList list = null;
					int type = -1;
					switch(random.nextInt(3)){
					case 0: list = heads; type = ModelEntry.HEAD; break;
					case 1: list = bodies; type = ModelEntry.BODY; break;
					default: list = heads; type = ModelEntry.HEAD; break;
					}
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(MyPeopleModelAccessor.ghastTentacles(model));
					new ModelEntry(eId, world, list, type).setModels(MyPeopleModelAccessor.ghastBody(model));
				}else if(modelBase instanceof ModelSquid){
					ModelSquid model = (ModelSquid)modelBase;
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(MyPeopleModelAccessor.squidTentacles(model));
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(MyPeopleModelAccessor.squidBody(model));
				}else if(modelBase instanceof ModelIronGolem){
					ModelIronGolem model = (ModelIronGolem)modelBase;
					new ModelEntry(eId, world, bodies, ModelEntry.BODY).setModels(model.ironGolemBody);
					new ModelEntry(eId, world, heads, ModelEntry.HEAD).setModels(model.ironGolemHead);
					new ModelEntry(eId, world, arms, ModelEntry.ARM).setModels(model.ironGolemLeftArm, model.ironGolemRightArm);
//					new ModelEntry(eId, world,  arms, ModelEntry.ARM).setModels(model.ironGolemRightArm);
					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.ironGolemLeftLeg, model.ironGolemRightLeg);
//					new ModelEntry(eId, world, legs, ModelEntry.LEG).setModels(model.ironGolemRightLeg);
				}else{
					for(int b = 0; b < modelBase.boxList.size(); b++){
						new ModelEntry(eId, world, randomModels, ModelEntry.RANDOM).setModels((ModelRenderer)modelBase.boxList.get(b));
					}
				}
			}
		}
		ArrayList<ModelEntry> modelsEnd = new ArrayList<ModelEntry>();
		add(modelsEnd, heads, headsMax, random);
		add(modelsEnd, headWears, headWearsMax, random);
		add(modelsEnd, ears, earsMax, random);
		add(modelsEnd, bodies, bodiesMax, random);
		add(modelsEnd, wings, wingsMax, random);
		add(modelsEnd, arms, armsMax, random);
		add(modelsEnd, legs, legsMax, random);
		add(modelsEnd, randomModels, randomsMax, random);
//		modelParts = modelsEnd.toArray(new ModelEntry[modelsEnd.size()]);
		for(int a = 0; a < modelsEnd.size(); a++){
			ModelEntry ent = modelsEnd.get(a);
			try{renderOnce(ent.entityID, world);}catch(Exception e){e.printStackTrace();}
		}
//		System.out.println("Made entity with " + modelsEnd.size() + " size.");
		this.models = new ModelMixed(modelsEnd.toArray(new ModelEntry[modelsEnd.size()]));
	}
	
	public void add(ArrayList<ModelEntry> out, ArrayList<ModelEntry> in, int max, Random r){
		if(max > in.size()){
			max = in.size();
		}
		if(max <= 0){
			return;
		}
		if(max != 1){
			max = r.nextInt(max-1)+1;
		}
		ArrayList<ModelEntry> inClone = (ArrayList<ModelEntry>)in.clone();
		for(int a = 0; a < max; a++){
			out.add(inClone.remove(r.nextInt(inClone.size())));
		}
	}
	
	public static String getEntitySkin(int entityId, World world){
		if(world != null){
			Entity e = EntityList.createEntityByID(entityId, world);
			if(e != null && e instanceof EntityLiving){
				return ((EntityLiving)e).getTexture();
			}
		}
		return null;
	}
	
	public EntityTrackerEntry getTracker(){
		if(worldObj != null && !worldObj.isRemote && worldObj instanceof WorldServer){
			EntityTracker tracker = ((WorldServer)worldObj).getEntityTracker();
			Object o = MyPeopleFieldGrabbers.trackedEntities(tracker);
			if(o != null){
				Set trackedEntities = (Set)o;
				for(Iterator<EntityTrackerEntry> it = trackedEntities.iterator(); it.hasNext();){
					EntityTrackerEntry entry = it.next();
					if(entry.myEntity == this){
						return entry;
					}
				}
			}
		}
		return null;
	}
	
	
	
	@Override
	public void onUpdate() {
		super.onUpdate();
		checkPlayerTrackersChanged();
	}



	EntityPlayerMP[] prevTrackingPlayers = new EntityPlayerMP[0];
	EntityPlayerMP[] trackingPlayers = new EntityPlayerMP[0];

	private int checkPlayerTimer;

	private int checkMobTimer;
	public void checkPlayerTrackersChanged() {
		if(worldObj != null && !worldObj.isRemote && this.ticksExisted % 5 == 0){
			EntityTrackerEntry entry = getTracker();
			if(entry != null){
				trackingPlayers = (EntityPlayerMP[]) entry.trackingPlayers.toArray(new EntityPlayerMP[entry.trackingPlayers.size()]);
				
				boolean changed = false;
				if(trackingPlayers.length == prevTrackingPlayers.length){
					for(int a = 0; a < trackingPlayers.length; a++){
						if(trackingPlayers[a].entityId != prevTrackingPlayers[a].entityId){
							changed = true;
							break;
						}
					}
					for(int a = 0; a < prevTrackingPlayers.length; a++){
						if(prevTrackingPlayers[a].entityId != trackingPlayers[a].entityId){
							changed = true;
							break;
						}
					}
				}else{
					changed = true;
				}
				if(changed){
					ArrayList<EntityPlayerMP> playerMPChanged = new ArrayList<EntityPlayerMP>();
					ArrayList<EntityPlayerMP> playerMPAll = new ArrayList<EntityPlayerMP>();
					for(int a = 0; a < trackingPlayers.length; a++){
						boolean didExist = false;
						for(int b = 0; b < prevTrackingPlayers.length; b++){
							if(prevTrackingPlayers[b].entityId == trackingPlayers[a].entityId){
								didExist = true;
								break;
							}
						}
						if(!didExist){
							playerMPChanged.add(trackingPlayers[a]);
						}
						playerMPAll.add(trackingPlayers[a]);
					}
					onWatchingChanged(playerMPChanged, playerMPAll);
				}
				prevTrackingPlayers = (EntityPlayerMP[]) entry.trackingPlayers.toArray(new EntityPlayerMP[entry.trackingPlayers.size()]);
			}
		}
	}
	
	public void onWatchingChanged(ArrayList<EntityPlayerMP> playerMPChanged, ArrayList<EntityPlayerMP> playerMPAll){
//		System.out.println("Going to go update");
		for(int a = 0; a < playerMPChanged.size(); a++){
			EntityPlayerMP player = playerMPChanged.get(a);
			if(player != null){
				NBTTagCompound nbt = new NBTTagCompound();
				writeVars(nbt);
				nbt.setInteger("entityId", entityId);
				
				
				MyPeople.packetHandler.sendPacketToClient(MyPeoplePacketType.clientUpdateCustomizedData.id, nbt, player);
			}
		}
	}
	
	public EntityCustomized load(SpawnData sd){
		mixedIds = sd.getMixedEntityIds();
		attackStrength = sd.attackStrength;
		maxHealth = sd.maxHealth;
		healRate = sd.healRate;
		size = sd.size;
		topMoveSpeed = sd.topMoveSpeed;
		breatheUnderwater = sd.breatheUnderwater;
		catchOnFire = sd.catchOnFire;
		return this;
	}
	
	
	public static void renderOnce(int entityId, World world){
//		System.out.println("Rendering with " + entityId);
		Entity e = EntityList.createEntityByID(entityId, world);
//		System.out.println("Created " + e);
		if(e != null && e instanceof EntityLiving){
//			System.out.println("Is living");
		    EntityLiving entity = (EntityLiving)e;	
	    	float par4 = 0;
	    	float par5 = 0;
	        GL11.glEnable(GL11.GL_COLOR_MATERIAL);
	        GL11.glPushMatrix();
	        GL11.glScalef((float)(-1), (float)1, (float)1);
	        GL11.glRotatef(180.0F, 0.0F, 0.0F, 1.0F);
	        float var6 = entity.renderYawOffset;
	        float var7 = entity.rotationYaw;
	        float var8 = entity.rotationPitch;
	        GL11.glRotatef(135.0F, 0.0F, 1.0F, 0.0F);
	        RenderHelper.enableStandardItemLighting();
	        GL11.glRotatef(-135.0F, 0.0F, 1.0F, 0.0F);
	        GL11.glRotatef(-((float)Math.atan((double)(par5 / 40.0F))) * 20.0F, 1.0F, 0.0F, 0.0F);
	        entity.renderYawOffset = (float)Math.atan((double)(par4 / 40.0F)) * 20.0F;
	        entity.rotationYaw = (float)Math.atan((double)(par4 / 40.0F)) * 40.0F;
	        entity.rotationPitch = -((float)Math.atan((double)(par5 / 40.0F))) * 20.0F;
	        entity.rotationYawHead = entity.rotationYaw;
	        GL11.glTranslatef(0.0F, entity.yOffset, 0.0F);
	        RenderManager.instance.playerViewY = 180.0F;
	        RenderManager.instance.renderEntityWithPosYaw(entity, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F);
	        entity.renderYawOffset = var6;
	        entity.rotationYaw = var7;
	        entity.rotationPitch = var8;
	        GL11.glPopMatrix();
	        RenderHelper.disableStandardItemLighting();
	        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
	        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
	        GL11.glDisable(GL11.GL_TEXTURE_2D);
	        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
	    }
	}
	
}
