package net.minecraft.mypeople;

import java.util.Collection;
import java.util.Iterator;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;

import org.lwjgl.opengl.GL11;

public class GuiTransferPlayerItems extends GuiContainer{
	EntityMyPerson player;
	EntityPlayer thePlayer;
	boolean isGuiForDefault = false;
	public GuiTransferPlayerItems(EntityMyPerson otherPlayer, EntityPlayer mainPlayer, boolean b) {
		super(new ContainerTransferPlayerItems(mainPlayer, otherPlayer));
		player = otherPlayer;
		thePlayer = mainPlayer;
		xSize = 176;
		ySize = 212;
		isGuiForDefault = b;
	}
	
	

    @Override
	protected void actionPerformed(GuiButton gb) {
    	if(gb.id==0){
    		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverTakeExperience.id, new Object[]{player.entityId/*, player.worldObj.getWorldInfo().getDimension()*/});
			mc.thePlayer.addExperience(player.experienceTotal);
			player.experience = 0;
			player.experienceLevel = 0;
			player.experienceTotal = 0;
			player.experienceValue = 0;
		}else if(gb.id == 1){
    		mc.displayGuiScreen(new GuiMyPersonOptions(player.options, player, this));
    	}else if(gb.id == 2){
			mc.displayGuiScreen(new GuiPlayerTeams(player, this));
		}else if(gb.id == 3){
			buildUp += .19f;
			if(buildUp >= 1.0f){
				MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverKillClone.id, new Object[]{
						player.entityId
				});
				mc.displayGuiScreen(null);
			}else{
				coloured.red = 1.0f;
				coloured.green = 1.0f-buildUp;
				coloured.blue = 1.0f-buildUp;
			}
		}else if(gb.id == 4){
			mc.displayGuiScreen(new GuiChooseAttackEntities(player, this));
		}else if(gb.id == 5){
			mc.displayGuiScreen(new GuiChooseBlocksToBreak(player, this));
		}else if(gb.id == 6){
			MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeOwner.id, new Object[]{player.entityId/*, player.worldObj.getWorldInfo().getDimension()*/});
		}else if(gb.id == 7){
			if(copyAmount != null){
				try{
					int amount = Integer.parseInt(copyAmount.getText());
					if(amount > 50){
						amount = 50;
					}
					if(amount > 0){
						MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverCopyClone.id, new Object[]{player.entityId, amount});
					}
				}catch(Exception e){
					mc.thePlayer.addChatMessage("\2474Could not parse text to number: " + copyAmount.getText());
				}	
			}
		}
	}

    GuiTextField copyAmount = null;
    
    GuiTeamButton coloured;
    float buildUp = 0;
	@Override
	public void initGui() {
    	buttonList.clear();
    	int bottom = height-20;
    	buttonList.add(new GuiButton(0, 5, 50, 100, 20, "Transfer XP"));
		buttonList.add(new GuiButton(1, 5, 75, 100, 20, "Options"));
		buttonList.add(new GuiButton(2, 5, 100, 100, 20, "Teams"));
		
		buttonList.add(new GuiButton(4, 5, 135, 110, 20, "Entities To Attack"));
		buttonList.add(new GuiButton(5, 5, 160, 110, 20, "Blocks To Break"));
		
		if(Minecraft.getMinecraft() != null){
			if(Minecraft.getMinecraft().session == null || Minecraft.getMinecraft().session.sessionId.equals("-")){
				buttonList.add(new GuiButton(6, width-120, height-30, 110, 20, "Claim clone"));
			}
		}
		GuiButton copy;
		buttonList.add(copy = new GuiButton(7, width - 105, 30, 100, 20, "Copy Clone"));
		copyAmount = new GuiOnlyTextField(mc.fontRenderer, width-105, 5, 100, 20, "01234567890\b");
		if(!mc.playerController.isInCreativeMode()){
			copy.drawButton = false;
			copyAmount.setVisible(false);
		}
		
		
/*		buttonList.add(new GuiButton(4, 5, 125, 100, 20, "Build Options"));
		buttonList.add(new GuiButton(5, 5, 150, 100, 20, "Mount Mode"));*/
		
		buttonList.add(coloured = new GuiTeamButton(3, 5, height - 35, 100, 20, "Kill.", 0xffffff, 0));
    	super.initGui();
	}



	@Override
	public void drawScreen(int par1, int par2, float par3) {
		super.drawScreen(par1, par2, par3);
		if(copyAmount != null){
			copyAmount.drawTextBox();
		}
	}



	protected void drawGuiContainerForegroundLayer()
    {
        fontRenderer.drawString("Tranfer Items", ((xSize/2)-(this.fontRenderer.getStringWidth("Tranfer Items")/2)), -8, 0xc0c0c0);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j)
    {
        int k = mc.renderEngine.getTexture("/MyPeople/transferplayeritems.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
//        mc.renderEngine.bindTexture(k);
        GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        int l = guiLeft;
        int i1 = guiTop;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        displayDebuffEffects();
        drawFood();
        drawXP();
        drawHealth();

    }
    
    
//52, 0
//61, 0
	private void drawHealth() {
		GL11.glBindTexture(3553 /*GL_TEXTURE_2D*/, mc.renderEngine.getTexture("/gui/icons.png"));
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		int x = 5;
		int y = height - 204;
		double outOfHealth = ((double)player.getMaxHealth())/2.0d;
		while(outOfHealth > 0){
			this.drawTexturedModalRect(x, y, 16, 0, 9, 9);
				//this.drawTexturedModalRect(x, y, 52, 0, 9, 9);
				outOfHealth = outOfHealth - 1;
			x = x + 9;
		}
		double health = ((double)player.getHealth())/2.0d;

		x = 5;
		while(health > 0){
			//this.drawTexturedModalRect(x, y, 16, 0, 9, 9);
			if(health > .5){
				this.drawTexturedModalRect(x, y, 52, 0, 9, 9);
				health = health - 1;
			}else{
				this.drawTexturedModalRect(x, y, 61, 0, 9, 9);
				health = health - .5;
			}
			x = x + 9;
		}
/*		int x = (width-182)/2;
		int y = height-10;
		float xpPercent = player.experience;
		drawTexturedModalRect(x, y, 0, 64, 182, 5);
		drawTexturedModalRect(x, y, 0, 69, (int)Math.round(182f*xpPercent), 5);*/
		
	}



	@Override
	protected void mouseClicked(int i, int j, int k) {
		super.mouseClicked(i, j, k);
		copyAmount.mouseClicked(i, j, k);
	}

	private void drawXP() {
		mc.renderEngine.bindTexture("/gui/icons.png");
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		int x = (width-182)/2;
		int y = height-10;
		float xpPercent = player.experience;
		drawTexturedModalRect(x, y, 0, 64, 182, 5);
		drawTexturedModalRect(x, y, 0, 69, (int)Math.round(182f*xpPercent), 5);
		String s = "" + player.experienceLevel;
		int k3 = (x+91)-((fontRenderer.getStringWidth(s)) / 2);
		mc.fontRenderer.drawString(s, k3, height-12, 0x80ff20);
	}

	private void drawFood() {
		
		mc.renderEngine.bindTexture("/gui/icons.png");
		int x = 5;
		int y = (height-20)-200;
		int across = 10;
		int down = 1;
		this.drawRect(x-1, y-1, x+(across*9)+1, y+(down*9)+1, 0x50dddddd);
		double d = player.foodStats.getFoodLevel();
		int add = 0;
		if (player.isPotionActive(Potion.hunger))
        {
            add = 36;
        }
		double d1 = (d==0?0:d/2d);
		for(int a = 0; a < across; a++){
			for(int b = 0; b < down; b++){
				double level = 10-(b*5+a);
				int x1 = x + a*9;
				int y1 = y + b*9;
				byte type = 0;
				if(d1 > level-1 && d1 < level){
					type = 1;
				}else if(d1 >= level){
					type = 0;
				}else if(d1 < level){
					type = -1;
				}
				drawTexturedModalRect(x1, y1, 16, 27, 9, 9);
				if(type >= 0)drawTexturedModalRect(x1, y1, 52+(type*9)+add, 27, 9, 9);
			}
			player.foodStats.getFoodLevel();
		}
		
	}
	
    private void displayDebuffEffects()
    {
        int i = guiLeft + this.xSize+2;
        int j = guiTop;
//        int k = mc.renderEngine.getTexture("/gui/inventory.png");
        Collection collection = player.getActivePotionEffects();

        if (collection.isEmpty())
        {
            return;
        }

        int l = 33;

        if (collection.size() > 5)
        {
            l = 132 / (collection.size() - 1);
        }

        for (Iterator iterator = player.getActivePotionEffects().iterator(); iterator.hasNext();)
        {
            PotionEffect potioneffect = (PotionEffect)iterator.next();
            Potion potion = Potion.potionTypes[potioneffect.getPotionID()];
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            mc.renderEngine.bindTexture("/gui/inventory.png");
            drawTexturedModalRect(i, j, 0, 166/**ABC*/, 140, 32);

            if (potion.hasStatusIcon())
            {
                int i1 = potion.getStatusIconIndex();
                drawTexturedModalRect(i + 6, j + 7, 0 + (i1 % 8) * 18, 166/**ABC*/ + 32 + (i1 / 8) * 18, 18, 18);
            }

            String s = StatCollector.translateToLocal(potion.getName());

            if (potioneffect.getAmplifier() == 1)
            {
                s = (new StringBuilder()).append(s).append(" II").toString();
            }
            else if (potioneffect.getAmplifier() == 2)
            {
                s = (new StringBuilder()).append(s).append(" III").toString();
            }
            else if (potioneffect.getAmplifier() == 3)
            {
                s = (new StringBuilder()).append(s).append(" IV").toString();
            }

            fontRenderer.drawStringWithShadow(s, i + 10 + 18, j + 6, 0xffffff);
            String s1 = Potion.getDurationString(potioneffect);
            fontRenderer.drawStringWithShadow(s1, i + 10 + 18, j + 6 + 10, 0x7f7f7f);
            j += l;
        }
    }




	public boolean doesGuiPauseGame() {
		return false;
	}

	
	
	@Override
	protected void keyTyped(char par1, int par2) {
		if(copyAmount != null){
			copyAmount.textboxKeyTyped(par1, par2);
		}
		super.keyTyped(par1, par2);
	}



	@Override
	public void updateScreen() {
		if(copyAmount != null){
			copyAmount.updateCursorCounter();
		}
		super.updateScreen();
	}



	@Override
	public void onGuiClosed() {
		super.onGuiClosed();
	}
    
    
    

}
