package net.minecraft.mypeople;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.mypeople.entity.EntityMyPerson;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;


public class GuiPlayerTeams extends GuiScreen {
	GuiScreen parentScreen;
	EntityMyPerson player;
	public GuiPlayerTeams(EntityMyPerson player, GuiScreen parent){
		this.player = player;
		parentScreen = parent;
	}

	public void drawScreen(int par1, int par2, float par3) {
		drawDefaultBackground();
		drawRect(posXBox, posYBox, posXBox+buttonWidth-1, posYBox+buttonHeight-1, 0xffffffff);
		super.drawScreen(par1, par2, par3);
		renderTraitorBox();
	}
	
	private void renderTraitorBox() {
		//mc.renderEngine.bindTexture(mc.renderEngine.getTexture("/gui/items.png"));
		GL11.glBindTexture(GL11.GL_TEXTURE_2D, mc.renderEngine.getTexture("/gui/items.png"));
		int i = Item.swordDiamond.itemID;
		int x = i % 16 * 16;
		int y = i / 16 * 16;
		drawTexturedModalRect(xTraitor+2, yTraitor+2, x, y, 16, 16);
		drawFlippedTexturedModalRect(xTraitor+buttonWidth-7-16, yTraitor+2, x, y, 16, 16);
	}

	private void drawFlippedTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
		float f = 0.00390625F;
        float f1 = 0.00390625F;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(par1 + 0, par2 + par6, zLevel, (float)(par3 + par5) * f, (float)(par4 + par6) * f1);
        tessellator.addVertexWithUV(par1 + par5, par2 + par6, zLevel, (float)(par3 + 0) * f, (float)(par4 + par6) * f1);
        tessellator.addVertexWithUV(par1 + par5, par2 + 0, zLevel, (float)(par3 + 0) * f, (float)(par4 + 0) * f1);
        tessellator.addVertexWithUV(par1 + 0, par2 + 0, zLevel, (float)(par3 + par5) * f, (float)(par4 + 0) * f1);
        tessellator.draw();

        
        
        
	}

	public void setSelected(int colourID){
		int posX = colourID / maxDown * buttonWidth;
		int posY = colourID % maxDown * buttonHeight;
		posXBox = posX-2;
		posYBox = posY-2;
	}

	protected void actionPerformed(GuiButton guibutton) {
		if(guibutton.id == 101){
			mc.displayGuiScreen(parentScreen);
		}else{
			changeSelected(guibutton);
		}
	}
	
	int xTraitor = 0, yTraitor = 0;
	
	int posXBox = 0;
	int posYBox = 0;
	int buttonWidth = 0;
	int buttonHeight = 0;
	int maxAcross = 0;
	int maxDown = 0;
	int max = 0;
	int position = 0;
	public void initGui() {
		buttonList.clear();
		buttonWidth = 155;
		buttonHeight = 25;
		maxAcross = width/buttonWidth;
		maxDown = height/buttonHeight;
		max = maxDown * maxAcross;
		PlayerTeam[] vals = PlayerTeam.values();
		for(int a = 0; a < vals.length; a++){
			if(player.team.teamID == vals[a].teamID){
				setSelected(position);
			}
			addColouredButton(vals[a].name(), vals[a].teamColour, vals[a].teamID);
			if(vals[a].teamID == PlayerTeam.Traitor.teamID){
				xTraitor = (position-1) / maxDown * buttonWidth;
				yTraitor = (position-1) % maxDown * buttonHeight;
			}
		}
		
		int posX = (max-1) / maxDown * buttonWidth;
		int posY = (max-1) % maxDown * buttonHeight;
		buttonList.add(new GuiButton(101, posX, posY, 100, 20, "Done"));
	}
	
	public void addColouredButton(String text, int colour, int teamID){
		int posX = position / maxDown * buttonWidth;
		int posY = position % maxDown * buttonHeight;
		buttonList.add(new GuiTeamButton(position, posX, posY, buttonWidth-5, buttonHeight-5, text, colour, teamID));
		position++;
	}
	
	public void changeSelected(GuiButton button){
		if(button instanceof GuiTeamButton){
			GuiTeamButton button2 = (GuiTeamButton)button;
			setSelected(button2.id);
			player.team = PlayerTeam.getByName(button2.displayString);
			player.sendPacketToAllAppropriate(MyPeople.packetHandler.create(MyPeoplePacketType.serverTeamChange.id, new Object[]{
					player.entityId/*, player.worldObj.getWorldInfo().getDimension()*/, player.team.teamID
			}, Side.SERVER), null);
		}
	}
	
	
	

}
