package net.minecraft.mypeople;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class GuiOptionButton extends GuiButton{
	
	MyPersonOption option;
	
	public GuiOptionButton(int par1, int par2, int par3, int par4, int par5, MyPersonOption option) {
		super(par1, par2, par3, par4, par5, "");
		this.option = option;
		updateLabel();
	}
	
	boolean lastValue = false;
	
	public void drawButton(Minecraft par1Minecraft, int par2, int par3) {
		super.drawButton(par1Minecraft, par2, par3);
		if(lastValue != option.value){
			updateLabel();
		}
	}

	public void updateLabel(){
		if(option != null){
			displayString = option.displayName + ": " + (option.value?"On":"Off");
			lastValue = option.value;
		}
	}
	
	@Override
	public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
		boolean pressed = super.mousePressed(par1Minecraft, par2, par3);
		if(pressed && option != null){
			option.toggle();
			updateLabel();
		}
		return pressed;
	}
	
	
	
	
	
	

}
