package net.minecraft.mypeople;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.mypeople.entity.EntityAttackEntry;
import net.minecraft.mypeople.entity.EntityMyPerson;

public class GuiChooseAttackEntities extends GuiScreen {

	EntityMyPerson clone;
	
	GuiScreen parent = null;
	
	GuiChooseAttackSlot slot;

	public static ArrayList<EntityAttackEntry> allEntities = new ArrayList<EntityAttackEntry>();
	
	public Minecraft getMc(){
		return mc;
	}
	
	public GuiChooseAttackEntities(EntityMyPerson clone, GuiScreen parent){
		this.clone = clone;
		this.parent = parent;
	}

	@Override
	public void initGui() {
		slot = new GuiChooseAttackSlot(this);
		slot.registerScrollButtons(buttonList, 0, 1);
		buttonList.add(new GuiButton(2, width/2 - 205, 5, 200, 20, "Select All"));
		buttonList.add(new GuiButton(3, width/2 + 5, 5, 200, 20, "Un Select All"));
		buttonList.add(new GuiButton(4, width/2 - 205, height-60, 200, 20, "Select All Mobs"));
		buttonList.add(new GuiButton(5, width/2 + 5, height-60, 200, 20, "Select All Animals"));
		buttonList.add(new GuiButton(6, (width-150)/2, height-30, 150, 20, "Back"));
		
		
	}
	
	
	
	

	@Override
	protected void actionPerformed(GuiButton gb) {
		if(gb.id == 2){
			for(int a = 0; a < allEntities.size(); a++){
				if(!clone.options.entitiesToAttack.contains(allEntities.get(a).theClass)){
					clone.options.entitiesToAttack.add(allEntities.get(a).theClass);
					onAdd(allEntities.get(a));
				}
			}
		}else if(gb.id == 3){
			for(int a = 0; a < allEntities.size(); a++){
				if(clone.options.entitiesToAttack.contains(allEntities.get(a).theClass)){
					clone.options.entitiesToAttack.remove(allEntities.get(a).theClass);
					onRemove(allEntities.get(a));
				}
			}
		}else if(gb.id == 4){
			for(int a = 0; a < allEntities.size(); a++){
				Class c = allEntities.get(a).theClass;
				if(hasInterface(c, IMob.class)){
					if(!clone.options.entitiesToAttack.contains(allEntities.get(a).theClass)){
						clone.options.entitiesToAttack.add(allEntities.get(a).theClass);
						onAdd(allEntities.get(a));
					}
				}
			}
		}else if(gb.id == 5){
			for(int a = 0; a < allEntities.size(); a++){
				Class c = allEntities.get(a).theClass;
				if(hasInterface(c, IAnimals.class)){
					if(!clone.options.entitiesToAttack.contains(allEntities.get(a).theClass)){
						clone.options.entitiesToAttack.add(allEntities.get(a).theClass);
						onAdd(allEntities.get(a));
					}
				}
			}
		}else if(gb.id == 6){
			mc.displayGuiScreen(parent);
		}
	}
	
	public boolean hasInterface(Class theClass, Class theInterface){
		Class superClass = theClass;
		do{
			Class<?>[] interfaces = superClass.getInterfaces();
			for(int a = 0; a < interfaces.length; a++){
				if(interfaces[a] == theInterface){
					return true;
				}
			}
			superClass = superClass.getSuperclass();
		}while(superClass != null);
		
		return false;
	}

	@Override
	public void drawScreen(int par1, int par2, float par3) {
		slot.drawScreen(par1, par2, par3);
		super.drawScreen(par1, par2, par3);
	}

	@Override
	protected void keyTyped(char par1, int par2) {
		if(par2 == 1){
			mc.displayGuiScreen(parent);
		}else{
			super.keyTyped(par1, par2);
		}
	}
	
	static{
		loadAllEntities();
	}

	private static void loadAllEntities() {
		Map<?, ?> map = MyPeopleFieldGrabbers.stringToClassMapping();
		if(map != null){
			System.out.println("If an error occurs after this text, you can ignore it, as it will probably be an instantiation exception, which is good, because it is just the code testing to see if the entity is spawnable.");
			for(Iterator it = map.entrySet().iterator(); it.hasNext();){
				Entry entry = (Entry) it.next();
				if(entry.getKey() instanceof String && entry.getValue() instanceof Class){
					String name = (String)entry.getKey();
					if(EntityList.createEntityByName(name, Minecraft.getMinecraft().theWorld) == null){
						continue;
					}
					Class theClass = (Class)entry.getValue();
					if(EntityLiving.class.isAssignableFrom(theClass)){
						if(!(name.equals("EnderDragon") || name.equals("Mob")) && theClass != EntityMyPerson.class){
							allEntities.add(new EntityAttackEntry(name, theClass));
						}
					}
				}
			}
			System.out.println("Okay, any errors after this are bad. Lol :)");
		}
	}

	public void onRemove(EntityAttackEntry entry) {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeAttack.id, new Object[]{clone.entityId/*, clone.worldObj.getWorldInfo().getDimension()*/, entry.theClass.getName(), true});
	}
	
	public void onAdd(EntityAttackEntry entry) {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeAttack.id, new Object[]{clone.entityId/*, clone.worldObj.getWorldInfo().getDimension()*/, entry.theClass.getName(), false});
	}
	
	
	
	
	
}
