package net.minecraft.mypeople;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockHumanEgg extends BlockContainer {

	int renderID = 0;
	
	protected BlockHumanEgg(int i) {
		super(i, Material.glass);
		setCreativeTab(CreativeTabs.tabMisc);
		this.setBlockBounds(0.0625F, 0.0F, 0.0625F, 0.9375F, 1.0F, 0.9375F);
	}	
    
    

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving, ItemStack par6ItemStack)
    {	String username = "";
    	if(par5EntityLiving != null && par5EntityLiving instanceof EntityPlayer){
			username = ((EntityPlayer)par5EntityLiving).username;
		}
    	par1World.setBlockTileEntity(par2, par3, par4, new TileEntityHumanEgg(par1World, username));
	}

	@Override
	public void onBlockAdded(World par1World, int par2, int par3, int par4) {
		if(!par1World.blockHasTileEntity(par2, par3, par4)){
			super.onBlockAdded(par1World, par2, par3, par4);
		}
	}



	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
		if(!par1World.isRemote){
			TileEntityHumanEgg tE = (TileEntityHumanEgg)par1World.getBlockTileEntity(par2, par3, par4);
			if(tE != null){
				par5EntityPlayer.sendChatToPlayer("\2476That egg belongs to \2477" + (tE.owner.equals(par5EntityPlayer.username)?"you":tE.owner.isEmpty()?"no one":tE.owner) + "\2476. It is " + (tE.zapped?"\2472currently":"currently\2474 not") + "\2476 incubating" + (tE.zapped?" with \2477" + tE.getTimeRemaining() + " \2476left.":"."));
			}
		}
		return true;
	}




	@Override
	public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.blocksList[l].canProvidePower())
        {
            boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
            if (flag)
            {
                TileEntity tileentity = world.getBlockTileEntity(i, j, k);
                if (tileentity != null && tileentity instanceof TileEntityHumanEgg)
                {
                    ((TileEntityHumanEgg)tileentity).onPowered();
                }
            }
        }
	}
    


	public boolean isOpaqueCube(){return false;}

    public boolean renderAsNormalBlock(){return false;}

    public int getRenderType(){
    	return renderID;
    }
    
    

	@Override
	public void registerIcons(IconRegister par1IconRegister) {
		blockIcon = par1IconRegister.registerIcon("MyPeople:humanEgg");
	}



	@Override
	public TileEntity createNewTileEntity(World var1) {
		return new TileEntityHumanEgg(var1);
	}



	public void setRenderID(int renderId) {
		this.renderID = renderId;
	}
}
