package net.minecraft.mypeople.item;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ItemTestTubeSpun extends Item{

	public ItemTestTubeSpun(int par1) {
		super(par1);
		this.setCreativeTab(CreativeTabs.tabBrewing);
	}
	
	

    public int getColorFromItemStack(ItemStack par1ItemStack, int par2)
    {
        EntityEggInfo entityegginfo = (EntityEggInfo)EntityList.entityEggs.get(Integer.valueOf(par1ItemStack.getItemDamage()));
        return entityegginfo != null ? (par2 == 0 ? entityegginfo.primaryColor : entityegginfo.secondaryColor) : 16777215;
    }

    public String getItemDisplayName(ItemStack par1ItemStack)
    {
    	String entityName = "";
        String s1 = EntityList.getStringFromID(par1ItemStack.getItemDamage());

        if (s1 != null)
        {
        	entityName = StatCollector.translateToLocal("entity." + s1 + ".name");
        }
        if(entityName == null || entityName.equals("") || entityName.isEmpty()){
        	entityName = "Your";
        }
        return entityName + " Blood, Seperated" ;
    }

	@Override
	public void registerIcons(IconRegister par1IconRegister) {
		itemIcon = par1IconRegister.registerIcon("MyPeople:testTubeSpun");
	}
	
	
	
	

}
