package net.minecraft.mypeople.item;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.SpawnData;
import net.minecraft.mypeople.entity.EntitySpawnEggThrow;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemCustomSpawnEgg extends Item{

	Icon capsule1, capsule2, capsule3, capsuleDNA;
	
	public ItemCustomSpawnEgg(int par1) {
		super(par1);
	}

	
	
	@Override
	public String getItemDisplayName(ItemStack par1ItemStack) {
		SpawnData spawnData = SpawnData.get(par1ItemStack);
		if(spawnData.loadedSuccesfully){
			return spawnData.getDisplayNameCapsule();
		}
		return super.getItemDisplayName(par1ItemStack);
	}



	@Override
	public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List l, boolean par4) {
		SpawnData spawnData = SpawnData.get(par1ItemStack);
		if(spawnData.loadedSuccesfully){
			String[] data = spawnData.getData();
			if(data != null){
				for(int a = 0; a < data.length; a++){
					l.add(data[a]);
				}
			}
		}
	}



	@Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
		if(!par3World.isRemote){
			SpawnData spawnData = SpawnData.get(par1ItemStack);
			if(spawnData != null && spawnData.loadedSuccesfully && spawnData.canPlace()){
				spawnData.spawnEntity(par3World, par4, par5, par6, par7);
				par1ItemStack.stackSize--;
			}
			if(par1ItemStack.stackSize <= 0){
				par1ItemStack = null;
			}
		}
		return true;
	}
	
	@SideOnly(value = Side.CLIENT)
	
	
	
	@Override
	public void registerIcons(IconRegister par1IconRegister) {
		itemIcon = par1IconRegister.registerIcon("MyPeople:capsule");
		capsule1 = par1IconRegister.registerIcon("MyPeople:capsule1");
		capsule2 = par1IconRegister.registerIcon("MyPeople:capsule2");
		capsule3 = par1IconRegister.registerIcon("MyPeople:capsule3");
		capsuleDNA = par1IconRegister.registerIcon("MyPeople:capsuleDNA");
		
		
	}

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
    {
    	SpawnData spawnData = SpawnData.get(par1ItemStack);
		if(spawnData != null && spawnData.loadedSuccesfully && spawnData.canPlace()){
			EntitySpawnEggThrow entity = new EntitySpawnEggThrow(par2World, par3EntityPlayer, par1ItemStack);
	        if (!par3EntityPlayer.capabilities.isCreativeMode)
	        {
	            --par1ItemStack.stackSize;
	        }
	        par2World.playSoundAtEntity(par3EntityPlayer, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 0.4F + 0.8F));
			par2World.spawnEntityInWorld(entity);
		}
        return par1ItemStack;
    }


	@Override
	public Icon getIconFromDamageForRenderPass(int par1, int par2) {
		if(par2 == 0){
			return capsule3;
		}else if(par2 == 1){
			return capsule2;
		}else if(par2 == 2){
			if(par1 == 0){
				return capsule1;
			}else{
				return capsuleDNA;
			}

		}
		return super.getIconFromDamageForRenderPass(par1, par2);
	}

	@Override
	public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
		SpawnData spawnData = SpawnData.get(par1ItemStack);
		if(spawnData != null && spawnData.loadedSuccesfully){
			if(par2>=0 && par2 <= 2){
				return spawnData.getColour(par2);
			}
		}
		return super.getColorFromItemStack(par1ItemStack, par2);
	}



	@Override
	public int getRenderPasses(int metadata) {
		return 3;
	}



	@Override
	public boolean requiresMultipleRenderPasses() {
		return true;
	}
    
    

}
