package net.minecraft.mypeople.entity;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.MyPeopleEntityAccessor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.mypeople.FoodStatsClone;
import net.minecraft.mypeople.GuiChooserPlayerToFind;
import net.minecraft.mypeople.GuiMyPersonOptions;
import net.minecraft.mypeople.GuiPlayerTeams;
import net.minecraft.mypeople.GuiTransferPlayerItems;
import net.minecraft.mypeople.InventoryMyPerson;
import net.minecraft.mypeople.MyPeople;
import net.minecraft.mypeople.MyPeopleFieldGrabbers;
import net.minecraft.mypeople.MyPeoplePacketType;
import net.minecraft.mypeople.MyPersonGuiHandler;
import net.minecraft.mypeople.MyPersonOption;
import net.minecraft.mypeople.MyPersonOptions;
import net.minecraft.mypeople.PlayerTeam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.MyPeopleWorldAccessor;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import cpw.mods.fml.relauncher.Side;

public class EntityMyPerson extends EntityLiving{

	public String username = "Steve", name = "", owner = "";
	
	public InventoryMyPerson inventory;
	public FoodStatsClone foodStats;
	
	public int xpCooldown = 0, experienceLevel = 0, experienceTotal = 0;
	public float experience = 0;
	
	public PlayerTeam team = PlayerTeam.Good;
	public MyPersonOptions options;
	
	public EntityLiving entityToAttack = null;
	public EntityLiving attackingEntity = null;
	//For when and if I implement fishing.
	public EntityLiving fishEntity = null;
	
	public float prevCameraYaw;
    public float cameraYaw;
	
    public float scale = .5f, maxScale = 1f, growthSpeed = .00001f;;
	
    public float nextScaleCheck = 0;
	
    public boolean hasAttacked = false;
	
	public EntityMyPerson(World par1World) {
		super(par1World);
		inventory = new InventoryMyPerson(this);
		foodStats = new FoodStatsClone(this);
		options = new MyPersonOptions(this);
		
		health = 10;
		
		yOffset = 0;
		
		this.setSize(.8f, 1.62f);
		
		this.entityType = "humanoid";
		setName("Steve");
		float previousMoveForward = moveForward;
		this.setAIMoveSpeed(.32f);
		this.moveForward = previousMoveForward;
		setAITasks();
		this.me = this;
    	this.jumpMovementFactor = .02f;
		


		ignoreFrustumCheck = true;
		moveSpeed = .32f;

		setAITasks();

	}
	
	EntityAIBreakBlock aiBreakBlocks;
	
	private void setAITasks() {
        this.tasks.addTask(0, new EntityAISwimming(this));
		this.tasks.addTask(1, new EntityAIAttackEnemies(this));
		this.tasks.addTask(1, new EntityAIAttackMe(this, EntityMob.class, 16));
		this.tasks.addTask(2, new EntityAIFollowCloneOwner(this));
		this.tasks.addTask(2, new EntityAICloneEat(this));
		this.tasks.addTask(3, aiBreakBlocks = new EntityAIBreakBlock(this));
		this.tasks.addTask(4, new EntityAICloneWalkToItems(this));
		this.tasks.addTask(4, new EntityAICloneWander(this, moveSpeed));
		this.tasks.addTask(4, new EntityAICloneLookIdle(this));
		this.tasks.addTask(4, new EntityAICloneReturnToGuard(this));
	}
	
	
	
	public boolean isInRangeToRenderVec3D(Vec3 par1Vec3) {
		return true;
	}

	public boolean isInRangeToRenderDist(double par1) {
		return true;
	}

	protected boolean canDespawn() {
		return false;
	}


    public float getEyeHeight()
    {
        return 1.62f * this.scale;
    }
	
    public float getReach(){
    	return 4.5f;
    }
    
	public boolean isAIEnabled()
    {
        return true;
    }
	//Names & Ownership
	public void setName(String name) {
		name = name.replace("\\", "/");
		username = name;
		this.name = username;
		if(username.startsWith("*")){
			int to = name.length();
			if(name.contains(".")){
				to = name.lastIndexOf(".");
			}
			if(name.contains("/")){
				if(!(name.lastIndexOf("/") > to)){
					this.name = name.substring(name.lastIndexOf("/")+1, to);
				}
				
			}else{
				this.name = name.substring(1, to);
			}
			
			
			this.texture = username.substring(1);
			if(!this.texture.startsWith("/")){
				this.texture = "/" + this.texture;
			}
			
			if(EntityMyPerson.class.getResource(this.texture) == null){
				this.texture = "/mob/char.png";
			}
			
		}else{
//			this.cloakUrl = "http://skins.minecraft.net/MinecraftCloaks/" + StringUtils.stripControlCodes(this.username) + ".png";
            this.skinUrl = "http://skins.minecraft.net/MinecraftSkins/" + StringUtils.stripControlCodes(username) + ".png";
			this.texture = "/mob/char.png";
			if(worldObj.isRemote){
				MyPeopleWorldAccessor.obtainEntitySkin(this, worldObj);
			}
		}

	}

	public EntityPlayer getOwner(){
		if(worldObj.isRemote){
			List players = worldObj.playerEntities;
			for(int a = 0; a < players.size(); a++){
				if(((EntityPlayer)players.get(a)).username.equals(owner)){
					return (EntityPlayer)players.get(a);
				}
			}
		}else{
			List list = MinecraftServer.getServerConfigurationManager(MinecraftServer.getServer()).playerEntityList;
			if(list != null){
				for(int a = 0; a < list.size(); a++){
					EntityPlayer player = (EntityPlayer)list.get(a);
					if(player != null && player.username.equals(owner)){
						return player;
					}
				}
			}
		}
		return null;
	}
	
	public boolean setOwnerIfEmpty(String ownerUsername){
		if(owner == null || !owner.isEmpty()){
			return false;
		}
		owner = ownerUsername;
		return true;
	}
	
	public boolean canUseThisEntity(String username){
		return (owner==null||owner.isEmpty()||!MyPeople.instance.owners?true:(owner.equals(username)));
	}
	
	public void setOwner(String ownerUsername){
		owner = ownerUsername;
	}
	
	//Health and Food
	@Override
	public int getMaxHealth() {
		return 10 + ((int)((scale-.5f)*20));
	}
	
	public boolean shouldHeal() {
		return this.getHealth() > 0 && this.getHealth() < this.getMaxHealth();
	}

    public void addExhaustion(float par1){
    	if (!this.worldObj.isRemote)
    	{
    		this.foodStats.addExhaustion(par1);
    	}
    }
    
	public FoodStatsClone getFoodStats() {
		return foodStats;
	}
	
	public void doKill() {
		onDeath(DamageSource.generic);
		dead = true;
		health = 0;
		GuiChooserPlayerToFind.throwParticles(this, new Random(), worldObj);
	}
	

	
	//Experience
	private void dropAllXP() {
		if(experienceTotal > 0){
			Random r = new Random();
			int xp = experienceTotal;
			if(xp > 85){
				xp = 85;
			}
			if(xp < 4){
				EntityXPOrb xpOrb = new EntityXPOrb(worldObj, posX, posY+.5, posZ, experienceTotal);
				xpOrb.motionX = (r.nextFloat()*2-1)/5;
				xpOrb.motionY = (r.nextFloat()*2-1)/5;
				xpOrb.motionZ = (r.nextFloat()*2-1)/5;
				xpOrb.moveEntity(xpOrb.motionX, xpOrb.motionY, xpOrb.motionZ);
				worldObj.spawnEntityInWorld(xpOrb);
			}else{
				int[] split = splitXP(xp);
				for(int a = 0; a < split.length; a++){
					EntityXPOrb xpOrb = new EntityXPOrb(worldObj, posX, posY+.5, posZ, split[a]);
					xpOrb.motionX = (r.nextFloat()*2-1)/5;
					xpOrb.motionY = (r.nextFloat()*2-1)/5;
					xpOrb.motionZ = (r.nextFloat()*2-1)/5;
					xpOrb.moveEntity(xpOrb.motionX, xpOrb.motionY, xpOrb.motionZ);
					worldObj.spawnEntityInWorld(xpOrb);
				}
			}
		}
		
	}
	public int[] splitXP(int xp){
		int[] ret = new int[4];
		int size = xp/4;
		for(int a = 0; a < ret.length; a++){
			ret[a] = size;
		}
		ret[3] = xp-(size*4) + size;
		return ret;
	}
	
	private void increaseLevel() {
		++this.experienceLevel;
	}
	
	public void addExperience(int par1) {
		int var2 = Integer.MAX_VALUE - this.experienceTotal;

		if (par1 > var2) {
			par1 = var2;
		}

		this.experience += (float) par1 / (float) this.xpBarCap();

		for (this.experienceTotal += par1; this.experience >= 1.0F; this.experience /= this
				.xpBarCap()) {
			this.experience = (this.experience - 1.0F) * this.xpBarCap();
			this.increaseLevel();
		}
//		updateExperienceToClient();
	}
	
	public int xpBarCap() {
		return this.experienceLevel >= 30 ? 62 + (this.experienceLevel - 30) * 7
				: (this.experienceLevel >= 15 ? 17 + (this.experienceLevel - 15) * 3
						: 17);
	}
	
	//Items:
	public boolean hasItemForBlock(int id, int meta) {
		if(id >= 0 && id < Block.blocksList.length){
			Block b = Block.blocksList[id];
			if(b != null){
				if(b.blockMaterial.isToolNotRequired()){
					return true;
				}else{
					for(int a = 0; a < 9; a++){
						ItemStack stack = inventory.mainInventory[a];
						if(stack != null){
							Item item = stack.getItem();
							if(item instanceof ItemTool){
								ItemTool theTool = (ItemTool)item;
								if(theTool.getStrVsBlock(stack, b) > 1.0f){
									return true;
								}
							}
						}
					}
					return false;
				}
			}
		}
		return true;
	}
    public ItemStack getCurrentEquippedItem()
    {
        return this.inventory.getCurrentItem();
    }
    
	public void destroyCurrentEquippedItem()
    {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, (ItemStack)null);
    }
	
	public int getItemInUseCount() {
		return 0;
	}
	
	public boolean selectToolForBlock(int id){
		if(id >= 0 && id < Block.blocksList.length){
			Block b = Block.blocksList[id];
			if(b != null){
				ItemStack currentTool = inventory.mainInventory[inventory.currentItem];
				if(currentTool != null && currentTool.getItem() instanceof ItemTool){
					ItemTool tool = (ItemTool)currentTool.getItem();
					if(tool.getStrVsBlock(currentTool, b) > 1.0f){
						return true;
					}
				}
				for(int a = 0; a < 9; a++){
					ItemStack stack = inventory.mainInventory[a];
					if(stack != null){
						Item item = stack.getItem();
						if(item instanceof ItemTool){
							ItemTool theTool = (ItemTool)item;
							if(theTool.getStrVsBlock(stack, b) > 1.0f){
								inventory.currentItem = a;
								setValue(11, a, null);
								return true;
							}
						}
					}
				}
			}
		}
		return false;
	}
	public void updateInventory(boolean allSlots, int[] specificSlots) {
		if(!worldObj.isRemote){
			if(allSlots){
				specificSlots = new int[inventory.mainInventory.length + inventory.armorInventory.length];
				for(int a = 0-inventory.armorInventory.length; a < inventory.mainInventory.length; a++){
					specificSlots[a+inventory.armorInventory.length] = a;
				}
			}
			NBTTagCompound nbt = new NBTTagCompound();
			nbt.setInteger("EntityId", entityId);
			nbt.setInteger("CurrentItem", inventory.currentItem);
			NBTTagList list = new NBTTagList();
			for(int a = 0; a < specificSlots.length; a++){
				NBTTagCompound tag = new NBTTagCompound();
				tag.setInteger("SlotId", specificSlots[a]);
				ItemStack stack = null;
				if(specificSlots[a] < 0){
					stack = inventory.armorInventory[specificSlots[a] + inventory.armorInventory.length];
				}else{
					stack = inventory.mainInventory[specificSlots[a]];
				}
				tag.setBoolean("Exists", stack != null);
				if(stack != null){
					NBTTagCompound item = new NBTTagCompound();
					stack.writeToNBT(item);
					tag.setTag("TheItem", item);
				}
				list.appendTag(tag);
			}
			nbt.setTag("Items", list);
			sendPacketToAllAppropriate(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateSpecificInventory.id, nbt, Side.CLIENT), null);
			
			
		}
	}
	
	public EntityItem dropPlayerItemWithRandomChoice(ItemStack par1ItemStack,
			boolean par2) {
		if (par1ItemStack == null) {
			return null;
		} else {
			EntityItem var3 = new EntityItem(this.worldObj, this.posX,
					this.posY - 0.30000001192092896D + this.getEyeHeight(),
					this.posZ, par1ItemStack);
			var3.delayBeforeCanPickup = 10;
			float var4 = 0.1F;
			float var5;

			if (par2) {
				var5 = this.rand.nextFloat() * 0.5F;
				float var6 = this.rand.nextFloat() * (float) Math.PI * 2.0F;
				var3.motionX = (-MathHelper.sin(var6) * var5);
				var3.motionZ = (MathHelper.cos(var6) * var5);
				var3.motionY = 0.20000000298023224D;
			} else {
				var4 = 0.3F;
				var3.motionX = (-MathHelper.sin(this.rotationYaw / 180.0F
						* (float) Math.PI)
						* MathHelper.cos(this.rotationPitch / 180.0F
								* (float) Math.PI) * var4);
				var3.motionZ = (MathHelper.cos(this.rotationYaw / 180.0F
						* (float) Math.PI)
						* MathHelper.cos(this.rotationPitch / 180.0F
								* (float) Math.PI) * var4);
				var3.motionY = (-MathHelper.sin(this.rotationPitch / 180.0F
						* (float) Math.PI)
						* var4 + 0.1F);
				var4 = 0.02F;
				var5 = this.rand.nextFloat() * (float) Math.PI * 2.0F;
				var4 *= this.rand.nextFloat();
				var3.motionX += Math.cos(var5) * var4;
				var3.motionY += ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1F);
				var3.motionZ += Math.sin(var5) * var4;
			}

			worldObj.spawnEntityInWorld(var3);
			return var3;
		}
	}

	
	//Networking
	//TODO Fix EntityTracking
	public EntityTrackerEntry getTracker(){
		if(worldObj != null && !worldObj.isRemote && worldObj instanceof WorldServer){
			EntityTracker tracker = ((WorldServer)worldObj).getEntityTracker();
			Object o = MyPeopleFieldGrabbers.trackedEntities(tracker);
			if(o != null){
				Set trackedEntities = (Set)o;
				for(Iterator<EntityTrackerEntry> it = trackedEntities.iterator(); it.hasNext();){
					EntityTrackerEntry entry = it.next();
					if(entry.myEntity == this){
						return entry;
					}
				}
			}
		}
		return null;
	}
	public void updateToAllWatchingPlayersOrOne(EntityPlayerMP playerMP){
		Object[] data = new Object[]{
entityId, username, owner, scale, experience, experienceLevel, experienceTotal, experienceValue, team.teamID, maxScale
, growthSpeed, foodStats.getFoodLevel(), foodStats.getSaturationLevel()
		};
		
		if(playerMP == null){
			EntityTrackerEntry tracker = getTracker();
			if(tracker != null){
				tracker.sendPacketToAllAssociatedPlayers(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateCloneInfo.id, 
						data, Side.CLIENT));
			}else{
				System.out.println("Error. Cannot get tracker.");
			}

		}else{
			playerMP.playerNetServerHandler.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateCloneInfo.id, 
					data, Side.CLIENT));
		}
		options.updateToAllWatchingOrPlayer(playerMP);
	}
	
	public void updateToAllEnd(DataInputStream input)throws IOException{
		setName(input.readUTF()); 
		owner = input.readUTF();
		scale = input.readFloat();
		experience = input.readFloat();
		experienceLevel = input.readInt();
		experienceTotal = input.readInt();
		experienceValue = input.readInt();
		team = PlayerTeam.getByID(input.readInt());
		maxScale = input.readFloat();
		growthSpeed = input.readFloat();
		foodStats.setFoodLevel(input.readInt());
		foodStats.setFoodSaturationLevel(input.readFloat());
	}
	
	
	public void setValue(int id, Object value, EntityPlayerMP player){
		if(worldObj.isRemote){
			sendPacketToAllAppropriate(MyPeople.packetHandler.create(MyPeoplePacketType.serverUpdateCloneInfoWithID.id, new Object[]{entityId, /*worldObj.getWorldInfo().getDimension(),*/ id, (value + "")}, Side.SERVER), player);
		}else{
			sendPacketToAllAppropriate(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateCloneInfoWithID.id, new Object[]{entityId, id, (value + "")}, Side.CLIENT), player);
		}
		
	}
	
	public void setOptionStart(String name, boolean value, EntityPlayerMP player){
		setValue(7, name + "\247" + value, player);
	}

	public void sendPacketToAllAppropriate(Packet packet, EntityPlayerMP player){
		if(worldObj.isRemote){
			MyPeople.packetHandler.sendPacketToServer(packet);
		}else{
			if(player != null){
				player.playerNetServerHandler.sendPacketToPlayer(packet);
			}else{
				EntityTrackerEntry tracker = getTracker();
				if(tracker != null){
					tracker.sendPacketToAllTrackingPlayers(packet);
				}else{
					System.out.println("Error. Cannot get tracker.");
				}
				
			}
		}
	}

	public boolean set(int ID, String s){
		switch(ID){
		case 0: scale = Float.parseFloat(s); return true;
		case 1: setName(s); return true;
		case 2: setOwner(s); return true;
		case 3: experience = Float.parseFloat(s); return true;
		case 4: experienceLevel = Integer.parseInt(s); return true;
		case 5: experienceTotal = Integer.parseInt(s); return true;
		case 6: experienceValue = Integer.parseInt(s); return true;
		case 7: return setOptionEnd(s);
		case 8: health = Integer.parseInt(s); return true;
		case 9: maxScale = Float.parseFloat(s); return true;
		case 10: growthSpeed = Float.parseFloat(s); return true;
		case 11: inventory.currentItem = Integer.parseInt(s); return true;
		case 12: foodStats.setFoodLevel(Integer.parseInt(s)); return true;
		case 13: foodStats.setFoodSaturationLevel(Float.parseFloat(s)); return true;
		}
		return false;
	}


	private boolean setOptionEnd(String o) {
		try{
			String[] split = o.split("\247");
			if(split.length == 2){
				String option = split[0];
				boolean value = Boolean.parseBoolean(split[1]);
				MyPersonOption personOption = options.nameToOption.get(option);
				if(personOption != null){
					personOption.set(value);
					return true;
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		return false;
	}
	
	public void updateSmallInventoryToWatchingPlayersOrOne(EntityPlayerMP player){
		ArrayList<Object> object = new ArrayList<Object>();
		object.add(entityId);
		object.add(0);
		int added = 0;
		for(int a = 0; a < 4; a++){
			if(inventory.armorInventory[a] != null){
				added++;
				object.add(a+100);
				object.add(inventory.armorInventory[a]);	
			}
		}
		if(inventory.mainInventory[0] != null){
			added++;
			object.add(0);
			object.add(inventory.mainInventory[0]);	
		}
		Object[] objs = object.toArray(new Object[object.size()]);
		objs[1] = added;
		if(player == null){
			EntityTrackerEntry tracker = getTracker();
			if(tracker != null){
				tracker.sendPacketToAllTrackingPlayers(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateInventory.id, objs, Side.CLIENT));
			}else{
				System.out.println("Error. Cannot get tracker.");
			}
			
		}else{
			player.playerNetServerHandler.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateInventory.id, objs, Side.CLIENT));
		}
	}
	
	public void onWatchingChanged(ArrayList<EntityPlayerMP> changed, ArrayList<EntityPlayerMP> all){
		for(int a = 0; a < changed.size(); a++){
			updateToAllWatchingPlayersOrOne(changed.get(a));
			updateSmallInventoryToWatchingPlayersOrOne(changed.get(a));
		}
	}
	
	public void updateExperienceToClient(){
		if(!worldObj.isRemote){
			this.setValue(3, experience, null);
			this.setValue(4, experienceLevel, null);
			this.setValue(5, experienceTotal, null);
			this.setValue(6, experienceValue, null);
		}
	}
	
	//Guard:
	
	public int guardPosX, guardPosY, guardPosZ;
	public float guardPitch, guardYaw;
	public boolean saidError = false;
	public void setGuardPosition() {
		guardPosX = (int)Math.floor(posX);
		guardPosY = (int)Math.floor(posY);
		guardPosZ = (int)Math.floor(posZ);
		guardPitch = rotationPitch;
		guardYaw = rotationYaw;
		saidError = false;
	}


	public void clearGuardPosition() {
		guardPosX = 0;
		guardPosY = 0;
		guardPosZ = 0;
		guardPitch = 0;
		guardYaw = 0;
		saidError = false;
	}
	//Mining
	
	public boolean notMining() {
		return !aiBreakBlocks.isMining;
	}
	
    public boolean isInsideSeeThrough(MovingObjectPosition mop, Entity e){
    	if(mop == null || e == null){
    		return false;
    	}
    	if(e.posX >= mop.blockX && e.posX-1 < mop.blockX){
    		if(e.posY >= mop.blockY && e.posY-1 < mop.blockY){
    			if(e.posZ >= mop.blockZ && e.posZ-1 < mop.blockZ){
    	    		return isSeeThroughBlock(mop.blockX, mop.blockY, mop.blockZ);
    	    	}
        	}
    	}
    	return false;
    	
    }
    
    public boolean isSeeThroughBlock(Block block){
    	if(block == null){
    		return false;
    	}
    	Material mat = block.blockMaterial;
    	if(mat != null){
    		if(!mat.isOpaque() || mat.isLiquid() || mat.equals(Material.air) || mat.equals(Material.glass) || mat.equals(Material.leaves) || mat.equals(Material.glass) || mat.equals(Material.ice) || mat.equals(Material.portal) || mat.equals(Material.plants)){
    			return true;
    		}
    	}
    	return false;
    }
    
    public boolean isSeeThroughBlock(int x, int y, int z){
    	int id = worldObj.getBlockId(x, y, z);
    	if(id > 0){

    		try{
    			Block block = Block.blocksList[id];
    			if(block != null){
    				return block.getCollisionBoundingBoxFromPool(worldObj, x, y, z) == null || isSeeThroughBlock(block);
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}
    	}
    	return false;
    }
	
    public boolean canHarvestBlock(Block par1Block)
    {
        return this.inventory.canHarvestBlock(par1Block);
    }
    
    public float getCurrentPlayerStrVsBlock(Block par1Block)
    {
        float var2 = this.inventory.getStrVsBlock(par1Block);
        int var3 = EnchantmentHelper.getEfficiencyModifier(this);
        ItemStack var4 = this.inventory.getCurrentItem();

        if (var3 > 0 && var4 != null)
        {
            float var5 = (float)(var3 * var3 + 1);

            if (!var4.canHarvestBlock(par1Block) && var2 <= 1.0F)
            {
                var2 += var5 * 0.08F;
            }
            else
            {
                var2 += var5;
            }
        }

        if (this.isPotionActive(Potion.digSpeed))
        {
            var2 *= 1.0F + (float)(this.getActivePotionEffect(Potion.digSpeed).getAmplifier() + 1) * 0.2F;
        }

        if (this.isPotionActive(Potion.digSlowdown))
        {
            var2 *= 1.0F - (float)(this.getActivePotionEffect(Potion.digSlowdown).getAmplifier() + 1) * 0.2F;
        }

        if (this.isInsideOfMaterial(Material.water) && !EnchantmentHelper.getAquaAffinityModifier(this))
        {
            var2 /= 5.0F;
        }

        if (!this.onGround)
        {
            var2 /= 5.0F;
        }

        return var2;
    }
    
	//EntityHandling:
	
    public boolean revenge = false;
    
    int attackDelay = 10;
    
    int arrowAttackDelay = 20;
    
    int timeSinceLastAttack = 0;
	
    public void setPathToEntity(PathEntity par1PathEntity)
    {
        this.getNavigator().setPath(par1PathEntity, moveSpeed);
    }
    
    public void setTarget(EntityLiving par1Entity)
    {
        this.entityToAttack = par1Entity;
        revenge = false;
    }
	
    public EntityLiving getEntityToAttack()
    {
        return this.entityToAttack;
    }
    
	@Override
	public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
		if(options.retaliate.value && par1DamageSource.getDamageType().toLowerCase().equals("mob")){
			if(options.fight.value){
				Entity e = par1DamageSource.getEntity();
				if(e != null && e instanceof EntityLiving){
					this.setTarget((EntityLiving)e);
					revenge = true;
				}
			}
		}else if(options.retaliate.value && par1DamageSource.getDamageType().toLowerCase().equals("player")){
			if(options.fight.value && team == PlayerTeam.Traitor){
				Entity e = par1DamageSource.getEntity();
				if(e != null && e instanceof EntityLiving){
					this.setTarget((EntityLiving)e);
					revenge = true;
				}
			}
		}else if(par1DamageSource == DamageSource.inWall){
			return false;
		}
		return super.attackEntityFrom(par1DamageSource, par2);
	}
	
	@Override
	protected void damageEntity(DamageSource par1DamageSource, int par2) {
		if(par1DamageSource != DamageSource.inWall){
			super.damageEntity(par1DamageSource, par2);
		}
        this.addExhaustion(par1DamageSource.getHungerDamage());
	}
    
	public void attackEntity(EntityLiving par1Entity, float par2) {
		if(timeSinceLastAttack == 0){
			if(options.jump.value && par2 < 4.75 && par2 > 3.75 && isCollidedVertically && !hasBowAndArrow(false)){
				this.jump();
			}
			if(par2 < 3){
				selectSword();
	    		attackTargetEntityWithCurrentItem(par1Entity);
	    		timeSinceLastAttack = attackDelay;
	    		this.addExhaustion(.3f);
	    	}else if(par2 <= 16 && getDistanceToEntityFromHead(par1Entity) < 16 && this. hasBowAndArrow(true)){
	    		attackArrow(par1Entity);
	    		inventory.consumeInventoryItem(Item.arrow.itemID);
	    		timeSinceLastAttack = arrowAttackDelay;
	    		this.addExhaustion(.3f);
	    	}
		}

    }
	
    /**
     * Returns the distance to the entity. Args: entity
     */
    public float getDistanceToEntityFromHead(Entity par1Entity)
    {
        float f = (float)(this.posX - par1Entity.posX);
        float f1 = (float)((this.posY + getEyeHeight()) - par1Entity.posY);
        float f2 = (float)(this.posZ - par1Entity.posZ);
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }
	
    public void attackTargetEntityWithCurrentItem(EntityLiving par1Entity)
    {
        if (par1Entity.canAttackWithItem())
        {
            if (!par1Entity.func_85031_j(this))
            {
                int var2 = this.inventory.getDamageVsEntity(par1Entity);

                if (this.isPotionActive(Potion.damageBoost))
                {
                    var2 += 3 << this.getActivePotionEffect(Potion.damageBoost).getAmplifier();
                }

                if (this.isPotionActive(Potion.weakness))
                {
                    var2 -= 2 << this.getActivePotionEffect(Potion.weakness).getAmplifier();
                }

                int var3 = 0;
                int var4 = 0;

                if (par1Entity instanceof EntityLiving)
                {
                    var4 = EnchantmentHelper.getEnchantmentModifierLiving(this, (EntityLiving)par1Entity);
                    var3 += EnchantmentHelper.getKnockbackModifier(this, (EntityLiving)par1Entity);
                }

                if (this.isSprinting())
                {
                    ++var3;
                }

                if (var2 > 0 || var4 > 0)
                {
                    boolean var5 = this.fallDistance > 0.0F && !this.onGround && !this.isOnLadder() && !this.isInWater() && !this.isPotionActive(Potion.blindness) && this.ridingEntity == null && par1Entity instanceof EntityLiving;

                    if (var5)
                    {
                        var2 += this.rand.nextInt(var2 / 2 + 2);
                    }

                    var2 += var4;
                    boolean var6 = false;
                    int var7 = EnchantmentHelper.getFireAspectModifier(this);

                    if (par1Entity instanceof EntityLiving && var7 > 0 && !par1Entity.isBurning())
                    {
                        var6 = true;
                        par1Entity.setFire(1);
                    }
                    swingItem();

                    boolean var8 = par1Entity.attackEntityFrom(DamageSource.causeMobDamage(this), var2);
                    if(par1Entity instanceof EntityPlayer){
                    	if(var8 == false){
                    		var8 = par1Entity.attackEntityFrom(DamageSource.generic, var2);
                    	}
                    }
                    if (var8)
                    {
                        if (var3 > 0)
                        {
                            par1Entity.addVelocity((double)(-MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0F) * (float)var3 * 0.5F), 0.1D, (double)(MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0F) * (float)var3 * 0.5F));
                            this.motionX *= 0.6D;
                            this.motionZ *= 0.6D;
                            this.setSprinting(false);
                        }


                        this.setLastAttackingEntity(par1Entity);

                        if (par1Entity instanceof EntityLiving)
                        {
                            EnchantmentThorns.func_92096_a(this, (EntityLiving)par1Entity, this.rand);
                        }
                    }

                    ItemStack var9 = this.getCurrentEquippedItem();

                    if (var9 != null && par1Entity instanceof EntityLiving)
                    {
                        var9.hitEntity((EntityLiving)par1Entity, new FakeEntityPlayer(this));

                        if (var9.stackSize <= 0)
                        {
                            this.destroyCurrentEquippedItem();
                        }
                    }

                    if (par1Entity instanceof EntityLiving)
                    {

                        if (var7 > 0 && var8)
                        {
                            par1Entity.setFire(var7 * 4);
                        }
                        else if (var6)
                        {
                            par1Entity.extinguish();
                        }
                    }

                    this.addExhaustion(0.3F);
                }
            }
        }
        if(par1Entity.getHealth() <= 0 && !worldObj.isRemote){
            int var1 = MyPeopleEntityAccessor.getExperiencePoints(par1Entity, null);
            while (var1 > 0)
            {
                int var2 = EntityXPOrb.getXPSplit(var1);
                var1 -= var2;
                this.worldObj.spawnEntityInWorld(new EntityXPOrb(this.worldObj, par1Entity.posX, par1Entity.posY, par1Entity.posZ, var2));
            }
        }
    }
	
	private boolean selectSword() {
		int bestSwordIndex = -1;
		float bestSwordDamage = -1;
		for(int a = 0; a < 9; a++){
			ItemStack item = inventory.mainInventory[a];
			if(item != null && ItemSword.class.isAssignableFrom(item.getItem().getClass())){
				ItemSword sword = (ItemSword)item.getItem();
				EnumToolMaterial mat = MyPeopleFieldGrabbers.toolMaterial(sword);
				if(mat != null){
					float goodness = mat.getEfficiencyOnProperMaterial();
					if(goodness > bestSwordDamage || bestSwordIndex < 0){
						bestSwordIndex = a;
						bestSwordDamage = goodness;
					}
				}
			}
		}
		if(bestSwordIndex > -1){
			inventory.setCurrentItem(bestSwordIndex);
		}
		return false;
	}
	


	public boolean hasBowAndArrow(boolean set){
		if(inventory.hasItem(Item.arrow.itemID)){
			for(int a = 0; a < 9; a++){
				ItemStack stack = inventory.mainInventory[a];
				if(stack != null && stack.itemID == Item.bow.itemID){
					if(set){
						inventory.setCurrentItem(a);
					}
					return true;
				}
			}
		}
		return false;
	}
    
    private void attackArrow(EntityLiving par1Entity) {
        EntityArrow var2 = new EntityArrow(this.worldObj, this, par1Entity, 1.6F, 0F);
        var2.canBePickedUp = 1;
        int var3 = EnchantmentHelper.getEnchantmentLevel(Enchantment.power.effectId, this.getHeldItem());
        int var4 = EnchantmentHelper.getEnchantmentLevel(Enchantment.punch.effectId, this.getHeldItem());

        if (var3 > 0)
        {
            var2.setDamage(var2.getDamage() + (double)var3 * 0.5D + 0.5D);
        }

        if (var4 > 0)
        {
            var2.setKnockbackStrength(var4);
        }

        if (EnchantmentHelper.getEnchantmentLevel(Enchantment.flame.effectId, this.getHeldItem()) > 0)
        {
            var2.setFire(100);
        }

        this.playSound("random.bow", 1.0F, 1.0F / (this.getRNG().nextFloat() * 0.4F + 0.8F));
        this.worldObj.spawnEntityInWorld(var2);
		
	}
    
	public void setPathToPosition(double x, double y, double z) {
		getNavigator().setPath(getNavigator().getPathToXYZ(x, y, z), moveSpeed);
	}
    
    public double getDistanceSqFromEye(double par1, double par3, double par5)
    {
        double var7 = this.posX - par1;
        double var9 = (this.posY+.5) - par3;
        double var11 = this.posZ - par5;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }
    
    public float getBlockPathWeight(int par1, int par2, int par3)
    {
        return this.worldObj.getBlockId(par1, par2 - 1, par3) == Block.grass.blockID ? 10.0F : this.worldObj.getLightBrightness(par1, par2, par3) - 0.5F;
    }
    
	EntityMyPerson me;


	//Interaction


    protected void jump()
    {
        this.motionY = 0.49D;

        if (this.isPotionActive(Potion.jump))
        {
            this.motionY += (double)((float)(this.getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.1F);
        }

        if (this.isSprinting())
        {
            float f = this.rotationYaw * 0.017453292F;
            this.motionX -= (double)(MathHelper.sin(f) * 0.2F);
            this.motionZ += (double)(MathHelper.cos(f) * 0.2F);
        }

        this.isAirBorne = true;
        ForgeHooks.onLivingJump(this);
    }
	
	@Override
	public boolean interact(EntityPlayer player) {
		if(!worldObj.isRemote){
			if(owner == null || owner.equals("")){
				owner = player.username;
				player.sendChatToPlayer("\2476You now own this clone!");
				setValue(2, owner, null);
			}
		}
		if(player instanceof EntityPlayerMP && canUseThisEntity(player.username)){
			player.openGui(MyPeople.instance, MyPersonGuiHandler.CLONEINVEN, worldObj, this.entityId, 0, 0);
		}
		return true;
	}

	public void onDeath(DamageSource par1DamageSource) {
		super.onDeath(par1DamageSource);
		if (!worldObj.isRemote) {
			inventory.dropAllItems();
			dropAllXP();
		}else{
			if(Minecraft.getMinecraft().currentScreen != null &&
				(Minecraft.getMinecraft().currentScreen instanceof GuiMyPersonOptions || 
						Minecraft.getMinecraft().currentScreen instanceof GuiTransferPlayerItems ||
						Minecraft.getMinecraft().currentScreen instanceof GuiPlayerTeams)){
				Minecraft.getMinecraft().displayGuiScreen(null);
				
			}
		}
		if(attackingEntity != null && attackingEntity.getAttackTarget() == this){
			attackingEntity.setAttackTarget(null);
		}
	}
	




	private void updateEntityCollide() {
        List var3 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0D, 0.5D, 1.0D));

        if (var3 != null)
        {
            for (int var4 = 0; var4 < var3.size(); ++var4)
            {
                Entity var5 = (Entity)var3.get(var4);

                if (!var5.isDead)
                {
                	onCollide(var5);
                }
            }
        }
	}
	
	public void onCollide(Entity e){
		if(e instanceof EntityItem && !dead){
			EntityItem eItem = (EntityItem)e;
	        if (!this.worldObj.isRemote)
	        {
	        	if(options.pickUp.value){
	        		if(eItem.delayBeforeCanPickup == 0){
	        			int prevSize = eItem.getEntityItem().stackSize;
		        		ItemStack stack = inventory.pickUpItem(eItem.getEntityItem());
		        		if(prevSize != stack.stackSize){
			                this.playSound("random.pop", 0.2F, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7F + 1.0F) * 2.0F);
			                onItemPickup(eItem, prevSize);
			                if(!worldObj.isRemote){
			                	this.updateInventory(true, null);
			                }
		        		}
		        		if(stack.stackSize <= 0){
		        			eItem.setDead();
		        		}
	        		}
	        	}
	        }
		}
	}
	
	
	@Override
	public void onItemPickup(Entity par1Entity, int par2) {
		if(!worldObj.isRemote){
			if(par1Entity instanceof EntityItem){
				EntityItem item = (EntityItem)par1Entity;
				if(item.getEntityItem().itemID == Item.speckledMelon.itemID){
					for(int a = 0; a < par2; a++){
						if(scale < maxScale){
							inventory.consumeInventoryItem(item.getEntityItem().itemID);
							scale = scale + .05f;
							if(scale > maxScale){
								scale = maxScale;
							}
						}
					}
					setValue(0, scale, null);
				}else if(item.getEntityItem().itemID == Item.netherStar.itemID){
					for(int a = 0; a < par2; a++){
						if(maxScale < 35){
							inventory.consumeInventoryItem(item.getEntityItem().itemID);
							maxScale = maxScale *2;
							if(maxScale > 35){
								maxScale = 35;
							}
						}
					}

					setValue(9, maxScale, null);
				}else if(item.getEntityItem().itemID == Item.appleGold.itemID){
					for(int a = 0; a < par2; a++){
						if(growthSpeed < 1){
							inventory.consumeInventoryItem(item.getEntityItem().itemID);
							growthSpeed = growthSpeed * 2;
							if(growthSpeed > 1){
								growthSpeed = 1;
							}
						}
					}
					setValue(10, growthSpeed, null);
				}else if(item.getEntityItem().getItem() instanceof ItemArmor){
					ItemArmor armor = (ItemArmor)item.getEntityItem().getItem();
					EnumArmorMaterial mat = armor.getArmorMaterial();
					int armorType = armor.armorType;
					int armorSlot = 3-armorType;
					ItemStack previous = inventory.armorInventory[armorSlot];
					if(previous == null){
						inventory.setArmorSlot(armorSlot, item.getEntityItem().copy());
						inventory.consumeInventoryItem(item.getEntityItem().itemID);
					}else{
						Item itemPrev = previous.getItem();
						if(itemPrev instanceof ItemArmor){
							ItemArmor prevArmor = (ItemArmor)itemPrev;
							int damageReduct1 = armor.getArmorMaterial().getDamageReductionAmount(armorType);
							int damageReduct2 = prevArmor.getArmorMaterial().getDamageReductionAmount(armorType);
							double durability1 = (double)item.getEntityItem().getItemDamage() / (double)armor.getArmorMaterial().getDurability(armorType);
							double durability2 = (double)previous.getItemDamage() / (double)prevArmor.getArmorMaterial().getDurability(armorType);
							if(damageReduct1 > damageReduct2 
									|| (damageReduct1 == damageReduct2?durability1 < durability2:false)){
								ItemStack newI = inventory.pickUpItem(previous.copy());
								if(newI.stackSize == 0){
									inventory.setArmorSlot(armorSlot, item.getEntityItem().copy());
									inventory.consumeInventoryItem(item.getEntityItem().itemID);
								}
							}
						}
					}
				}
			}
		}
	}
	
	//Updates
	
	public void onEntityUpdate() {
		super.onEntityUpdate();
		updateExp();
		updateEntityCollide();
	}
	
	public void onUpdate(){
		super.onUpdate();
		if(xpCooldown > 0){
			--xpCooldown;
		}
		checkPlayerTrackersChanged();
		checkHealthChanged();
		if(!worldObj.isRemote){
			foodStats.onUpdate(this);
		}
		this.updateArmSwingProgress();
		
	}
	
	@Override
	public void onLivingUpdate() {

		if(scale < maxScale){
			scale += growthSpeed * scale;
			if(scale > maxScale){
				scale = maxScale;
			}
		}else{
			if(scale > maxScale){
				scale = maxScale;
				nextScaleCheck = scale;
			}
		}
		if(maxScale > 35){
			maxScale = 35;
		}
		if(growthSpeed > 1){
			growthSpeed = 1;
		}
		if(maxScale > 1){
			maxScale = maxScale - .003f;
		}
		if(maxScale < 1){
			maxScale = 1f;
		}
		if(growthSpeed > 1){
			growthSpeed = 1;
		}
		if(growthSpeed > .00001f){
			growthSpeed = growthSpeed - .000005f;
		}
		if(growthSpeed < .00001f){
			growthSpeed = .00001f;
		}
		if(this.getHealth() > this.getMaxHealth() && this.ticksExisted > 100){
			this.health = this.getMaxHealth();
		}
		if(nextScaleCheck <= scale){
			this.setSize(.8f*scale, 1.62f*scale);
			float var7 = this.width / 2.0F;
        	float var8 = this.height;
        	this.boundingBox.setBounds(posX - (double)var7, posY - (double)this.yOffset + (double)this.ySize, posZ - (double)var7, posX + (double)var7, posY - (double)this.yOffset + (double)this.ySize + (double)var8, posZ + (double)var7);
        	nextScaleCheck = scale + .1f;
        	
        	this.getEyeHeight();
		}
		if(timeSinceLastAttack > 0){
			timeSinceLastAttack --;
		}
		if (this.worldObj.difficultySetting == 0 && this.getHealth() < this.getMaxHealth() && this.ticksExisted % 20 * 12 == 0)
        {
            this.heal(1);
        }
		if(getEntityToAttack() == null && options.guard.value && posX > guardPosX && posX < guardPosX+1 && posZ > guardPosZ && posZ < guardPosZ+1){
			this.setRotation(guardYaw, guardPitch);
		}
/*		if(aiBreakBlocks != null && !aiBreakBlocks.isMining && this.getEntityToAttack() == null && this.getNavigator().noPath() && inventory.currentItem != 0){
			inventory.setCurrentItem(0);
		}*/
		if(options.sprint.value){
			if(motionX!=0 || motionZ!=0){ 
				if(!isSprinting()){
					setSprinting(true);
				}
			}else if(isSprinting()){
				setSprinting(false);
			}
		}
		if(!options.guard.value && walkingToGuard){
			walkingToGuard = false;
		}
		super.onLivingUpdate();
	}
	
	private void checkHealthChanged() {
		if(!worldObj.isRemote){
			if(prevHealth != health){
				setValue(8, health, null);
			}
			prevHealth = health;
		}
	}

	EntityPlayerMP[] prevTrackingPlayers = new EntityPlayerMP[0];
	EntityPlayerMP[] trackingPlayers = new EntityPlayerMP[0];

	private int checkPlayerTimer;

	private int checkMobTimer;

	public boolean walkingToGuard = false;
	public void checkPlayerTrackersChanged() {
		if(worldObj != null && !worldObj.isRemote && this.ticksExisted % 5 == 0){
			EntityTrackerEntry entry = getTracker();
			if(entry != null){
				trackingPlayers = (EntityPlayerMP[]) entry.trackingPlayers.toArray(new EntityPlayerMP[entry.trackingPlayers.size()]);
				
				boolean changed = false;
				if(trackingPlayers.length == prevTrackingPlayers.length){
					for(int a = 0; a < trackingPlayers.length; a++){
						if(trackingPlayers[a].entityId != prevTrackingPlayers[a].entityId){
							changed = true;
							break;
						}
					}
					for(int a = 0; a < prevTrackingPlayers.length; a++){
						if(prevTrackingPlayers[a].entityId != trackingPlayers[a].entityId){
							changed = true;
							break;
						}
					}
				}else{
					changed = true;
				}
				if(changed){
					ArrayList<EntityPlayerMP> playerMPChanged = new ArrayList<EntityPlayerMP>();
					ArrayList<EntityPlayerMP> playerMPAll = new ArrayList<EntityPlayerMP>();
					for(int a = 0; a < trackingPlayers.length; a++){
						boolean didExist = false;
						for(int b = 0; b < prevTrackingPlayers.length; b++){
							if(prevTrackingPlayers[b].entityId == trackingPlayers[a].entityId){
								didExist = true;
								break;
							}
						}
						if(!didExist){
							playerMPChanged.add(trackingPlayers[a]);
						}
						playerMPAll.add(trackingPlayers[a]);
					}
					onWatchingChanged(playerMPChanged, playerMPAll);
				}
				prevTrackingPlayers = (EntityPlayerMP[]) entry.trackingPlayers.toArray(new EntityPlayerMP[entry.trackingPlayers.size()]);
			}
		}
	}
	
	public void updateExp(){
		List l = worldObj.getEntitiesWithinAABB(EntityXPOrb.class, boundingBox.expand(6, 2, 6));
		for(int a = 0; a < l.size(); a++){
			Object o = l.get(a);
			if(o instanceof EntityXPOrb){
				EntityXPOrb exp = (EntityXPOrb)o;
				if(!dead && xpCooldown == 0 && getDistanceSqToEntity(exp) < 1 && !worldObj.isRemote){
					int value = EntityPlayerLogic.getXPValue(exp);
	                xpCooldown = 2;
	                worldObj.playSoundAtEntity(this, "random.orb", 0.1F, 0.5F * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7F + 1.8F));
	                addExperience(value);
	                worldObj.removeEntity(exp);
				}else if(!dead){
		            double var3 = (posX - exp.posX) / 8;
		            double var5 = (posY + (double)getEyeHeight() - exp.posY) / 8;
		            double var7 = (posZ - exp.posZ) / 8;
		            double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
		            double var11 = 1.0D - var9;
		            if (var11 > 0.0D)
		            {
		                var11 *= var11;
		                exp.motionX += var3 / var9 * var11 * 0.1D;
		                exp.motionY += var5 / var9 * var11 * 0.1D;
		                exp.motionZ += var7 / var9 * var11 * 0.1D;
		            }
		            exp.moveEntity(exp.motionX, exp.motionY, exp.motionZ);
				}
			}
		}
	}
	
	//Saving and Loading
	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		NBTTagList inventoryList = nbt.getTagList("inventory");
		inventory.readFromNBT(inventoryList);
		foodStats.readNBT(nbt);
		int teamId = nbt.getShort("teamId");
		team = PlayerTeam.getByID(teamId);
		options.readEntityFromNBT(nbt);
		experienceLevel = nbt.getInteger("experienceLevel");
		experienceTotal = nbt.getInteger("experienceTotal");
		experience = nbt.getFloat("experience");
		scale = nbt.getFloat("scale");
		maxScale = nbt.getFloat("maxScale");
		growthSpeed = nbt.getFloat("growthSpeed");
		owner = nbt.getString("owner");
		String usernm = nbt.getString("username");
//		System.out.println("Read: " + usernm);
		setName(usernm);
//		System.out.println("Set: " + username);
		guardPosX = nbt.getInteger("guardPosX");
		guardPosY = nbt.getInteger("guardPosY");
		guardPosZ = nbt.getInteger("guardPosZ");
		guardYaw = nbt.getFloat("guardYaw");
		guardPitch = nbt.getFloat("guardPitch");
	}
	
	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		NBTTagList inventoryList = new NBTTagList();
		inventory.writeToNBT(inventoryList);
		nbt.setTag("inventory", inventoryList);
		foodStats.writeNBT(nbt);
		nbt.setShort("teamId", (short)team.teamID);
		options.writeEntityToNBT(nbt);
		nbt.setInteger("experienceLevel", experienceLevel);
		nbt.setInteger("experienceTotal", experienceTotal);
		nbt.setFloat("experience", experience);
		nbt.setFloat("scale", scale);
		nbt.setFloat("maxScale", maxScale);
		nbt.setFloat("growthSpeed", growthSpeed);
		nbt.setString("owner", owner);
//		System.out.println("Set username: " + username);
		nbt.setString("username", username);
		nbt.setInteger("guardPosX", guardPosX);
		nbt.setInteger("guardPosY", guardPosY);
		nbt.setInteger("guardPosZ", guardPosZ);
		nbt.setFloat("guardYaw", guardYaw);
		nbt.setFloat("guardPitch", guardPitch);
	}

}
