package net.minecraft.mypeople.entity;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MyPeopleItemAccessor;

public class EntityAICloneEat extends EntityAIBase {
	
	EntityMyPerson clone;
	
	public EntityAICloneEat(EntityMyPerson clone){
		this.clone = clone;
	}
	
	@Override
	public boolean shouldExecute() {
		if(clone.foodStats.needFood()){
			return true;
		}
		return false;
	}

	public boolean continueExecuting() {
		FakeEntityPlayer fep = null;
		for(int a = 0; a < clone.inventory.mainInventory.length; a++){
			ItemStack itemstack = clone.inventory.mainInventory[a];
			if(itemstack != null){
				Item item = itemstack.getItem();
				if(item instanceof ItemFood){
					ItemFood food = (ItemFood)item;
					if(fep == null){
						fep = new FakeEntityPlayer(clone);
					}
					MyPeopleItemAccessor.onFoodEaten(food, itemstack, fep.worldObj, fep);
					if(itemstack.stackSize <= 0){
						clone.inventory.setInventorySlotContents(a, null);
					}
					clone.getFoodStats().addStats(food);
					if(!clone.foodStats.needFood()){
						break;
					}
				}
			}
		}
		return super.continueExecuting();
	}


}
