package net.minecraft.mypeople;

import java.util.ArrayList;
import java.util.Random;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class TileEntitySplicer extends TileEntity implements IInventory{
	
	ItemStack[] inventory = new ItemStack[8];
	
	int furnaceBurnTime = 0, currentItemBurnTime = 0;//, timeSpun = 0;
	
	int totalTime = 1200;
	
	int timeSpliced = 0;
	
	public TileEntitySplicer(){
		
	}
	
	public float getFuelDone() {
		return (((float) furnaceBurnTime / ((float) currentItemBurnTime)));
	}
	
	
	@Override
	public int getSizeInventory() {
		return inventory.length;
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return inventory[i];
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		if (inventory[i] != null) {
			if (inventory[i].stackSize <= j) {
				ItemStack itemstack = inventory[i];
				inventory[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = inventory[i].splitStack(j);
			if (inventory[i].stackSize == 0) {
				inventory[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}
	
	public boolean canSplice(){
		if(inventory[0] != null && inventory[1] != null){
			if(isStackValidForSlot(0, inventory[0]) && isStackValidForSlot(1, inventory[1])){
				for(int a = 2; a < getSizeInventory(); a++){
					if(this.isStackValidForSlot(a, inventory[a])){
						return true;
					}
				}
			}
		}
		return false;
	}


	@Override
    public ItemStack getStackInSlotOnClosing(int par1)
    {
        if (inventory[par1] != null)
        {
            ItemStack itemstack = inventory[par1];
            inventory[par1] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
    }

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		inventory[i] = itemstack;
	}

	@Override
	public String getInvName() {
		return "Splicer";
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public int getInventoryStackLimit() {
		return 64;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		}
		return entityplayer.getDistanceSq((double) xCoord + 0.5D,
				(double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
	}

	@Override
	public void openChest() {}

	@Override
	public void closeChest() {}

	@Override
	public boolean isStackValidForSlot(int i, ItemStack stack) {
		//0 is fuel
		//1 is capsule
		//2-7 is needles
		if(stack != null){
			if(i == 0){
				return TileEntityFurnace.isItemFuel(stack);
			}else if(i == 1){
				return stack.itemID == MyPeople.emptyCapsule.itemID;
			}else if(i > 1){
				return stack.itemID == MyPeople.needleDNA.itemID;
			}
		}
		return false;
	}
	
	public boolean isSplicing(){
		return timeSpliced > 0;
	}
	
	@Override
	public void updateEntity() {
		if (furnaceBurnTime > 0) {
			furnaceBurnTime--;
		}
		if (furnaceBurnTime == 0 && canSplice() && isSplicing()) {
			currentItemBurnTime = furnaceBurnTime = TileEntityFurnace.getItemBurnTime(inventory[0]);
			if (furnaceBurnTime > 0) {
				inventory[0].stackSize--;
				if (inventory[0].stackSize <= 0) {
					inventory[0] = null;
				}
			}
		}
		if(isSplicing()){
			if(isBurning()){
				timeSpliced++;
//				isSplicing = true;
				if(timeSpliced == totalTime){
					timeSpliced = 0;
//					isSplicing = false;
					onSpliced();
				}

			}else{
//				isSplicing = false;
				timeSpliced = 0;
			}
		}else{
			if(canSplice()){
				startSplicing();
			}else if(timeSpliced > 0){
				timeSpliced = 0;
			}
		}
	}
	
	private void startSplicing() {
		timeSpliced = 1;
	}

	private void onSpliced(){
		ArrayList<Integer> ids = new ArrayList<Integer>();
		for(int a = 2; a < this.getSizeInventory(); a++){
			ItemStack stack = inventory[a];
			if(stack != null && stack.itemID == MyPeople.needleDNA.itemID){
				ids.add(stack.getItemDamage());
				stack.itemID = MyPeople.needleEmpty.itemID;
				stack.setItemDamage(0);
			}
		}
		SpawnData sd = new SpawnData();
		sd.setMixedEntityIds(ids);
		ItemStack stack = new ItemStack(MyPeople.customSpawnEgg);
		stack.setTagCompound(sd.toTagCompound());
		inventory[1] = stack;
	}
	
	public boolean isBurning() {
		return furnaceBurnTime > 0;
	}

	public void dropAllItems(World world, int x, int y, int z) {
		if(!world.isRemote){
			Random r = new Random();
			for(int a = 0; a < inventory.length; a++){
				if(inventory[a] != null){
					EntityItem item = new EntityItem(world, x+.5, y+.5, z+.5, inventory[a]);
					item.delayBeforeCanPickup = 10;
					item.setVelocity(get(r), (isSplicing()?.6f:.2f), get(r));
					world.spawnEntityInWorld(item);
				}
			}
		}
	}
	
	public float get(Random r){
		if(this.isSplicing()){
			return r.nextFloat()/.85f;
		}else{
			return r.nextFloat()/10;
		}
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		NBTTagList items = nbt.getTagList("items");
		for(int a = 0; a < items.tagCount(); a++){
			NBTTagCompound item = (NBTTagCompound)items.tagAt(a);
			int slotID = item.getInteger("slotID");
			inventory[slotID] = ItemStack.loadItemStackFromNBT(item);
		}
//		isSplicing() = nbt.getBoolean("isSplicing");
		timeSpliced = nbt.getInteger("timeSpliced");
		furnaceBurnTime = nbt.getInteger("furnaceBurnTime");
		currentItemBurnTime = nbt.getInteger("currentItemBurnTime");
	}

	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		NBTTagList items = new NBTTagList();
		for(int a = 0; a < inventory.length; a++){
			if(inventory[a] != null){
				NBTTagCompound item = new NBTTagCompound();
				item.setInteger("slotID", a);
				inventory[a].writeToNBT(item);
				items.appendTag(item);
			}
		}
		nbt.setTag("items", items);
//		nbt.setBoolean("isSplicing", isSplicing);
		nbt.setInteger("timeSpliced", timeSpliced);
		nbt.setInteger("furnaceBurnTime", furnaceBurnTime);
		nbt.setInteger("currentItemBurnTime", currentItemBurnTime);
		
	}
	
	public float getPercentDone() {
		return ((float)timeSpliced) / ((float)totalTime);
	}
	
	
	
}
