package net.minecraft.mypeople;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class TileEntityDnaCloner extends TileEntity implements IInventory{
	//0 Fuel, 1 Copied Item, 2,3,4, Blood, Water, Lava, 5-16, Items
	ItemStack[] items = new ItemStack[17];
	
	int furnaceBurnTime = 0, currentItemBurnTime = 0;
	
	int totalTime = 300;//TODO Change value to at least 1-2 minutes (x * 60 * 20)
	
	int timeCopied = 0;
	
	int blood, souls, water;
	
	
	public float getFuelDone() {
		return (((float) furnaceBurnTime / ((float) currentItemBurnTime)));
	}
	
	public float getCopyDone(){
		return ((float)timeCopied) / ((float)totalTime);
	}
	@Override
	public void updateEntity() {
		checkLiquids();
		if (furnaceBurnTime > 0) {
			furnaceBurnTime--;
		}
		if (furnaceBurnTime == 0 && canCopy(true)) {
			currentItemBurnTime = furnaceBurnTime = TileEntityFurnace.getItemBurnTime(items[0]);
			if (furnaceBurnTime > 0) {
				items[0].stackSize--;
				if (items[0].stackSize <= 0) {
					items[0] = null;
				}
			}
		}
		
		if(isBurning() && canCopy(false)){
			timeCopied++;
			if(timeCopied >= totalTime){
				timeCopied = 0;
				if(!worldObj.isRemote){
					onCopied();
				}
			}
		}else if(!isBurning() && isCopying()){
			timeCopied = 0;
		}else if(!canCopy(false) && isCopying()){
			timeCopied = 0;
		}
		
	}
	
	public void checkLiquids(){
		if(blood < 29){
			if(items[2] != null && items[2].itemID == MyPeople.testTubeBlood.itemID && items[2].getItemDamage() == 0){
				items[2].itemID = MyPeople.testTubeEmpty.itemID;
				items[2].setItemDamage(0);
				blood+=4;
			}
		}
		if(water < 29){
			if(items[3] != null && items[3].itemID == Item.bucketWater.itemID){
				items[3].itemID = Item.bucketEmpty.itemID;
				water+=4;
			}
		}
		if(souls < 25){
			if(items[4] != null && items[4].itemID == Block.slowSand.blockID){
    			while(souls < 25){
        			souls+=8;
        			items[4].stackSize--;
        			if(items[4].stackSize == 0){
        				items[4] = null;
        				break;
        			}
    			}
			}
		}

	}
	
	public boolean canCopy(boolean checkFuel){
		if(!checkFuel || TileEntityFurnace.isItemFuel(items[0])){
			if(items[1] != null && items[1].itemID == MyPeople.customSpawnEgg.itemID && SpawnData.isUnincubated(items[1])){
				if(blood > 0 && souls > 0 && water > 0){
					for(int a = 5; a < getSizeInventory(); a++){
						if(items[a] != null && items[a].itemID == MyPeople.emptyCapsule.itemID){
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	
	public void onCopied(){
		if(canCopy(false)){
			for(int a = getSizeInventory()-1; a >= 5; a--){
				if(items[a] != null && items[a].itemID == MyPeople.emptyCapsule.itemID){
					blood--;
					water--;
					souls--;
					items[a] = items[1].copy();
					break;
				}
			}
		}
	}
	
	public boolean isCopying(){
		return timeCopied > 0;
	}
	
	public boolean isBurning(){
		return furnaceBurnTime > 0;
	}

	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		NBTTagList itemss = nbt.getTagList("items");
		for(int a = 0; a < itemss.tagCount(); a++){
			NBTTagCompound item = (NBTTagCompound)itemss.tagAt(a);
			int slotID = item.getInteger("slotID");
			items[slotID] = ItemStack.loadItemStackFromNBT(item);
		}
		timeCopied = nbt.getInteger("timeCopied");
		furnaceBurnTime = nbt.getInteger("furnaceBurnTime");
		currentItemBurnTime = nbt.getInteger("currentItemBurnTime");
		blood = nbt.getInteger("blood");
		water = nbt.getInteger("water");
		souls = nbt.getInteger("lava");
	}

	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		NBTTagList itemss = new NBTTagList();
		for(int a = 0; a < items.length; a++){
			if(items[a] != null){
				NBTTagCompound item = new NBTTagCompound();
				item.setInteger("slotID", a);
				items[a].writeToNBT(item);
				itemss.appendTag(item);
			}
		}
		nbt.setTag("items", itemss);
		nbt.setInteger("timeCopied", timeCopied);
		nbt.setInteger("furnaceBurnTime", furnaceBurnTime);
		nbt.setInteger("currentItemBurnTime", currentItemBurnTime);
		nbt.setInteger("blood", blood);
		nbt.setInteger("water", water);
		nbt.setInteger("lava", souls);
	}
	
	@Override
	public int getSizeInventory() {
		return items.length;
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return items[i];
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		if (items[i] != null) {
			if (items[i].stackSize <= j) {
				ItemStack itemstack = items[i];
				items[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = items[i].splitStack(j);
			if (items[i].stackSize == 0) {
				items[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int i) {
        if (items[i] != null)
        {
            ItemStack itemstack = items[i];
            items[i] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		items[i] = itemstack;
		if (itemstack != null && itemstack.stackSize > getInventoryStackLimit()) {
			itemstack.stackSize = getInventoryStackLimit();
		}
	}

	@Override
	public String getInvName() {
		return "DNA Cloner";
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public int getInventoryStackLimit() {
		return 64;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		}
		return entityplayer.getDistanceSq((double) xCoord + 0.5D,
				(double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
	}

	@Override
	public void openChest() {}

	@Override
	public void closeChest() {}

	@Override
	public boolean isStackValidForSlot(int i, ItemStack itemstack) {
		return false;
	}
	
	public void dropAllItems(World world, int x, int y, int z) {
		if(!world.isRemote){
			Random r = new Random();
			for(int a = 0; a < items.length; a++){
				if(items[a] != null){
					EntityItem item = new EntityItem(world, x+.5, y+.5, z+.5, items[a]);
					item.delayBeforeCanPickup = 10;
					item.setVelocity(r.nextFloat()/10.0f, .2f, r.nextFloat()/10.0f);
					world.spawnEntityInWorld(item);
				}
			}
		}
	}


}
