package net.minecraft.mypeople;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.entity.EntitySpawnEggThrow;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.Icon;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class RenderCapsule extends Render{
    private Item field_94151_a;
    private int field_94150_f;

    public RenderCapsule(Item par1, int par2)
    {
        this.field_94151_a = par1;
        this.field_94150_f = par2;
    }

    public RenderCapsule(Item par1)
    {
        this(par1, 0);
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9)
    {
    	EntitySpawnEggThrow e = (EntitySpawnEggThrow)par1Entity;
    	
    	ItemStack stack = e.getItemStack();
    	if(stack != null){
        	
        	int passes = field_94151_a.getRenderPasses(field_94150_f);
        	for(int a = 0; a < passes; a++){
                Icon icon = this.field_94151_a.getIconFromDamageForRenderPass(field_94150_f, a);

                if (icon != null)
                {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)par2, (float)par4, (float)par6);
                    GL11.glEnable(GL12.GL_RESCALE_NORMAL);
                    GL11.glScalef(0.5F, 0.5F, 0.5F);
                    this.loadTexture("/gui/items.png");
                    Tessellator tessellator = Tessellator.instance;

                    if (icon == ItemPotion.func_94589_d("potion_splash"))
                    {
                        int i = PotionHelper.func_77915_a(((EntityPotion)par1Entity).getPotionDamage(), false);
                        float f2 = (float)(i >> 16 & 255) / 255.0F;
                        float f3 = (float)(i >> 8 & 255) / 255.0F;
                        float f4 = (float)(i & 255) / 255.0F;
                        GL11.glColor3f(f2, f3, f4);
                        GL11.glPushMatrix();
                        this.func_77026_a(tessellator, ItemPotion.func_94589_d("potion_contents"));
                        GL11.glPopMatrix();
                        GL11.glColor3f(1.0F, 1.0F, 1.0F);
                    }
                    int colour = field_94151_a.getColorFromItemStack(stack, a);
                    float r = ((float)((colour >> 16) & 0xff))/255.0f;
                    float g = ((float)((colour >> 8) & 0xff))/255.0f;
                    float b = ((float)(colour & 0xff))/255.0f;
                    
                    GL11.glColor4f(r, g, b, 1.0f);
                    
                    this.func_77026_a(tessellator, icon);
                    GL11.glDisable(GL12.GL_RESCALE_NORMAL);
                    GL11.glPopMatrix();
                }
        	}
    	}else{
            Icon icon = this.field_94151_a.getIconFromDamage(this.field_94150_f);

            if (icon != null)
            {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)par2, (float)par4, (float)par6);
                GL11.glEnable(GL12.GL_RESCALE_NORMAL);
                GL11.glScalef(0.5F, 0.5F, 0.5F);
                this.loadTexture("/gui/items.png");
                Tessellator tessellator = Tessellator.instance;

                if (icon == ItemPotion.func_94589_d("potion_splash"))
                {
                    int i = PotionHelper.func_77915_a(((EntityPotion)par1Entity).getPotionDamage(), false);
                    float f2 = (float)(i >> 16 & 255) / 255.0F;
                    float f3 = (float)(i >> 8 & 255) / 255.0F;
                    float f4 = (float)(i & 255) / 255.0F;
                    GL11.glColor3f(f2, f3, f4);
                    GL11.glPushMatrix();
                    this.func_77026_a(tessellator, ItemPotion.func_94589_d("potion_contents"));
                    GL11.glPopMatrix();
                    GL11.glColor3f(1.0F, 1.0F, 1.0F);
                }

                this.func_77026_a(tessellator, icon);
                GL11.glDisable(GL12.GL_RESCALE_NORMAL);
                GL11.glPopMatrix();
            }
    	}


    }

    private void func_77026_a(Tessellator par1Tessellator, Icon par2Icon)
    {
        float f = par2Icon.getMinU();
        float f1 = par2Icon.getMaxU();
        float f2 = par2Icon.getMinV();
        float f3 = par2Icon.getMaxV();
        float f4 = 1.0F;
        float f5 = 0.5F;
        float f6 = 0.25F;
        GL11.glRotatef(180.0F - this.renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
        GL11.glRotatef(-this.renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
        par1Tessellator.startDrawingQuads();
        par1Tessellator.setNormal(0.0F, 1.0F, 0.0F);
        par1Tessellator.addVertexWithUV((double)(0.0F - f5), (double)(0.0F - f6), 0.0D, (double)f, (double)f3);
        par1Tessellator.addVertexWithUV((double)(f4 - f5), (double)(0.0F - f6), 0.0D, (double)f1, (double)f3);
        par1Tessellator.addVertexWithUV((double)(f4 - f5), (double)(f4 - f6), 0.0D, (double)f1, (double)f2);
        par1Tessellator.addVertexWithUV((double)(0.0F - f5), (double)(f4 - f6), 0.0D, (double)f, (double)f2);
        par1Tessellator.draw();
    }
}
