package net.minecraft.mypeople;

public class MyPersonOption {
	
	public boolean value;
	
	public String name;
	
	public String displayName;
	
	public int id;
	
	public MyPersonOptions handler;
	
	public MyPersonOption(String name, String displayName, int id, boolean defaultValue, MyPersonOptions handler){
		this.name = name;
		this.displayName = displayName;
		this.id = id;
		value = defaultValue;
		this.handler = handler;
		handler.add(this);
	}
	
	public void toggle(){
		value = !value;
		update();
	}
	
	private void update() {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverUpdateOption.id, new Object[]{
				handler.clone.entityId/*, handler.clone.worldObj.getWorldInfo().getDimension()*/, name, value
		});
		
	}
	
	public void set(boolean b){
		value = b;

	}

}
