package net.minecraft.mypeople;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class MyPeopleTestTubeRecipes implements IRecipe{


	@Override
	public boolean matches(InventoryCrafting inventorycrafting, World world) {
		ItemStack needle = null, testTube = null;
		for(int a = 0; a < inventorycrafting.getSizeInventory(); a++){
			ItemStack stack = inventorycrafting.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == MyPeople.needleBlood.itemID){
					if(needle == null){
						needle = stack;
					}else{
						return false;
					}
				}else if(stack.itemID == MyPeople.testTubeEmpty.itemID){
					if(testTube == null){
						testTube = stack;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}
		}
		return needle != null && testTube != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
		ItemStack needle = null, testTube = null;
		for(int a = 0; a < inventorycrafting.getSizeInventory(); a++){
			ItemStack stack = inventorycrafting.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == MyPeople.needleBlood.itemID){
					if(needle == null){
						needle = stack;
					}else{
						return null;
					}
				}else if(stack.itemID == MyPeople.testTubeEmpty.itemID){
					if(testTube == null){
						testTube = stack;
					}else{
						return null;
					}
				}else{
					return null;
				}
			}
		}
		if(needle != null && testTube != null){
			return new ItemStack(MyPeople.testTubeBlood, 1, needle.getItemDamage());
		}
		return null;
	}

	@Override
	public int getRecipeSize() {
		return 10;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return null;
	}
}
