package net.minecraft.mypeople;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetServerHandler;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import cpw.mods.fml.relauncher.Side;

public class MyPeopleServerPacketHandler {
	
	public void processPacket(NetServerHandler net, Packet250CustomPayload var2){
//		System.out.println("Reveive");
		ByteArrayInputStream bIn = new ByteArrayInputStream(var2.data);
		DataInputStream input = new DataInputStream(bIn);
		try{
			int ID = input.readInt();
			if(ID == MyPeoplePacketType.serverCentrifuge.id){
				handleServerCentrifuge(net, input);
			}else if(ID == MyPeoplePacketType.serverUpdateCloneInfoWithID.id){
				handleServerUpdateCloneInfoWithID(net, input);
			}else if(ID == MyPeoplePacketType.serverUpdateOption.id){
				handleServerUpdateOption(net, input);
			}else if(ID == MyPeoplePacketType.serverKillClone.id){
				handleServerKillClone(net, input);
			}else if(ID == MyPeoplePacketType.serverTeamChange.id){
				handleServerTeamChange(net, input);
			}else if(ID == MyPeoplePacketType.serverTakeExperience.id){
				handleServerTakeExperience(net, input);
			}else if(ID == MyPeoplePacketType.serverChangeAttack.id){
				handleServerChangeAttack(net, input);
			}else if(ID == MyPeoplePacketType.serverChangeBreak.id){
				handleServerChangeBreak(net, input);
			}else if(ID == MyPeoplePacketType.serverChangeOwner.id){
				handleServerChangeOwner(net, input);
			}else if(ID == MyPeoplePacketType.serverUpdateTracker.id){
				handleServerUpdateTracker(net, input);
			}else if(ID == MyPeoplePacketType.serverTeleportClone.id){
				handleServerTeleportClone(net, input);
			}else if(ID == MyPeoplePacketType.serverCopyClone.id){
				handleServerCopyClone(net, input);
			}
			
			
			bIn.close();
			input.close();
		}catch(Exception e){
			e.printStackTrace();
		}
	}




	//Start Spinning Centrifuge
	public void handleServerCentrifuge(NetServerHandler net, DataInputStream input) throws IOException{
		World world = net.playerEntity.worldObj;
		if(world != null){
			TileEntity entity = world.getBlockTileEntity(input.readInt(), input.readInt(), input.readInt());
			if(entity != null && entity instanceof TileEntityCentrifuge){
				TileEntityCentrifuge tec = ((TileEntityCentrifuge)entity);
				if(tec.canSpin() && TileEntityFurnace.getItemBurnTime(tec.items[4])>0){
					tec.spinPressed = true;
				}
			}
		}
	}
	
	public void handleServerUpdateCloneInfoWithID(NetServerHandler net, DataInputStream input)throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			int id;
			String value;
			clone.set(id = input.readInt(), value = input.readUTF());
			clone.setValue(id, value, null);
		}
	}
	

	public void handleServerUpdateOption(NetServerHandler net, DataInputStream input) throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			String option = input.readUTF();
			boolean value = input.readBoolean();
			MyPersonOption personOption = clone.options.nameToOption.get(option);
			if(personOption != null){
				personOption.set(value);
				if(personOption.name.equals(clone.options.guard.name)){
					if(value){
						clone.setGuardPosition();
					}else{
						clone.clearGuardPosition();
					}
					if(value && clone.options.follow.value){
						clone.options.follow.set(false);
						clone.setOptionStart(clone.options.follow.name, false, null);
					}
				}
				clone.setOptionStart(option, value, null);
			}
		}
	}
	
	public void handleServerKillClone(NetServerHandler net, DataInputStream input) throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			clone.worldObj.playSoundAtEntity(clone, "random.explode", 1.0f, 1.0f);
			clone.sendPacketToAllAppropriate(MyPeople.packetHandler.create(MyPeoplePacketType.clientKillClone.id, new Object[]{
					clone.entityId
			}, Side.CLIENT), null);

			clone.onDeath(DamageSource.generic);
			clone.setDead();
		}
	}
	
	public void handleServerTeamChange(NetServerHandler net, DataInputStream input) throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			clone.team = PlayerTeam.getByID(input.readInt());
			clone.sendPacketToAllAppropriate(MyPeople.packetHandler.create(MyPeoplePacketType.clientTeamChange.id, new Object[]{
					clone.entityId, clone.team.teamID
			}, Side.CLIENT), null);
		}
	}
	
	public void handleServerTakeExperience(NetServerHandler net, DataInputStream input) throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			EntityPlayerMP player = net.playerEntity;
			player.addExperience(clone.experienceTotal);
			clone.experience = 0;
			clone.experienceTotal = 0;
			clone.experienceLevel = 0;
			clone.experienceValue = 0;
			clone.updateExperienceToClient();
		}
	}


	
	public void handleServerChangeAttack(NetServerHandler net, DataInputStream input)throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			String className = input.readUTF();
			boolean removing = input.readBoolean();
			try{
				Class c = Class.forName(className);
				if(removing){
					clone.options.entitiesToAttack.remove(c);
				}else{
					clone.options.entitiesToAttack.add(c);
				}
				clone.options.updateAttackableEntities(null);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	public void handleServerChangeBreak(NetServerHandler net, DataInputStream input)throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			int id = input.readInt();
			int meta = input.readInt();
			boolean removing = input.readBoolean();
			BreakBlockEntry entry = new BreakBlockEntry(id, meta);
			if(removing && clone.options.containsBreak(entry)){
				clone.options.remove(entry);
			}else if(!removing && !clone.options.containsBreak(entry)){
				clone.options.blocksCanBreak.add(entry.clone());
			}
			clone.options.updateBreakableBlocks(null);
		}
	}
	
	
	public void handleServerChangeOwner(NetServerHandler net, DataInputStream input)throws IOException{
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		if(clone != null){
			if(Minecraft.getMinecraft() != null){
				if(Minecraft.getMinecraft().session != null){
					if(Minecraft.getMinecraft().session.sessionId.equals("-")){
						if(clone.owner.equals(net.playerEntity.username)){
							net.playerEntity.sendChatToPlayer("\247cYou already own this clone!");
						}else{
							clone.setOwner(net.playerEntity.username);
							net.playerEntity.sendChatToPlayer("\2476You now own this clone!");
							clone.setValue(2, clone.owner, null);
						}
					}
				}
			}
		}
	}
	
	public void handleServerUpdateTracker(NetServerHandler net, DataInputStream input)throws IOException{
		List<EntityMyPerson> clones = MyPeople.instance.getAllClones();
		int entityID = input.readInt();
		if(entityID < 0){
			NBTTagCompound nbt = new NBTTagCompound();
			NBTTagList list = new NBTTagList();
			for(int a = 0; a < clones.size(); a++){
				NBTTagCompound entry = new NBTTagCompound();
				EntityMyPerson e = clones.get(a);
				if(e.owner == null || !e.owner.equals(net.playerEntity.username) || e.worldObj.getWorldInfo().getDimension() != net.playerEntity.worldObj.getWorldInfo().getDimension()){
					continue;
				}
				entry.setInteger("theEntityId", e.entityId);
				entry.setBoolean("isAttacking", e.getEntityToAttack()!=null);
				if(e.getEntityToAttack()!=null){
					entry.setString("attacker", e.getEntityToAttack().getEntityName());
				}
				entry.setBoolean("walking", !e.getNavigator().noPath());
				e.writeToNBT(entry);
				list.appendTag(entry);
				
			}
			nbt.setTag("Datas", list);
			net.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateTracker.id, nbt, Side.CLIENT));
		}else{
			for(int a = 0; a < clones.size(); a++){
				if(clones.get(a) != null && clones.get(a).entityId == entityID){
					MyPeople.packetHandler.sendPacketToClient(MyPeoplePacketType.clientUpdateTrackedClone.id, new Object[]{
							clones.get(a).posX, clones.get(a).posY, clones.get(a).posZ
					}, net.playerEntity);
					break;
				}
			}
		}
	}
	

	private void handleServerTeleportClone(NetServerHandler net, DataInputStream input)throws IOException{
		boolean type = input.readBoolean();
		int cloneId;
		EntityMyPerson clone = getEntityMyPersonIfUsable(cloneId = input.readInt(), net);
		if(clone != null){
			boolean tp = true;
			if(net.playerEntity.inventory.hasItem(Item.redstone.itemID)){
				net.playerEntity.inventory.consumeInventoryItem(Item.redstone.itemID);
			}else if(clone.inventory.hasItem(Item.redstone.itemID)){
				clone.inventory.consumeInventoryItem(Item.redstone.itemID);
			}else{
				tp = false;
			}
			Object[] data = new Object[]{tp, type, cloneId};
			if(tp){
				Entity to = null;
				Entity from = null;
				if(type){
					to = clone;
					from = net.playerEntity;
				}else{
					from = clone;
					to = net.playerEntity;
				}
				from.setPosition(to.posX, to.posY, to.posZ);
			}
			net.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientCloneTeleportResponse.id, data, Side.CLIENT));
		}
	}
	
	private void handleServerCopyClone(NetServerHandler net, DataInputStream input)throws IOException{
		if(!net.playerEntity.capabilities.isCreativeMode){
			net.playerEntity.sendChatToPlayer("\2474You are not in creative mode.");
			return;
		}
		EntityMyPerson clone = getEntityMyPersonIfUsable(input.readInt(), net);
		int amount = input.readInt();
		if(clone != null){
			if(amount > 50){
				amount = 50;
			}
			NBTTagCompound nbt = new NBTTagCompound();
			clone.writeToNBT(nbt);
			for(int a = 0; a < amount; a++){
				EntityMyPerson cloneNew = new EntityMyPerson(clone.worldObj);
				cloneNew.readFromNBT(nbt);
				clone.worldObj.spawnEntityInWorld(cloneNew);
			}
		}else{
			net.playerEntity.sendChatToPlayer("\2474You do not own that clone...");
		}
	}
	
	//--------------
	public static EntityPlayer getUserFromServer(String username){
		List l = MinecraftServer.getServerConfigurationManager(MinecraftServer.getServer()).playerEntityList;
		for(int a = 0; a < l.size(); a++){
			if(l.get(a) != null && l.get(a) instanceof EntityPlayer && ((EntityPlayer)l.get(a)).username.equals(username)){
				return (EntityPlayer)l.get(a);
			}
		}
		return null;
	}
	
	public static EntityPlayer getUserFromServer(int entityID){
		List l = MinecraftServer.getServerConfigurationManager(MinecraftServer.getServer()).playerEntityList;
		for(int a = 0; a < l.size(); a++){
			if(l.get(a) != null && l.get(a) instanceof EntityPlayer && ((EntityPlayer)l.get(a)).entityId == entityID){
				return (EntityPlayer)l.get(a);
			}
		}
		return null;
	}
	
	public static Entity getEntityByIDInWorld(int entityId, int worldId){
		WorldServer server = MinecraftServer.getServer().worldServerForDimension(worldId);
		if(server != null){
			return server.getEntityByID(entityId);
		}
		return null;
	}
	
	public static EntityMyPerson getEntityMyPerson(int entityID, int worldID){
		Entity e = getEntityByIDInWorld(entityID, worldID);
		if(e != null && e instanceof EntityMyPerson){
			return (EntityMyPerson)e;
		}
		return null;
	}
	
	public static EntityMyPerson getEntityMyPersonIfUsable(int entityID, NetServerHandler handler){
		Entity entity1 = handler.playerEntity.worldObj.getEntityByID(entityID);
		if(entity1 != null && entity1 instanceof EntityMyPerson){
			EntityMyPerson entity = (EntityMyPerson)entity1;
			if(entity.canUseThisEntity(handler.playerEntity.username)){
				return entity;
			}else{
				handler.playerEntity.sendChatToPlayer("\247c\"" + entity.username + "\" does not belong to you.");
			}
		}
		return null;
	}
	
	public static EntityMyPerson getEntityMyPersonIfUsable(int entityID, int worldID, NetServerHandler handler){
		EntityMyPerson entity = getEntityMyPerson(entityID, worldID);
		if(entity.canUseThisEntity(handler.playerEntity.username)){
			return entity;
		}else{
			handler.playerEntity.sendChatToPlayer("\247c\"" + entity.username + "\" does not belong to you.");
		}
		return null;
	}
}

//Client To Server
