package net.minecraft.mypeople;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.mypeople.item.ItemCustomSpawnEgg;
import net.minecraft.mypeople.item.ItemNeedleBlood;
import net.minecraft.mypeople.item.ItemNeedleDNA;
import net.minecraft.mypeople.item.ItemNeedleEmpty;
import net.minecraft.mypeople.item.ItemPersonFinder;
import net.minecraft.mypeople.item.ItemTestTubeBlood;
import net.minecraft.mypeople.item.ItemTestTubeEmpty;
import net.minecraft.mypeople.item.ItemTestTubeSpun;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "MyPeople", name="MyPeople", version="1.1.1")
@NetworkMod(clientSideRequired=true, serverSideRequired = false)
public class MyPeople {
	
	@Instance("MyPeople")
	public static MyPeople instance;

	public static int cloneID = 112;
	
	public static int customizedID = 113;
	
	public static MyPeoplePacketHandler packetHandler = null;
	
	public static MyPeopleServerPacketHandler serverHandler = new MyPeopleServerPacketHandler();
	public static MyPeopleClientPacketHandler clientHandler = new MyPeopleClientPacketHandler();
	
	public static Block centrifuge;
	
	public static Block humanEgg;
	
	public static Block splicer;
	
	public static Block incubator;
	
	public static Block dnaCloner;
	
	public static Item testTubeEmpty;
	
	public static Item testTubeBlood;
	
	public static Item testTubeSpun;
	
	public static Item needleEmpty;
	
	public static Item needleBlood;
	
	public static Item needleDNA;
	
	public static Item cloneTracker;
	
	
	public static Item customSpawnEgg;
	
	public static Item emptyCapsule;
	
	public EntityMyPerson cloneToFind;
    // Says where the client and server 'proxy' code is loaded.
    @SidedProxy(clientSide="net.minecraft.mypeople.ClientProxy", serverSide="net.minecraft.mypeople.ServerProxy")
    public static ServerProxy proxy;
   

   
    @Init
    public void load(FMLInitializationEvent event) {
    	centrifuge = new BlockCentrifuge(centrifugeId).setUnlocalizedName("centrifuge").setStepSound(Block.soundStoneFootstep).setHardness(3.5f);
    	humanEgg = new BlockHumanEgg(humanEggId).setUnlocalizedName("humanEgg").setHardness(3.5f).setStepSound(Block.soundStoneFootstep);
    	testTubeEmpty = new ItemTestTubeEmpty(testTubeEmptyId).setUnlocalizedName("testTubeEmpty");
    	testTubeBlood = new ItemTestTubeBlood(testTubeBloodId).setUnlocalizedName("testTubeBlood").setContainerItem(testTubeEmpty).setMaxStackSize(1);
    	testTubeSpun = new ItemTestTubeSpun(testTubeSpunId).setUnlocalizedName("testTubeSpun").setContainerItem(testTubeEmpty).setMaxStackSize(1);
    	needleEmpty = new ItemNeedleEmpty(needleEmptyId).setUnlocalizedName("needleEmpty");//.setMaxStackSize(64);
    	needleBlood = new ItemNeedleBlood(needleBloodId).setUnlocalizedName("needleBlood").setContainerItem(needleEmpty).setMaxStackSize(1);
    	needleDNA = new ItemNeedleDNA(needleDnaId).setUnlocalizedName("needleDNA").setContainerItem(needleEmpty).setMaxStackSize(1);
    	cloneTracker = new ItemPersonFinder(cloneTrackerId).setUnlocalizedName("cloneTracker").setMaxStackSize(1);
    	
    	proxy.registerRenderers();
    	
    	initNewData();
    	
    	GameRegistry.registerBlock(centrifuge, "centrifuge");
    	LanguageRegistry.addName(centrifuge, "Centrifuge");
    	GameRegistry.addRecipe(new ItemStack(centrifuge), new Object[]{
			"XYX", "YDY", "XYX", Character.valueOf('X'), Block.pistonBase, Character.valueOf('Y'), Item.ingotIron, Character.valueOf('D'), Item.diamond
		});
    	
    	GameRegistry.registerItem(testTubeEmpty, "testTubeEmpty");
    	LanguageRegistry.addName(testTubeEmpty, "Empty Test-Tube");
    	GameRegistry.addRecipe(new ItemStack(testTubeEmpty), new Object[]{
			"X X", "X X", "XXX", Character.valueOf('X'), Block.thinGlass
		});
    	
    	GameRegistry.registerItem(testTubeBlood, "testTubeBlood");
    	LanguageRegistry.addName(testTubeBlood, "Test-Tube of blood");
    	
    	GameRegistry.registerItem(testTubeSpun, "testTubeSpun");
    	LanguageRegistry.addName(testTubeSpun, "Seperated Blood Sample");
		
		GameRegistry.registerItem(needleEmpty, "needleEmpty");
		LanguageRegistry.addName(needleEmpty, "Empty Needle");
		GameRegistry.addRecipe(new ItemStack(needleEmpty), new Object[]{
			"XXX", "X X", " Y ", Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), Item.ingotGold
		});
		
		GameRegistry.registerItem(needleBlood, "needleBlood");
		LanguageRegistry.addName(needleBlood, "Needle Containing Blood");
		
		GameRegistry.registerItem(needleDNA, "needleDNA");
		LanguageRegistry.addName(needleDNA, "Needle containg Genomic DNA");
		
		GameRegistry.registerBlock(humanEgg, "humanEgg");
		LanguageRegistry.addName(humanEgg, "Human Egg");
		

		
		GameRegistry.registerItem(cloneTracker, "cloneTracker");
		LanguageRegistry.addName(cloneTracker, "Clone Tracker");
		GameRegistry.addShapelessRecipe(new ItemStack(cloneTracker), new Object[]{
			new ItemStack(testTubeSpun, 1, 0), new ItemStack(Item.compass)
		});
		

		GameRegistry.addRecipe(new MyPeopleEggRecipes());
		GameRegistry.addRecipe(new MyPeopleTestTubeRecipes());
		GameRegistry.addRecipe(new MyPeopleDnaNeedleRecipes());
		

		GameRegistry.registerTileEntity(net.minecraft.mypeople.TileEntityCentrifuge.class, "Centrifuge");
		GameRegistry.registerTileEntity(net.minecraft.mypeople.TileEntityHumanEgg.class, "HumanEgg");

		
		CentrifugeRenderHandler crh;
		RenderingRegistry.registerBlockHandler(crh = new CentrifugeRenderHandler(RenderingRegistry.getNextAvailableRenderId()));
		((BlockCentrifuge)centrifuge).setRenderID(crh.getRenderId());
		
		TileEntityRenderer.instance.specialRendererMap.put(net.minecraft.mypeople.TileEntityCentrifuge.class, new TileEntityCentrifugeRenderer());
		
		HumanEggRenderHandler hrh;
		RenderingRegistry.registerBlockHandler(hrh = new HumanEggRenderHandler(RenderingRegistry.getNextAvailableRenderId()));
		((BlockHumanEgg)humanEgg).setRenderID(hrh.getRenderId());
		
		RenderingRegistry.registerEntityRenderingHandler(net.minecraft.mypeople.entity.EntityMyPerson.class, new RenderMyPerson());
		EntityRegistry.registerGlobalEntityID(net.minecraft.mypeople.entity.EntityMyPerson.class, "MyPerson", cloneID, 0x00afaf, 0x463aa5);
		EntityRegistry.registerModEntity(net.minecraft.mypeople.entity.EntityMyPerson.class, "MyPerson", cloneID, this, 80, 3, true);
		

		
		LanguageRegistry.instance().addStringLocalization("entity.MyPerson.name", "Clone");
		
				
    	NetworkRegistry.instance().registerGuiHandler(this, new MyPersonGuiHandler());
    	packetHandler = new MyPeoplePacketHandler();
    	NetworkRegistry.instance().registerChannel(packetHandler, "MyPeopleClient");
    	NetworkRegistry.instance().registerChannel(packetHandler, "MyPeopleServer");
    }
    
    public void initNewData(){
    	
    	emptyCapsule = new Item(emptyCapsuleId).setUnlocalizedName("MyPeople:capsule").setCreativeTab(CreativeTabs.tabBrewing);
    	customSpawnEgg = new ItemCustomSpawnEgg(customSpawnEggId).setUnlocalizedName("customSpawnEgg").setMaxStackSize(1);
    	splicer = new BlockSplicer(splicerId).setUnlocalizedName("MyPeople:blockSplicer").setCreativeTab(CreativeTabs.tabBrewing);
    	incubator = new BlockIncubator(incubatorId).setUnlocalizedName("MyPeople:incubator").setCreativeTab(CreativeTabs.tabBrewing);
    	dnaCloner = new BlockDnaCloner(dnaClonerId).setUnlocalizedName("MyPeople:dnaCloner").setCreativeTab(CreativeTabs.tabBrewing);
    	
   		GameRegistry.registerBlock(splicer, "splicer");
		LanguageRegistry.addName(splicer, "DNA Splicer");
		GameRegistry.addRecipe(new ItemStack(splicer), new Object[]{
			"AYA", "YXY", "AYA", Character.valueOf('Y'), Block.pistonBase, Character.valueOf('X'), Block.thinGlass, Character.valueOf('A'), Item.bucketEmpty
		});
		
		GameRegistry.registerBlock(incubator, "incubator");
		LanguageRegistry.addName(incubator, "Incubator");
		GameRegistry.addRecipe(new ItemStack(incubator), new Object[]{
			"YYY", "YXY", "YYY", Character.valueOf('X'), Block.furnaceIdle, Character.valueOf('Y'), Block.cloth
		});
		
		GameRegistry.registerBlock(dnaCloner, "dnaCloner");
		LanguageRegistry.addName(dnaCloner, "DNA Cloner");
		GameRegistry.addRecipe(new ItemStack(dnaCloner), new Object[]{
			"WYW", "ZXZ", "WYW", Character.valueOf('X'), Item.diamond, Character.valueOf('Y'), needleEmpty,
			Character.valueOf('Z'), Item.paper, Character.valueOf('W'), Item.ingotIron
		});
    	
		GameRegistry.registerItem(emptyCapsule, "emptyCapsule");
		LanguageRegistry.addName(emptyCapsule, "Empty Capsule");
		GameRegistry.addRecipe(new ItemStack(emptyCapsule, 4), new Object[]{
			" X ", "XAX", " X ", Character.valueOf('X'), Item.ingotIron, Character.valueOf('A'), Block.thinGlass
		});
		
		GameRegistry.registerItem(customSpawnEgg, "customSpawnEgg");
		
		ItemStack result = new ItemStack(customSpawnEgg);
		SpawnData sd = new SpawnData();
		sd.setMixedEntityIds(92, 96);
		result.setTagCompound(sd.toTagCompound());
		GameRegistry.addRecipe(result, new Object[]{
				"X X", Character.valueOf('X'), Block.planks
		});
		
    	
		GameRegistry.registerTileEntity(net.minecraft.mypeople.TileEntityDnaCloner.class, "DNACloner");
		GameRegistry.registerTileEntity(net.minecraft.mypeople.TileEntitySplicer.class, "DNASplicer");
		GameRegistry.registerTileEntity(net.minecraft.mypeople.TileEntityIncubator.class, "Incubator");
    	
		RenderingRegistry.registerEntityRenderingHandler(net.minecraft.mypeople.entity.EntityCustomized.class, new RenderMixedEntity());
		EntityRegistry.registerGlobalEntityID(net.minecraft.mypeople.entity.EntityCustomized.class, "CustomizedEntity", customizedID);
		EntityRegistry.registerModEntity(net.minecraft.mypeople.entity.EntityCustomized.class, "CustomizedEntity", customizedID, this, 80, 3, true);
		
		RenderingRegistry.registerEntityRenderingHandler(net.minecraft.mypeople.entity.EntitySpawnEggThrow.class, new RenderCapsule(customSpawnEgg));
	
    }

   
    @PostInit
    public void postInit(FMLPostInitializationEvent event) {
    	
    }
	
    @PreInit
    public void preInit(FMLPreInitializationEvent event) {
    	File suggested = event.getSuggestedConfigurationFile();
    	if(suggested.exists()){
    		BufferedReader reader = null;
    		boolean delete = false;
    		try{
    			reader = new BufferedReader(new FileReader(suggested));
    			String s = reader.readLine();
    			if(s != null && !s.equals("# Configuration file")){
    				System.out.println("Read " + s);
    				delete = true;
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			if(reader != null){
    				try{
    					reader.close();	
    				}catch(Exception e){
    					e.printStackTrace();
    				}
    			}
    		}
    		if(delete){
        		System.out.print("Detected old config file. Deleting....");
        		try{
            		suggested.delete();
        		}catch(Exception e){
        			e.printStackTrace();
        		}
        		System.out.println("Deleted");
    		}

    	}
    	Configuration config = new Configuration(event.getSuggestedConfigurationFile());
    	config.load();
    	centrifugeId = config.getBlock("Centrifuge", 489).getInt();
    	humanEggId = config.getBlock("HumanEgg", 490).getInt();
    	splicerId = config.getBlock("Splicer", 491).getInt();
    	incubatorId = config.getBlock("incubator", 492).getInt();
    	dnaClonerId = config.getBlock("dnaCloner", 493).getInt();
    	
    	testTubeEmptyId = config.getItem("TestTubeEmpty", 4832).getInt();
    	testTubeBloodId = config.getItem("TestTubeBlood", 4833).getInt();
    	testTubeSpunId = config.getItem("TestTubeSeperated", 4834).getInt();
    	needleEmptyId = config.getItem("NeedleEmpty", 4835).getInt();
    	needleBloodId = config.getItem("NeedleBlood", 4836).getInt();
    	needleDnaId = config.getItem("NeedleDna", 4837).getInt();
    	cloneTrackerId = config.getItem("CloneTracker", 4838).getInt();
    	customSpawnEggId = config.getItem("CustomSpawnEgg", 4839).getInt();
    	emptyCapsuleId = config.getItem("emptyCapsule", 4840).getInt();
    	owners = config.get("Settings", "Ownership", true, "Changes whether clones can be accessed by people who did not create them.").getBoolean(true);
    	
    	config.save();
    }
    public boolean owners = true;
    public int centrifugeId, humanEggId, testTubeEmptyId, testTubeBloodId, testTubeSpunId
    , needleEmptyId, needleBloodId, needleDnaId, cloneTrackerId, customSpawnEggId
    , emptyCapsuleId, splicerId, incubatorId, dnaClonerId;





	public List<EntityMyPerson> getAllClones(){
		ArrayList<EntityMyPerson> toRet = new ArrayList<EntityMyPerson>();
		MinecraftServer server = MinecraftServer.getServer();
		if(server != null){
			for(int a = 0; a < server.worldServers.length; a++){
				WorldServer world = server.worldServers[a];
				for(int b = 0; b < world.loadedEntityList.size(); b++){
					if(!toRet.contains(world.loadedEntityList.get(b))){
						Object o = world.loadedEntityList.get(b);
						if(o instanceof EntityMyPerson){
							toRet.add((EntityMyPerson)o);
						}
					}
				}
				List unloadedEntityList = null;
				
				unloadedEntityList = MyPeopleFieldGrabbers.unloadedEntityList(world);
				
				for(int b = 0; b < unloadedEntityList.size(); b++){
					if(!toRet.contains(unloadedEntityList.get(b))){
						Object o = unloadedEntityList.get(b);
						if(o instanceof EntityMyPerson){
							toRet.add((EntityMyPerson)o);
						}
					}
				}
			}
		}
		return toRet;
	}

    

}
