package net.minecraft.mypeople;

import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.util.Vec3;

public class ModelPosition {
	
	double minX = 1000, minY = 1000, minZ = 1000;
	
	double maxX = -1000, maxY = -1000, maxZ = -1000;
	
	double xSize = 0, ySize = 0, zSize = 0;
	
	int type = -1;
	
	ModelEntry entry;
	
	public ModelPosition(){
		
	}
	
	public void print(){
		System.out.println(minX + "|" + maxX);
	}
	
	public void putOnTopOf(ModelPosition other){
		
		double diff = other.getMaxY() - this.minY;
		entry.renderTranslateY = diff;
/*		if(type == ModelEntry.HEAD){
			System.out.println(other.maxY + "|" + other.getMaxY() + "|" + this.minY);
//			entry.renderTranslateY += .125;
		}*/
	}
	
	public double getMaxY(){
		return maxY + entry.renderTranslateY;
	}
	
	public ModelPosition load(ModelEntry model){
		this.entry = model;
		type = model.TYPE;
		minX = 1000;
		minY = 1000;
		minZ = 1000;
		maxX = -1000;
		maxY = -1000;
		maxZ = -1000;
		for(int a = 0; a < model.models.length; a++){
			ModelRenderer r = model.models[a];
			for(int b = 0; b < r.cubeList.size(); b++){
				Object o = r.cubeList.get(b);
				if(o != null && o instanceof ModelBox){
					ModelBox m = (ModelBox)o;
/*					PositionTextureVertex[] vertexPositions = MyPeopleFieldGrabbers.vertexPositions(mod);
					if(vertexPositions != null){
						for(int c = 0; c < vertexPositions.length; c++){
							Vec3 v = vertexPositions[c].vector3D;
							if(minX > v.xCoord){minX = v.xCoord;}
							if(minY > v.yCoord){minY = v.yCoord;}
							if(minZ > v.zCoord){minZ = v.zCoord;}
							
							if(maxX < v.xCoord){maxX = v.xCoord;}
							if(maxY < v.yCoord){maxY = v.yCoord;}
							if(maxZ < v.zCoord){maxZ = v.zCoord;}
						}
					}*/
					if(type == ModelEntry.HEAD){
//						System.out.println(m.posY1 + "|" + m.posY2);
					}
/*					if(minX > mod.posX1){minX = mod.posX1;}
					if(minY > mod.posY1){minY = mod.posY1;}
					if(minZ > mod.posZ1){minZ = mod.posZ1;}
					if(minX > mod.posX2){minX = mod.posX2;}
					if(minY > mod.posY2){minY = mod.posY2;}
					if(minZ > mod.posZ2){minZ = mod.posZ2;}

					if(maxX < mod.posX1){maxX = mod.posX1;}
					if(maxY < mod.posY1){maxY = mod.posY1;}
					if(maxZ < mod.posZ1){maxZ = mod.posZ1;}
					if(maxX < mod.posX2){maxX = mod.posX2;}
					if(maxY < mod.posY2){maxY = mod.posY2;}
					if(maxZ < mod.posZ2){maxZ = mod.posZ2;}*/
					if(minX > x1(m, r)){minX = x1(m, r);};
					if(minY > y1(m, r)){minY = y1(m, r);};
					if(minZ > z1(m, r)){minZ = z1(m, r);};
					if(minX > x2(m, r)){minX = x2(m, r);};
					if(minY > y2(m, r)){minY = y2(m, r);};
					if(minZ > z2(m, r)){minZ = z2(m, r);};
					
					if(maxX < x1(m, r)){maxX = x1(m, r);};
					if(maxY < y1(m, r)){maxY = y1(m, r);};
					if(maxZ < z1(m, r)){maxZ = z1(m, r);};
					if(maxX < x2(m, r)){maxX = x2(m, r);};
					if(maxY < y2(m, r)){maxY = y2(m, r);};
					if(maxZ < z2(m, r)){maxZ = z2(m, r);};
					
				}
			}
		}
		minX /= 16;
		minY /= 16;
		minZ /= 16;
		maxX /= 16;
		maxY /= 16;
		maxZ /= 16;
		
		xSize = maxX-minX;
		ySize = maxY-minY;
		zSize = maxZ-minZ;
		if(type == ModelEntry.HEAD || type == ModelEntry.BODY || type == ModelEntry.LEG){
			System.out.println(minY + "|" + maxY + "|" + type);
		}
		return this;
	}
	
	public float x1(ModelBox box, ModelRenderer render){
		
		return box.posX1 - render.rotationPointX;
	}
	public float x2(ModelBox box, ModelRenderer render){
		return box.posX2 - render.rotationPointX;
	}
	public float y1(ModelBox box, ModelRenderer render){
//		System.out.println(render.rotationPointY);
		return box.posY1 - render.rotationPointY;
	}
	public float y2(ModelBox box, ModelRenderer render){
//		System.out.println( box.posY2 + "|||" + render.rotationPointY);
		return box.posY2 - render.rotationPointY;
	}
	public float z1(ModelBox box, ModelRenderer render){
		return box.posZ1 - render.rotationPointZ;
	}
	public float z2(ModelBox box, ModelRenderer render){
		return box.posZ2 - render.rotationPointZ;
	}

}
