package net.minecraft.mypeople;

import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.mypeople.entity.EntityCustomized;

import org.lwjgl.opengl.GL11;

public class ModelMixed extends ModelBase{

	ModelEntry[] models;
//	double[][] extraTranslations;
	public ModelMixed(ModelEntry[] models) {
		this.models = models;
//		extraTranslations = new double[models.length][3];
		alignVertically();
	}
	
	private void alignVertically(){
		ModelPosition[] positions = new ModelPosition[models.length];
		for(int a = 0; a < models.length; a++){
			positions[a] = new ModelPosition().load(models[a]);
		}
		int[] order = new int[]{ModelEntry.LEG, ModelEntry.BODY, ModelEntry.HEAD};
		int size = 0;
		for(int a = 0; a < positions.length; a++){
			for(int b = 0; b < order.length; b++){
				if(order[b] == positions[a].type){
					size++;
				}
			}	
		}
		ModelPosition[] ordered = new ModelPosition[size];
		int indexToPlace = 0;
		for(int a = 0; a < order.length; a++){
			int type = order[a];
			for(int b = 0; b < positions.length; b++){
				if(positions[b] != null && positions[b].type == type){
					ordered[indexToPlace] = positions[b];
					positions[b] = null;
					indexToPlace++;
				}
			}
		}
		System.out.println("___");
		System.out.println("Size: " + ordered.length);
		for(int a = 0; a < ordered.length; a++){
			ordered[a].print();
			//.setStartY(ordered[a-1].getMaxY());
		}
		System.out.println("___");
		for(int a = 1; a < ordered.length; a++){
			ordered[a].putOnTopOf(ordered[a-1]);//.setStartY(ordered[a-1].getMaxY());
		}
	}

	@Override
	public void render(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
		this.setRotationAngles(par2, par3, par4, par5, par6, par7, par1Entity);
		EntityCustomized e = (EntityCustomized)par1Entity;
		if(models != null){
			for(int a = 0; a < models.length; a++){
				if(models[a] != null){
/*					if(extraTranslations[a] != null){
						GL11.glTranslated(extraTranslations[a][0], extraTranslations[a][1], extraTranslations[a][2]);
					}*/
					models[a].render(par7, e);
/*					if(extraTranslations[a] != null){
						GL11.glTranslated(-extraTranslations[a][0], -extraTranslations[a][1], -extraTranslations[a][2]);
					}*/
				}
			}
		}
	}

	@Override
	public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, Entity par7Entity) {
		for(int a = 0; a < models.length; a++){
			models[a].setRotations(par1, par2, par3, par4, par5, par6, par7Entity);
		}
	}
	
	public void print(Object... strings){
		String s = "";
		for(int a = 0; a < strings.length; a++){
			s = s + strings[a] + (a+1 == strings.length?"":"|");
		}
		System.out.println(s);
	}
	
	
	
	

}
