package net.minecraft.mypeople;

import java.util.ArrayList;

import net.minecraft.client.model.ModelCow;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.MyPeopleRenderLivingAccessor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderCow;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.mypeople.entity.EntityCustomized;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

import org.lwjgl.opengl.GL11;

public class ModelEntry {
	
	public int entityID;
	
	ModelRenderer[] models;
	
	String entitySkin;
	
	ArrayList<ModelEntry> entries;
	
	int TYPE = -1;
	
	float onGround = 0f;
	
	boolean isRiding = false, isSneak = false, aimedBow = true;
	
	int heldItemLeft = 0, heldItemRight = 0;
	
	public double renderTranslateY = 0;
	
	public ModelEntry(int entityID, World world, ArrayList<ModelEntry> list, int TYPE){
		this.entityID = entityID;
		this.TYPE = TYPE;
		this.entries = list;
		entitySkin = EntityCustomized.getEntitySkin(entityID, world);
	}
	
	public boolean intersects(ModelEntry entry){
//		for(int a = 0; a < models[a].)
		return false;
	}
	
	public ModelEntry setModels(ModelRenderer... models){
		this.models = models;
		if(!entries.contains(this)){
			entries.add(this);
		}
		return this;
	}
	
	public void render(float ticks, EntityCustomized entity){
		RenderManager.instance.renderEngine.bindTexture(entitySkin);
		GL11.glPushMatrix();
		GL11.glTranslated(0, -renderTranslateY, 0);
		for(int a = 0; a < models.length; a++){
			if(models[a] != null){
				GL11.glPushMatrix();
				models[a].render(.0625f);
				models[a].postRender(.0625f);
				GL11.glPopMatrix();
			}
		}
		GL11.glPopMatrix();
	}

	public static int HEAD = 0, HEADWEAR = 1, EAR = 2, BODY = 3, WING = 4, ARM = 5, LEG = 6, RANDOM = 7;

	public void setRotations(float par1, float par2, float par3, float par4, float par5, float par6, Entity par7Entity) {
		if(TYPE == LEG){
			if(models.length == 8){
				rotateSpiderLegs(par1, par2);
			}else if(models.length == 4){
				rotateQuadLegs(par1, par2);
			}else if(models.length == 2){
				rotateBipedLegs(par1, par2);
			}
		}else if(TYPE == HEAD || TYPE == HEADWEAR || TYPE == EAR){
			if(models.length > 0){
				for(int a = 0; a < models.length; a++){
					rotateHeadStuff(par4, par5, models[a]);
					if(TYPE == EAR){
						models[a].rotateAngleX = 0;
						models[a].rotateAngleY = 0;
					}
				}
			}
		}else if(TYPE == BODY){
			if(models.length == 1){
				Render r = RenderManager.instance.getEntityClassRenderObject(EntityList.getClassFromID(entityID));
				if(r instanceof RenderCow){
					RenderCow rc = (RenderCow)r;
					ModelCow mc = (ModelCow)MyPeopleRenderLivingAccessor.mainModel(rc);
					if(models[0] == mc.body){
						models[0].rotateAngleX = ((float)Math.PI / 2F);
					}
				}
			}
		}else if(TYPE == ARM){
			if(models.length == 2){
				rotateArms(par1, par2, par3, par4, par5);
			}
		}

	}
	
	private void rotateArms(float par1, float par2, float par3, float par4, float par5){
		float rotateAngleY = par4 / (180F / (float)Math.PI);
        float rotateAngleX = par5 / (180F / (float)Math.PI);
		ModelRenderer bipedLeftArm = models[0];
		ModelRenderer bipedRightArm = models[1];
        bipedRightArm.rotateAngleX = MathHelper.cos(par1 * 0.6662F + (float)Math.PI) * 2.0F * par2 * 0.5F;
        bipedLeftArm.rotateAngleX = MathHelper.cos(par1 * 0.6662F) * 2.0F * par2 * 0.5F;
        bipedRightArm.rotateAngleZ = 0.0F;
        bipedLeftArm.rotateAngleZ = 0.0F;

        if (this.isRiding)
        {
            bipedRightArm.rotateAngleX += -((float)Math.PI / 5F);
            bipedLeftArm.rotateAngleX += -((float)Math.PI / 5F);
        }

        if (this.heldItemLeft != 0)
        {
            bipedLeftArm.rotateAngleX = bipedLeftArm.rotateAngleX * 0.5F - ((float)Math.PI / 10F) * (float)this.heldItemLeft;
        }

        if (this.heldItemRight != 0)
        {
            bipedRightArm.rotateAngleX = bipedRightArm.rotateAngleX * 0.5F - ((float)Math.PI / 10F) * (float)this.heldItemRight;
        }

        bipedRightArm.rotateAngleY = 0.0F;
        bipedLeftArm.rotateAngleY = 0.0F;
        float f6;
        float f7;

        if (this.onGround > -9990.0F)
        {
            f6 = this.onGround;
            rotateAngleY = MathHelper.sin(MathHelper.sqrt_float(f6) * (float)Math.PI * 2.0F) * 0.2F;
            bipedRightArm.rotationPointZ = MathHelper.sin(rotateAngleY) * 5.0F;
            bipedRightArm.rotationPointX = -MathHelper.cos(rotateAngleY) * 5.0F;
            bipedLeftArm.rotationPointZ = -MathHelper.sin(rotateAngleY) * 5.0F;
            bipedLeftArm.rotationPointX = MathHelper.cos(rotateAngleY) * 5.0F;
            bipedRightArm.rotateAngleY += rotateAngleY;
            bipedLeftArm.rotateAngleY += rotateAngleY;
            bipedLeftArm.rotateAngleX += rotateAngleY;
            f6 = 1.0F - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0F - f6;
            f7 = MathHelper.sin(f6 * (float)Math.PI);
            float f8 = MathHelper.sin(this.onGround * (float)Math.PI) * -(rotateAngleX - 0.7F) * 0.75F;
            bipedRightArm.rotateAngleX = (float)((double)bipedRightArm.rotateAngleX - ((double)f7 * 1.2D + (double)f8));
            bipedRightArm.rotateAngleY += rotateAngleY * 2.0F;
            bipedRightArm.rotateAngleZ = MathHelper.sin(this.onGround * (float)Math.PI) * -0.4F;
        }

        if (this.isSneak)
        {
            bipedRightArm.rotateAngleX += 0.4F;
            bipedLeftArm.rotateAngleX += 0.4F;
        }

        bipedRightArm.rotateAngleZ += MathHelper.cos(par3 * 0.09F) * 0.05F + 0.05F;
        bipedLeftArm.rotateAngleZ -= MathHelper.cos(par3 * 0.09F) * 0.05F + 0.05F;
        bipedRightArm.rotateAngleX += MathHelper.sin(par3 * 0.067F) * 0.05F;
        bipedLeftArm.rotateAngleX -= MathHelper.sin(par3 * 0.067F) * 0.05F;

        if (this.aimedBow)
        {
            f6 = 0.0F;
            f7 = 0.0F;
            bipedRightArm.rotateAngleZ = 0.0F;
            bipedLeftArm.rotateAngleZ = 0.0F;
            bipedRightArm.rotateAngleY = -(0.1F - f6 * 0.6F) + rotateAngleY;
            bipedLeftArm.rotateAngleY = 0.1F - f6 * 0.6F + rotateAngleY + 0.4F;
            bipedRightArm.rotateAngleX = -((float)Math.PI / 2F) + rotateAngleX;
            bipedLeftArm.rotateAngleX = -((float)Math.PI / 2F) + rotateAngleX;
            bipedRightArm.rotateAngleX -= f6 * 1.2F - f7 * 0.4F;
            bipedLeftArm.rotateAngleX -= f6 * 1.2F - f7 * 0.4F;
            bipedRightArm.rotateAngleZ += MathHelper.cos(par3 * 0.09F) * 0.05F + 0.05F;
            bipedLeftArm.rotateAngleZ -= MathHelper.cos(par3 * 0.09F) * 0.05F + 0.05F;
            bipedRightArm.rotateAngleX += MathHelper.sin(par3 * 0.067F) * 0.05F;
            bipedLeftArm.rotateAngleX -= MathHelper.sin(par3 * 0.067F) * 0.05F;
        }
	}
	
	private void rotateHeadStuff(float par4, float par5, ModelRenderer modelRenderer) {
		modelRenderer.rotateAngleY = par4 / (180F / (float)Math.PI);
		modelRenderer.rotateAngleX = par5 / (180F / (float)Math.PI);
	}

	private void rotateQuadLegs(float par1, float par2) {
		ModelRenderer leg1 = models[0];
		ModelRenderer leg2 = models[1];
		ModelRenderer leg3 = models[2];
		ModelRenderer leg4 = models[3];
        leg1.rotateAngleX = MathHelper.cos(par1 * 0.6662F) * 1.4F * par2;
        leg2.rotateAngleX = MathHelper.cos(par1 * 0.6662F + (float)Math.PI) * 1.4F * par2;
        leg3.rotateAngleX = MathHelper.cos(par1 * 0.6662F + (float)Math.PI) * 1.4F * par2;
        leg4.rotateAngleX = MathHelper.cos(par1 * 0.6662F) * 1.4F * par2;
	}

	private void rotateBipedLegs(float par1, float par2){
		ModelRenderer bipedLeftLeg = models[0];
		ModelRenderer bipedRightLeg = models[1];
        bipedRightLeg.rotateAngleX = MathHelper.cos(par1 * 0.6662F) * 1.4F * par2;
        bipedLeftLeg.rotateAngleX = MathHelper.cos(par1 * 0.6662F + (float)Math.PI) * 1.4F * par2;
        bipedRightLeg.rotateAngleY = 0.0F;
        bipedLeftLeg.rotateAngleY = 0.0F;

        if (this.isRiding)
        {
            bipedRightLeg.rotateAngleX = -((float)Math.PI * 2F / 5F);
            bipedLeftLeg.rotateAngleX = -((float)Math.PI * 2F / 5F);
            bipedRightLeg.rotateAngleY = ((float)Math.PI / 10F);
            bipedLeftLeg.rotateAngleY = -((float)Math.PI / 10F);
        }


        if (this.isSneak)
        {
            bipedRightLeg.rotationPointZ = 4.0F;
            bipedLeftLeg.rotationPointZ = 4.0F;
            bipedRightLeg.rotationPointY = 9.0F;
            bipedLeftLeg.rotationPointY = 9.0F;
        }
        else
        {
            bipedRightLeg.rotationPointZ = 0.1F;
            bipedLeftLeg.rotationPointZ = 0.1F;
            bipedRightLeg.rotationPointY = 12.0F;
            bipedLeftLeg.rotationPointY = 12.0F;
        }
	}

	private void rotateSpiderLegs(float par1, float par2) {
		ModelRenderer spiderLeg1 = models[0];
		ModelRenderer spiderLeg2 = models[1];
		ModelRenderer spiderLeg3 = models[2];
		ModelRenderer spiderLeg4 = models[3];
		ModelRenderer spiderLeg5 = models[4];
		ModelRenderer spiderLeg6 = models[5];
		ModelRenderer spiderLeg7 = models[6];
		ModelRenderer spiderLeg8 = models[7];
        float f6 = ((float)Math.PI / 4F);
        spiderLeg1.rotateAngleZ = -f6;
        spiderLeg2.rotateAngleZ = f6;
        spiderLeg3.rotateAngleZ = -f6 * 0.74F;
        spiderLeg4.rotateAngleZ = f6 * 0.74F;
        spiderLeg5.rotateAngleZ = -f6 * 0.74F;
        spiderLeg6.rotateAngleZ = f6 * 0.74F;
        spiderLeg7.rotateAngleZ = -f6;
        spiderLeg8.rotateAngleZ = f6;
        float f7 = -0.0F;
        float f8 = 0.3926991F;
        spiderLeg1.rotateAngleY = f8 * 2.0F + f7;
        spiderLeg2.rotateAngleY = -f8 * 2.0F - f7;
        spiderLeg3.rotateAngleY = f8 * 1.0F + f7;
        spiderLeg4.rotateAngleY = -f8 * 1.0F - f7;
        spiderLeg5.rotateAngleY = -f8 * 1.0F + f7;
        spiderLeg6.rotateAngleY = f8 * 1.0F - f7;
        spiderLeg7.rotateAngleY = -f8 * 2.0F + f7;
        spiderLeg8.rotateAngleY = f8 * 2.0F - f7;
        float f9 = -(MathHelper.cos(par1 * 0.6662F * 2.0F + 0.0F) * 0.4F) * par2;
        float f10 = -(MathHelper.cos(par1 * 0.6662F * 2.0F + (float)Math.PI) * 0.4F) * par2;
        float f11 = -(MathHelper.cos(par1 * 0.6662F * 2.0F + ((float)Math.PI / 2F)) * 0.4F) * par2;
        float f12 = -(MathHelper.cos(par1 * 0.6662F * 2.0F + ((float)Math.PI * 3F / 2F)) * 0.4F) * par2;
        float f13 = Math.abs(MathHelper.sin(par1 * 0.6662F + 0.0F) * 0.4F) * par2;
        float f14 = Math.abs(MathHelper.sin(par1 * 0.6662F + (float)Math.PI) * 0.4F) * par2;
        float f15 = Math.abs(MathHelper.sin(par1 * 0.6662F + ((float)Math.PI / 2F)) * 0.4F) * par2;
        float f16 = Math.abs(MathHelper.sin(par1 * 0.6662F + ((float)Math.PI * 3F / 2F)) * 0.4F) * par2;
        spiderLeg1.rotateAngleY += f9;
        spiderLeg2.rotateAngleY += -f9;
        spiderLeg3.rotateAngleY += f10;
        spiderLeg4.rotateAngleY += -f10;
        spiderLeg5.rotateAngleY += f11;
        spiderLeg6.rotateAngleY += -f11;
        spiderLeg7.rotateAngleY += f12;
        spiderLeg8.rotateAngleY += -f12;
        spiderLeg1.rotateAngleZ += f13;
        spiderLeg2.rotateAngleZ += -f13;
        spiderLeg3.rotateAngleZ += f14;
        spiderLeg4.rotateAngleZ += -f14;
        spiderLeg5.rotateAngleZ += f15;
        spiderLeg6.rotateAngleZ += -f15;
        spiderLeg7.rotateAngleZ += f16;
        spiderLeg8.rotateAngleZ += -f16;
	}
}
