package net.minecraft.mypeople;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import org.lwjgl.opengl.GL11;

public class GuiSplicer extends GuiContainer{

	TileEntitySplicer te = null;
	
	public GuiSplicer(InventoryPlayer invenPlayer, TileEntitySplicer te) {
		super(new ContainerSplicer(invenPlayer, te));
		this.te = te;
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j)
    {
		GL11.glPushMatrix();
    	int k = mc.renderEngine.getTexture("/MyPeople/splicer.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        drawTexturedModalRect(8+l, 72+i1, 0, 166, (int)Math.round(160d*te.getPercentDone()), 6);
        mc.renderEngine.resetBoundTexture();
        GL11.glPopMatrix();
    }
	
    protected void drawGuiContainerForegroundLayer(int par1, int par2)
    {
/*        fontRenderer.drawString("Centrifuge", 8, 6, 0x404040);
        fontRenderer.drawString("Inventory", 8, (ySize - 106) + 2, 0x404040);*/
        if(te.isSplicing()){
        	GL11.glPushMatrix();
        	int k = mc.renderEngine.getTexture("/MyPeople/splicer.png");
        	GL11.glEnable(GL11.GL_BLEND);
        	GL11.glBlendFunc (GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 0.6F);
            GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        	int minus = (int)Math.round(14d*te.getFuelDone());
        	drawTexturedModalRect(81, 64+(14-minus), 177, 1+(14-minus), 14, minus);
        	GL11.glDisable(GL11.GL_BLEND);
        	zLevel += 2;
        	drawDnaFluids();
        	zLevel -= 2;
        	mc.renderEngine.resetBoundTexture();
        	GL11.glPopMatrix();
        }
    }

	private void drawDnaFluids() {
//		this.drawRect(0, 0, 50, 50, 0xff00ff00);
		
		int x = (width - xSize) / 2;
		int y = (height - ySize) / 2;

		int yStart = 10;
		
		int xStart1 = 28;
		int xStart2 = 116;
		
		int yInc = 21;
		for(int a = 2; a < 5; a++){
			ItemStack stack = te.inventory[a];
			if(stack != null && stack.itemID == MyPeople.needleDNA.itemID){
				int posX = xStart1;
				int posY = yStart + ((a-2)*yInc);
				renderFluidLeft(getColour(stack.getItemDamage()), posX, posY, 32, 12, te.getPercentDone());
				renderWavey(getColour(stack.getItemDamage()), a);
			}
		}
		
		for(int a = 5; a < 8; a++){
			ItemStack stack = te.inventory[a];
			if(stack != null){
				int posX = xStart2;
				int posY = yStart + ((a-5)*yInc);
				renderFluidRight(getColour(stack.getItemDamage()), posX, posY, 32, 12, te.getPercentDone());
				renderWavey(getColour(stack.getItemDamage()), a);
			}
		}
	}
	
	private void renderWavey(int colour, int i) {
		int red = (colour >> 16) & 0xff;
		int green = (colour >> 8) & 0xff;
		int blue = (colour) & 0xff;
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glBlendFunc (GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glColor4f(((float)red) / 255.0f, ((float)green) / 255.0f, ((float)blue) / 255.0f, ((float)alpha) / 255.0f);
		int xF = 0, yF = 172, xT=61, yT=15, width = 18, height = 3;
		int xAdd = 0;
		int yAdd = 0;
		if(i == 2 || i == 4 || i == 5 || i == 7){
			width = 27;
			height = 13;
		}
		switch(i){
		case 2: break;
		case 3: yAdd = 20; break;
		case 4: yAdd = 31; break;
		case 5: xAdd = 27; break;
		case 6: xAdd = 36; yAdd = 20; break;
		case 7: xAdd = 27; yAdd = 31; break;
		}
		this.drawTexturedModalRect(xT + xAdd, yT + yAdd, xF + xAdd, yF + yAdd, width, height);
		
		GL11.glDisable(GL11.GL_BLEND);
	}

	int alpha = 0;
	boolean direction = true;
	int speed = 12;
	@Override
	public void updateScreen() {
		super.updateScreen();
		if(te.isSplicing()){
			if(direction){
				alpha+=speed;
				if(alpha >= 255){
					alpha = 255;
					direction = !direction;
				}
			}else{
				alpha-=speed;
				if(alpha <= 0){
					alpha = 0;
					direction = !direction;
				}
			}
		}else{
			alpha = 0;
			direction = true;
		}
	}

	public int getColour(int entityID){
		if(entityID == 0){
			entityID = MyPeople.cloneID;
		}
		if(EntityList.entityEggs.containsKey(entityID)){
			EntityEggInfo info = (EntityEggInfo)EntityList.entityEggs.get(entityID);
			if(info != null){
				return info.primaryColor | 0xff000000;
			}
		}
		return 0xffaaaaaa;
	}

	public void renderFluidLeft(int colour, int x, int y, int width, int height, float percentDone){
		int pixelsDone = (int)Math.round(((float)width)*percentDone);		
		this.drawRect(x+pixelsDone, y, x+width, y+height, colour);

	}
	
	public void renderFluidRight(int colour, int x, int y, int width, int height, float percentDone){
		int pixelsDone = (int)Math.round(((float)width)*percentDone);
		this.drawRect(x, y, x + (width-pixelsDone), y+height, colour);
	}

	@Override
	protected void handleMouseClick(Slot par1Slot, int par2, int par3, int par4) {
        if (par1Slot != null)
        {
            par2 = par1Slot.slotNumber;
            if(par2 > 0 && par2 < te.getSizeInventory()){
            	if(te.isSplicing()){
            		return;
            	}
            }
            
        }

        this.mc.playerController.windowClick(this.inventorySlots.windowId, par2, par3, par4, this.mc.thePlayer);
	}
    
    

}
