package net.minecraft.mypeople;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.mypeople.entity.EntityMyPerson;

public class GuiMyPersonOptions extends GuiScreen{
	MyPersonOptions options;
	
	EntityMyPerson clone;
	
	GuiScreen parentScreen;
	
	int exitID;

	int maxWidth;

	int maxHeight;

	int position = 0;

	int max;

	GuiTextField username;
	
	String firstName;
	
	public GuiMyPersonOptions(MyPersonOptions options, EntityMyPerson person, GuiScreen parentScreen){
		this.options = options;
		this.parentScreen = parentScreen;
		this.clone = person;
	}
	@Override
	protected void actionPerformed(GuiButton par1GuiButton) {
		if(par1GuiButton.id == exitID){
			mc.displayGuiScreen(parentScreen);
		}
	}
	@Override
	public void drawScreen(int par1, int par2, float par3) {
		drawDefaultBackground();
		username.drawTextBox();
		super.drawScreen(par1, par2, par3);
	}
	@Override
	public void initGui() {
		maxWidth = width/105;
		maxHeight = height/25;
		max = maxWidth*maxHeight;
		int x = (position / maxHeight)*105;
		int y = (position % maxHeight)*25;
		username = new GuiTextField(mc.fontRenderer, x, y, 100, 20);
		username.setText(clone.username);
		firstName = clone.username;
		position = 1;
		for(int a = 0; a < options.options.size(); a++){
			x = (position / maxHeight)*105;
			y = (position % maxHeight)*25;
			buttonList.add(new GuiOptionButton(position, x, y, 100, 20, options.options.get(a)));
			position++;
		}
		position = max-1;
		x = (position / maxHeight)*105;
		y = (position % maxHeight)*25;
		exitID = position;
		buttonList.add(new GuiButton(position, x, y, 100, 20, "Done"));
		super.initGui();
	}
	
	@Override
	protected void keyTyped(char par1, int par2) {
		if (par2 == 1)
        {
            mc.displayGuiScreen(parentScreen);
        }
		String s = username.getText();
		username.textboxKeyTyped(par1, par2);
		if(!s.equals(username.getText())){
			clone.setValue(1, username.getText(), null);
		}
	}
	
	@Override
	protected void mouseClicked(int par1, int par2, int par3) {
		username.mouseClicked(par1, par2, par3);
		super.mouseClicked(par1, par2, par3);
	}

	@Override
	public void updateScreen() {
		username.updateCursorCounter();
	}
	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}
	
	
	

}
