package net.minecraft.mypeople;

import java.util.List;
import java.util.Random;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.mypeople.entity.EntityMyPerson;

public class EntityAIAttackEnemies extends EntityAIBase {

	EntityMyPerson clone = null;
	
	Random rand = new Random();
	
	public EntityAIAttackEnemies(EntityMyPerson entityMyPerson) {
		clone = entityMyPerson;
	}

	public boolean shouldExecute() {
		if(clone != null && clone.options != null){
			return clone.options.fight.value;
		}
		return false;
		//return clone.options.fight.value && (clone.options.huntAnimal.value || clone.options.huntMob.value || clone.team == PlayerTeam.Traitor);
	}

	int update = 0;
	
	@Override
	public boolean continueExecuting() {
		if(clone.getEntityToAttack() == null){
			EntityLiving newEntity = getClosestEntityToAttack();
			if(newEntity != null){
				clone.setTarget(newEntity);
				clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
			}
		}else if(clone.getEntityToAttack().isEntityAlive()){
			if(rand.nextInt(10) == 0){
				EntityLiving newEntity = getClosestEntityToAttack();
				if(newEntity != null && newEntity != clone.getEntityToAttack()){
					double d1 = clone.getDistanceSqToEntity(clone.getEntityToAttack());
					double d2 = clone.getDistanceSqToEntity(newEntity);
					if(d2 < d1){
						clone.setTarget(newEntity);
						clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
					}
				}
			}else if(update++ >= 2){
				update = 0;
				clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
			}
			if((clone.options.entitiesToAttack.contains(clone.getEntityToAttack().getClass())?false:!clone.revenge) && !(clone.team == PlayerTeam.Traitor && clone.getEntityToAttack() instanceof EntityPlayer)){
				clone.setTarget(null);
				clone.setPathToEntity(null);
			}else{
				if(clone.getNavigator().noPath()){
					clone.setPathToEntity(clone.worldObj.getPathEntityToEntity(clone, clone.getEntityToAttack(), 16.0F, true, false, false, true));
				}
				clone.attackEntity(clone.entityToAttack, clone.getDistanceToEntity(clone.getEntityToAttack()));
			}
		}else{
			clone.setTarget(null);
			clone.setPathToEntity(null);
		} 
		
		return super.continueExecuting();
	}
	
	public EntityLiving getClosestEntityToAttack(){
		List list = clone.worldObj.getEntitiesWithinAABBExcludingEntity(clone, clone.boundingBox.expand(16D, 8D, 16D));
		
		double distance = -1;
		EntityLiving toAttack = null;
		for(int a = 0; a < list.size(); a++){
			Object o = list.get(a);
			if(o != null && o instanceof EntityLiving){
				EntityLiving e = (EntityLiving)o;
				if(e.isEntityAlive() && clone.canEntityBeSeen(e)){
					for(int b = 0; b < clone.options.entitiesToAttack.size(); b++){
						if(e.getClass() == clone.options.entitiesToAttack.get(b)){
							double distancesqr = distanceSquared(clone, e);
							if(distancesqr < distance || distance == -1){
								distance = distancesqr;
								toAttack = e;
							}
						}
					}
				}
				if(e instanceof EntityPlayer && clone.team == PlayerTeam.Traitor){
					double distancesqr = distanceSquared(clone, e);
					if(distancesqr < distance || distance == -1){
						distance = distancesqr;
						toAttack = e;
					}
				}
			}
		}
		return toAttack;
	}
	
	public double distanceSquared(Entity e1, Entity e2){
		double d1 = e1.posX - e2.posX;
		double d2 = e1.posY - e2.posY;
		double d3 = e1.posZ - e2.posZ;
		return d1*d1 + d2*d2 + d3*d3;
		
	}
	
	

}
