package net.minecraft.mypeople;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockIncubator extends BlockContainer{

	Icon on, off, side;
	
	public BlockIncubator(int par1) {
		super(par1, Material.rock);
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntityIncubator();
	}

	@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		TileEntity te = par1World.getBlockTileEntity(par2, par3, par4);
		if(te != null && te instanceof TileEntityIncubator){
			TileEntityIncubator te2 = (TileEntityIncubator)te;
			te2.dropAllItems(par1World, par2, par3, par4);
		}
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}

	
    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
	@Override
	public Icon getIcon(int par1, int par2) {
		if(par1 == 1){
			if(par2 == 1){
				return on;
			}else{
				return off;
			}
		}else if(par1 == 0){
			return blockIcon;
		}
		return side;
	}

	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
		par5EntityPlayer.openGui(MyPeople.instance, MyPersonGuiHandler.INCUBATOR, par1World, par2, par3, par4);
		return true;
	}

	@Override
	public void registerIcons(IconRegister r) {
		off = r.registerIcon("MyPeople:incubatorTopOff");
		on = r.registerIcon("MyPeople:incubatorTopOn");
		side = r.registerIcon("MyPeople:side");
		blockIcon = r.registerIcon("MyPeople:splicerSide");
	}
	
	
	
	
	
	

}
