package net.minecraft.mypeople;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockDnaCloner extends BlockContainer{
	
	public BlockDnaCloner(int par1) {
		super(par1, Material.rock);
	}
	
	@Override
	public boolean onBlockActivated(World par1World, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
		p.openGui(MyPeople.instance, MyPersonGuiHandler.CLONER, par1World, x, y, z);
		return true;
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntityDnaCloner();
	}

	@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		TileEntity e = par1World.getBlockTileEntity(par2, par3, par4);
		if(e != null && e instanceof TileEntityDnaCloner){
			((TileEntityDnaCloner)e).dropAllItems(par1World, par2, par3, par4);
		}
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}
	
	



	
	
}
