 package net.minecraft.mypeople;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BlockCentrifuge extends BlockContainer {

	protected BlockCentrifuge(int i) {
		super(i, Material.rock);
		setCreativeTab(CreativeTabs.tabMisc);
	}
	
	public TileEntity createNewTileEntity(World var1) {
		return new TileEntityCentrifuge();
	}



	
	public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer player, int par6, float par7, float par8, float par9) {
		player.openGui(MyPeople.instance, MyPersonGuiHandler.CENTRIFUGE, world, i, j, k);
		return true;
	}

	

    @Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
    	TileEntity tE = par1World.getBlockTileEntity(par2, par3, par4);
    	if(tE != null && tE instanceof TileEntityCentrifuge){
    		((TileEntityCentrifuge)tE).dropAllItems(par1World, par2, par3, par4);
    	}
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}
    
	
    public boolean isOpaqueCube()
    {
        return false;
    }

    /**
     * If this block doesn't render as an ordinary block it will return False (examples: signs, buttons, stairs, etc)
     */
    public boolean renderAsNormalBlock()
    {
        return false;
    }

    /**
     * The type of render function that is called for this block
     */
    public int getRenderType()
    {
        return renderID;
    }

    int renderID = 22;
    
	public void setRenderID(int renderId) {
		renderID = renderId;
	}
    
    


}
