package net.minecraft.mypeople;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import cpw.mods.fml.relauncher.Side;

public class MyPersonOptions {

	public EntityMyPerson clone;
	
	public ArrayList<Class> entitiesToAttack = new ArrayList<Class>();
	
	public ArrayList<BreakBlockEntry> blocksCanBreak = new ArrayList<BreakBlockEntry>();
	
	
	
	public MyPersonOptions(EntityMyPerson person){
		this.clone = person;
		fight = new MyPersonOption("fight", "Fight", 0, false, this);
		sprint = new MyPersonOption("sprint", "Sprint", 1, false, this);
		follow = new MyPersonOption("follow", "Follow", 2, false, this);
		breakBlocks = new MyPersonOption("breakBlocks", "Break Blocks", 3, false, this);
		breakExtraBlocks = new MyPersonOption("breakExtraBlocks", "Break Roughly", 4, false, this);
		pickUp = new MyPersonOption("pickup", "Pick Up Items", 5, true, this);
		walkToItems = new MyPersonOption("walkto", "Walk to items", 6, false, this);
		retaliate = new MyPersonOption("retaliate", "Retaliate", 7, false, this);
		guard = new MyPersonOption("guard", "Guard Position", 8, false, this);
		wander = new MyPersonOption("wander", "Wander", 9, false, this);
		jump = new MyPersonOption("jump", "Jump On Attack", 10, false, this);
		stats = new MyPersonOption("stats", "Stats", 11, true, this);
		female = new MyPersonOption("female", "Female", 12, false, this);
		curious = new MyPersonOption("curious", "Curious", 13, true, this);
		farming = new MyPersonOption("farming", "Farming", 15, false, this);
	}

	public void writeEntityToNBT(NBTTagCompound nbt) {
		for(int a = 0; a < options.size(); a++){
			nbt.setBoolean(options.get(a).name, options.get(a).value);
		}
		NBTTagList attackList = new NBTTagList();
		Map classToIDMapping = MyPeopleFieldGrabbers.classToIDMapping();
		if(classToIDMapping != null){
			for(int a = 0; a < entitiesToAttack.size(); a++){
				NBTTagCompound compound = new NBTTagCompound();
				Object o = classToIDMapping.get(entitiesToAttack.get(a));
				if(o != null && o instanceof Integer){
					NBTTagString inte = new NBTTagString("Name", EntityList.getStringFromID((Integer)o));
					attackList.appendTag(inte);
				}
			}
		}else{
			System.out.println("Class to string is null!!! That's not good!");
		}
		nbt.setTag("Attacking", attackList);
		NBTTagList breakList = new NBTTagList();
		for(int a = 0; a < blocksCanBreak.size(); a++){
			NBTTagCompound com = new NBTTagCompound();
			BreakBlockEntry entry = blocksCanBreak.get(a);
			if(entry != null){
				com.setInteger("ID", entry.id);
				com.setInteger("META", entry.meta);
				breakList.appendTag(com);
			}
		}
		nbt.setTag("Breakable", breakList);
	}
	
	

	public void readEntityFromNBT(NBTTagCompound nbt) {
		for(int a = 0; a < options.size(); a++){
			options.get(a).set(nbt.getBoolean(options.get(a).name));
		}
		NBTTagList attackList = nbt.getTagList("Attacking");
		if(attackList != null){
			Map stringToClass = MyPeopleFieldGrabbers.stringToClassMapping();
			for(int a = 0; a < attackList.tagCount(); a++){
				NBTTagString base = (NBTTagString)attackList.tagAt(a);
				Object o = stringToClass.get(base.data);
				if(o != null && o instanceof Class){
					entitiesToAttack.add((Class)o);
				}
			}
		}
		NBTTagList breakList = nbt.getTagList("Breakable");
		for(int a = 0; a < breakList.tagCount(); a++){
			NBTTagCompound com = (NBTTagCompound)breakList.tagAt(a);
			blocksCanBreak.add(new BreakBlockEntry(com.getInteger("ID"), com.getInteger("META")));
		}
	}
	
/*	public boolean set(String name, boolean b){
		if(nameToOption.containsKey(name)){
			nameToOption.get(name).set(b);
			//if(name.equals(arg0))
			return b;
		}
		return b;
	}*/
	
	public boolean toggle(String name){
		if(nameToOption.containsKey(name)){
			nameToOption.get(name).toggle();
			if(name.equals(guard.name)){
				if(guard.value){
					clone.setGuardPosition();
				}else{
					clone.clearGuardPosition();
				}
			}
			
			
			return nameToOption.get(name).value;
		}
		

		return false;
	}
	
	public MyPersonOption add(MyPersonOption option){
		nameToOption.put(option.name, option);
		options.add(option);
		idToName.put(option.id, option.name);
		nameToId.put(option.name, option.id);
		return option;
	}
	
	public MyPersonOption fight;
	public MyPersonOption sprint;
	public MyPersonOption follow;
	public MyPersonOption pickUp;
	public MyPersonOption walkToItems;
	public MyPersonOption retaliate;
	public MyPersonOption guard;
	public MyPersonOption wander;
	public MyPersonOption jump;
	public MyPersonOption curious;
	public MyPersonOption breakExtraBlocks;
	public MyPersonOption stats;
	public MyPersonOption female;
	public MyPersonOption breakBlocks;
	public MyPersonOption farming;
	
	public HashMap<String, MyPersonOption> nameToOption = new HashMap<String, MyPersonOption>();
	
	public ArrayList<MyPersonOption> options = new ArrayList<MyPersonOption>();
	
	public HashMap<Integer, String> idToName = new HashMap<Integer, String>();
	
	public HashMap<String, Integer> nameToId = new HashMap<String, Integer>();

	public void updateToAllWatchingOrPlayer(EntityPlayerMP entity){
		if(!clone.worldObj.isRemote){
			Object[] values = new Object[options.size() + 1];
			values[0] = clone.entityId;
			for(int a = 0; a < options.size(); a++){
				values[a+1] = options.get(a).value;
			}
			if(entity != null){
				entity.playerNetServerHandler.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateAllCloneOptions.id, values, Side.CLIENT));
			}else{
				clone.getTracker().sendPacketToAllAssociatedPlayers(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateAllCloneOptions.id, values, Side.CLIENT));
			}
			updateAttackableEntities(entity);
			updateBreakableBlocks(entity);
		}
	}
	
	public void updateToAllWatching(String option){
		if(!clone.worldObj.isRemote){
			clone.getTracker().sendPacketToAllAssociatedPlayers(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateCloneOption.id, new Object[]{clone.entityId, nameToOption.get(option).name, nameToOption.get(option).value}, Side.CLIENT));
		}
	}

	public void updateAttackableEntities(EntityPlayerMP entity){
		Object[] values2 = new Object[entitiesToAttack.size()+2];
		values2[0] = (int)clone.entityId;
		values2[1] = (int)entitiesToAttack.size();
		for(int a = 0; a < entitiesToAttack.size(); a++){
			values2[a+2] = entitiesToAttack.get(a).getName();
		}
		if(entity != null){
			entity.playerNetServerHandler.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateAllCloneEntityOptions.id, values2, Side.CLIENT));
		}else{
			clone.getTracker().sendPacketToAllAssociatedPlayers(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateAllCloneEntityOptions.id, values2, Side.CLIENT));
		}
	}
	
	public void updateBreakableBlocks(EntityPlayerMP entity){
		NBTTagCompound nbt = new NBTTagCompound();
		nbt.setInteger("ID", clone.entityId);
		NBTTagList list = new NBTTagList();
		for(int a = 0; a < blocksCanBreak.size(); a++){
			NBTTagCompound block = new NBTTagCompound();
			BreakBlockEntry entry = blocksCanBreak.get(a);
			if(entry != null){
				block.setInteger("ID", entry.id);
				block.setInteger("META", entry.meta);
				list.appendTag(block);
			}
		}
		nbt.setTag("Blocks", list);
		if(entity != null){
			entity.playerNetServerHandler.sendPacketToPlayer(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateAllCloneBlockOptions.id, nbt, Side.CLIENT));
		}else{
			clone.getTracker().sendPacketToAllAssociatedPlayers(MyPeople.packetHandler.create(MyPeoplePacketType.clientUpdateAllCloneBlockOptions.id, nbt, Side.CLIENT));
		}
	}
	
	public boolean remove(BreakBlockEntry entry){
		if(entry == null){
			return false;
		}
		for(int a = 0; a < this.blocksCanBreak.size(); a++){
			if(blocksCanBreak.get(a).compare(entry)){
				blocksCanBreak.remove(a);
				return true;
			}
		}
		return false;
	}

	public boolean containsBreak(BreakBlockEntry entry){
		if(entry == null){
			return false;
		}
		for(int a = 0; a < this.blocksCanBreak.size(); a++){
			if(blocksCanBreak.get(a).compare(entry)){
				return true;
			}
		}
		return false;
	}
	
	public boolean canBreakBlock(int blockId, int blockMeta) {
		if(clone.hasItemForBlock(blockId, blockMeta)){
			return containsBreak(new BreakBlockEntry(blockId, blockMeta));
		}
		return false;
	}
}
