package net.minecraft.mypeople;

import java.util.HashMap;

public class MyPeoplePacketType {
	
	public String name;
	public short id;
	
	public MyPeoplePacketType(String name, int id){
		stringToID.put(name, (short)id);
		IDToString.put((short)id, name);
		this.name = name;
		this.id = (short)id;
	}
	

	public static int get(String id){
		if(stringToID.containsKey(id)){
			return stringToID.get(id);
		}
		return -1;
	}
 
	static HashMap<String, Short> stringToID = new HashMap<String, Short>();
	static HashMap<Short, String> IDToString = new HashMap<Short, String>();
	
	//Client To Server
	public static MyPeoplePacketType serverCentrifuge = new MyPeoplePacketType("Centrifuge", 0);
	
	public static MyPeoplePacketType serverUpdateCloneInfoWithID = new MyPeoplePacketType("UpdateInfoWithID", 1);
	
	public static MyPeoplePacketType serverUpdateOption = new MyPeoplePacketType("UpdateOneOption", 2);
	
	public static MyPeoplePacketType serverKillClone = new MyPeoplePacketType("KillClone", 3);
	
	public static MyPeoplePacketType serverTeamChange = new MyPeoplePacketType("TeamChange", 4);
	
	public static MyPeoplePacketType serverTakeExperience = new MyPeoplePacketType("TakeXP", 5);
	
	public static MyPeoplePacketType serverChangeAttack = new MyPeoplePacketType("ChangeAttackEntity", 6);
	
	public static MyPeoplePacketType serverChangeBreak = new MyPeoplePacketType("ChangeBreakBlocks", 7);
	
	public static MyPeoplePacketType serverChangeOwner = new MyPeoplePacketType("ChangeOwner", 8);
	
	public static MyPeoplePacketType serverUpdateTracker = new MyPeoplePacketType("UpdateCloneTracker", 10);

	public static MyPeoplePacketType serverTeleportClone = new MyPeoplePacketType("TeleportCloneOrPlayer", 11);

	public static MyPeoplePacketType serverCopyClone = new MyPeoplePacketType("CopyClone", 12);
	//Server To Client
	
	public static MyPeoplePacketType clientUpdateCloneInfo = new MyPeoplePacketType("UpdateInfo", 0);
	
	public static MyPeoplePacketType clientUpdateAllCloneOptions = new MyPeoplePacketType("UpdateAllOptions", 1);
	
	public static MyPeoplePacketType clientUpdateCloneOption = new MyPeoplePacketType("UpdateOneOptions", 2);
	
	public static MyPeoplePacketType clientUpdateCloneInfoWithID = new MyPeoplePacketType("UpdateInfoWithID", 3);
	
	public static MyPeoplePacketType clientKillClone = new MyPeoplePacketType("KillClone", 4);
	
	public static MyPeoplePacketType clientTeamChange = new MyPeoplePacketType("TeamChange", 5);
	
	public static MyPeoplePacketType clientUpdateInventory = new MyPeoplePacketType("InvenUpdate", 6);
	
	public static MyPeoplePacketType clientUpdateAllCloneEntityOptions = new MyPeoplePacketType("UpdateAllEntityAttaclOptions", 7);
	
	public static MyPeoplePacketType clientUpdateSpecificInventory = new MyPeoplePacketType("UpdateSpecificInven", 8);

	public static MyPeoplePacketType clientUpdateAllCloneBlockOptions = new MyPeoplePacketType("UpdateAllBlockOptions", 9);

	public static MyPeoplePacketType clientUpdateTracker = new MyPeoplePacketType("UpdateCloneTracker", 10);
	
	public static MyPeoplePacketType clientSendEgg = new MyPeoplePacketType("SendTEEggToClient", 11);
	
	public static MyPeoplePacketType clientCloneTeleportResponse = new MyPeoplePacketType("CloneTeleportResponse", 12);
	
	public static MyPeoplePacketType clientUpdateCentrifugeInfo = new MyPeoplePacketType("UpdateCentrifugeTileEntity", 13);
	
	public static MyPeoplePacketType clientUpdateEggInfo = new MyPeoplePacketType("UpdateTileEntityEgginfo", 14);
	
	public static MyPeoplePacketType clientEggParticles = new MyPeoplePacketType("Client Egg Particle Spawns", 15);

	public static MyPeoplePacketType clientUpdateTrackedClone = new MyPeoplePacketType("Update one clone entity", 16);
	
	public static MyPeoplePacketType clientUpdateCustomizedData = new MyPeoplePacketType("Update Customized Entity Data", 17);

	
	

}
