package net.minecraft.mypeople;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.entity.EntityCustomized;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MyPeopleClientPacketHandler {
	
	public void processPacket(NetClientHandler net, Packet250CustomPayload var2){

		ByteArrayInputStream bIn = new ByteArrayInputStream(var2.data);
		DataInputStream input = new DataInputStream(bIn);
		try{
			int ID = input.readInt();
			if(ID == MyPeoplePacketType.clientUpdateCloneInfo.id){
				handleClientUpdateCloneInfo(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateAllCloneOptions.id){
				handleClientUpdateAllCloneOptions(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateCloneOption.id){
				handleClientUpdateCloneOtpion(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateCloneInfoWithID.id){
				handleClientUpdateCloneInfoWithID(net, input);
			}else if(ID == MyPeoplePacketType.clientKillClone.id){
				handleClientKillClone(net, input);
			}else if(ID == MyPeoplePacketType.clientTeamChange.id){
				handleClientTeamChange(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateInventory.id){
				handleClientUpdateInventory(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateAllCloneEntityOptions.id){
				handleClientUpdateAllCloneEntityOptions(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateSpecificInventory.id){
				handleClientUpdateSpecificInventory(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateAllCloneBlockOptions.id){
				handleClientUpdateAllCloneBlockOptions(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateTracker.id){
				handleClientUpdateTracker(net, input);
			}else if(ID == MyPeoplePacketType.clientCloneTeleportResponse.id){
				handleClientCloneTeleportResponse(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateCentrifugeInfo.id){
				handleClientUpdateCentrifugeInfo(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateEggInfo.id){
				handleClientUpdateEggInfo(net, input);
			}else if(ID == MyPeoplePacketType.clientEggParticles.id){
				handleClientEggParticles(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateTrackedClone.id){
				handleClientUpdateTrackedClone(net, input);
			}else if(ID == MyPeoplePacketType.clientUpdateCustomizedData.id){
				handleClientUpdateCustomizedData(net, input);
			}
			
			
			bIn.close();
			input.close();
		}catch(Exception e){
			e.printStackTrace();
		}
	}


	public void handleClientUpdateCloneInfo(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson e = getEntityMyperson(input.readInt());
		if(e != null){
			e.updateToAllEnd(input);
/*			EntityMyPerson entity = (EntityMyPerson)e;
			entity.setName(input.readUTF());
			entity.setOwner(input.readUTF());
			entity.setScale(input.readFloat());
			entity.experience = input.readFloat();
			entity.experienceLevel = input.readInt();
			entity.experienceTotal = input.readInt();
			entity.experienceValue = input.readInt();
			entity.team = PlayerTeam.getByID(input.readInt());
			entity.maxScale = input.readFloat();
			entity.growthSpeed = input.readFloat();*/
		}
	}
	
	public void handleClientUpdateAllCloneOptions(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			for(int a = 0; a < myPerson.options.options.size(); a++){
				boolean b = input.readBoolean();
				myPerson.options.options.get(a).set(b);
			}
		}
	}
	
	public void handleClientUpdateCloneOtpion(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			String optionID = input.readUTF();
			boolean value = input.readBoolean();
			MyPersonOption option = myPerson.options.nameToOption.get(optionID);
			if(option != null){
				option.set(value);
			}
		}
	}
	
	public void handleClientUpdateCloneInfoWithID(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			myPerson.set(input.readInt(), input.readUTF());
		}
	}
	
	public void handleClientKillClone(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			myPerson.doKill();
		}
	}
	
	public void handleClientTeamChange(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			myPerson.team = PlayerTeam.getByID(input.readInt());
		}
	}
	
	public void handleClientUpdateInventory(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			int amount = input.readInt();
			for(int a = 0; a < amount; a++){
				//System.out.println(a);
				int slot = input.readInt();
				ItemStack stack = Packet.readItemStack(input);
				if(slot >= 100){
					myPerson.inventory.armorInventory[slot-100] = stack;
				}else{
					myPerson.inventory.mainInventory[slot] = stack;
				}
			}
		}
	}
	
	public void handleClientUpdateAllCloneEntityOptions(NetClientHandler handler, DataInputStream input)throws IOException{
		EntityMyPerson myPerson = getEntityMyperson(input.readInt());
		if(myPerson != null){
			int size = input.readInt();
			myPerson.options.entitiesToAttack.clear();
			for(int a = 0; a < size; a++){
				String s = input.readUTF();
				try{
					Class c = Class.forName(s);
					if(c != null){
						myPerson.options.entitiesToAttack.add(c);
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
	}
	
	
	
	public void handleClientUpdateSpecificInventory(NetClientHandler var1, DataInputStream input) {
		NBTTagCompound nbt = null;
		try{
			nbt = CompressedStreamTools.read(input);
		}catch(Exception e){
			e.printStackTrace();
		}
		if(nbt != null){
			int entityID = nbt.getInteger("EntityId");
			int currentItem = nbt.getInteger("CurrentItem");
			EntityMyPerson entityMyPerson = getEntityMyperson(entityID);
			if(entityMyPerson == null){
				return;
			}
			entityMyPerson.inventory.currentItem = currentItem;
			NBTTagList list = nbt.getTagList("Items");
			for(int a = 0; a < list.tagCount(); a++){
				NBTTagCompound item = (NBTTagCompound) list.tagAt(a);
				int slotId = item.getInteger("SlotId");
				boolean exists = item.getBoolean("Exists");
				if(exists){
					NBTTagCompound theItem = item.getCompoundTag("TheItem");
					ItemStack stack = ItemStack.loadItemStackFromNBT(theItem);
					if(stack != null){
						if(slotId < 0){
							entityMyPerson.inventory.armorInventory[slotId + entityMyPerson.inventory.armorInventory.length] = stack;
						}else{
							entityMyPerson.inventory.mainInventory[slotId] = stack;
						}
					}
				}else{
					if(slotId < 0){
						entityMyPerson.inventory.armorInventory[slotId + entityMyPerson.inventory.armorInventory.length] = null;
					}else{
						entityMyPerson.inventory.mainInventory[slotId] = null;
					}
				}
			}
		}
		
	}
	
	public void handleClientUpdateAllCloneBlockOptions(NetClientHandler var1, DataInputStream input){
		NBTTagCompound nbt = null;
		try{
			nbt = CompressedStreamTools.read(input);
		}catch(Exception e){
			e.printStackTrace();
		}
		if(nbt != null){
			EntityMyPerson myPerson = getEntityMyperson(nbt.getInteger("ID"));
			if(myPerson != null){
				NBTTagList list = nbt.getTagList("Blocks");
				myPerson.options.blocksCanBreak.clear();
				for(int a = 0; a < list.tagCount(); a++){
					NBTTagCompound compound = (NBTTagCompound)list.tagAt(a);
					int blockId = compound.getInteger("ID");
					int meta = compound.getInteger("META");
					BreakBlockEntry entry = new BreakBlockEntry(blockId, meta);
					myPerson.options.blocksCanBreak.add(entry);
				}
			}
		}
	}
	
	public void handleClientUpdateTracker(NetClientHandler var1, DataInputStream input)throws IOException{
		NBTTagCompound nbt = CompressedStreamTools.read(input);
		if(nbt != null){
			GuiScreen currentScreen = Minecraft.getMinecraft().currentScreen;
			if(currentScreen != null && currentScreen instanceof GuiCloneTracker){
				GuiCloneTracker gui = (GuiCloneTracker)currentScreen;
				gui.setClones(nbt);
			}
		}
	}
	
	
	
	private void handleClientCloneTeleportResponse(NetClientHandler net, DataInputStream input) throws IOException{
		boolean result = input.readBoolean();
		boolean type = input.readBoolean();
		int entityId = input.readInt();
		GuiScreen currentScreen = Minecraft.getMinecraft().currentScreen;
		if(currentScreen != null && currentScreen instanceof GuiCloneTracker){
			GuiCloneTracker gui = (GuiCloneTracker)currentScreen;
			gui.onTeleport(result, type, entityId);
		}
	}
	
	private void handleClientUpdateCentrifugeInfo(NetClientHandler net, DataInputStream input) throws IOException{
		TileEntityCentrifuge te1 = new TileEntityCentrifuge();
		NBTTagCompound nbt = CompressedStreamTools.read(input);
		te1.readFromNBT(nbt);
		World theWorld = Minecraft.getMinecraft().theWorld;
		if(theWorld != null){
			TileEntity te2 = theWorld.getBlockTileEntity(te1.xCoord, te1.yCoord, te1.zCoord);
			if(te2 instanceof TileEntityCentrifuge){
				TileEntityCentrifuge tec = (TileEntityCentrifuge)te2;
				tec.readFromNBT(nbt);
			}
		}
	}
	
	private void handleClientUpdateEggInfo(NetClientHandler net, DataInputStream input) throws IOException{
		TileEntityHumanEgg te1 = new TileEntityHumanEgg();
		NBTTagCompound nbt = CompressedStreamTools.read(input);
		te1.readFromNBT(nbt);
		World theWorld = Minecraft.getMinecraft().theWorld;
		if(theWorld != null){
			TileEntity te2 = theWorld.getBlockTileEntity(te1.xCoord, te1.yCoord, te1.zCoord);
			if(te2 instanceof TileEntityHumanEgg){
				TileEntityHumanEgg tec = (TileEntityHumanEgg)te2;
				tec.readFromNBT(nbt);
			}
		}
	}
	
	private void handleClientEggParticles(NetClientHandler net, DataInputStream input) throws IOException{
		int xCoord = input.readInt();
		int yCoord = input.readInt();
		int zCoord = input.readInt();
		int amount = input.readInt();
		if(net.getPlayer().worldObj != null){
			TileEntity te = net.getPlayer().worldObj.getBlockTileEntity(xCoord, yCoord, zCoord);
			if(te != null && te instanceof TileEntityHumanEgg){
				TileEntityHumanEgg tehg = (TileEntityHumanEgg)te;
				tehg.particle(xCoord, yCoord, zCoord, amount, net.getPlayer().worldObj);
			}
		}

	}
	
	private void handleClientUpdateTrackedClone(NetClientHandler net, DataInputStream input) throws IOException{
		double x = input.readDouble();
		double y = input.readDouble();
		double z = input.readDouble();
		if(MyPeople.instance.cloneToFind != null){
			MyPeople.instance.cloneToFind.setPosition(x, y, z);
		}
	}
	
	private void handleClientUpdateCustomizedData(NetClientHandler net, DataInputStream input) throws IOException{
		NBTTagCompound nbt = CompressedStreamTools.read(input);
		int entityId = nbt.getInteger("entityId");
		Entity e;
		if(entityId > -1 && (e = getEntity(entityId)) != null){
			if(e instanceof EntityCustomized){
//				System.out.println("Readed!!!");
				((EntityCustomized)e).readVars(nbt);
			}
		}
	}
	
	
	//---------------------------------------------------------------------------------------------------------------------------
	
	public EntityMyPerson getEntityMyperson(int entityID){
		Entity e = getEntity(entityID);
		if(e != null && e instanceof EntityMyPerson){
			return (EntityMyPerson)e;
		}
		return null;
	}
	
	public Entity getEntity(int entityID){
		if(Minecraft.getMinecraft() != null && Minecraft.getMinecraft().theWorld != null){
			return Minecraft.getMinecraft().theWorld.getEntityByID(entityID);
		}
		return null;
	}



}
//Server to client