package net.minecraft.mypeople;

import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.entity.EntityMyPerson;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class GuiSlotChooseBlocksToBreak extends GuiSlot{
	
	EntityMyPerson clone;
	
	GuiChooseBlocksToBreak parent;
	
	private static RenderItem itemRenderer = new RenderItem();
	
	public GuiSlotChooseBlocksToBreak(EntityMyPerson clone, GuiChooseBlocksToBreak parent){
		super(parent.getMc(), parent.width, parent.height, 32, parent.height-64, 36);
		this.clone = clone;
		this.parent = parent;
	}

	@Override
	protected int getSize() {
		return parent.visibleEntries.size();
	}

	@Override
	protected void elementClicked(int var1, boolean var2) {
		BreakBlockEntry entry = parent.visibleEntries.get(var1);
		if(entry != null){
			if(!clone.options.remove(entry)){
				clone.options.blocksCanBreak.add(entry);
				onAdd(entry);
			}else{
				onRemove(entry);
			}
		}
	}
	
	public void onRemove(BreakBlockEntry entry) {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeBreak.id, new Object[]{clone.entityId/*, clone.worldObj.getWorldInfo().getDimension()*/, entry.id, entry.meta, true});
	}
	
	public void onAdd(BreakBlockEntry entry) {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeBreak.id, new Object[]{clone.entityId/*, clone.worldObj.getWorldInfo().getDimension()*/, entry.id, entry.meta, false});
	}
	
	

	@Override
	protected int getContentHeight() {
		return getSize() * slotHeight;
	}

	@Override
	protected boolean isSelected(int var1) {
		return clone.options.containsBreak(parent.visibleEntries.get(var1));
	}

	@Override
	protected void drawBackground() {
		parent.drawDefaultBackground();
	}

	@Override
	protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
		BreakBlockEntry entry = parent.visibleEntries.get(var1);
		parent.drawString(parent.getMc().fontRenderer, entry.getBlockName(), var2, var3, 0xffffff);
		ItemStack stack = new ItemStack(entry.id, 1, entry.meta);
		renderItem(stack, (var2 - 40)/2, var3/2);
		itemRenderer = new RenderItem();
	}
	
	public void renderItem(ItemStack var5, int par2, int par3){
		GL11.glPushMatrix();
        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        RenderHelper.enableGUIStandardItemLighting();

        GL11.glScalef(2, 2, 2);
        
        itemRenderer.renderItemAndEffectIntoGUI(parent.getMc().fontRenderer, parent.getMc().renderEngine, var5, par2, par3);
	
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
        GL11.glPopMatrix();
	}

}
