package net.minecraft.mypeople;

import java.util.ArrayList;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.entity.EntityMyPerson;

import org.lwjgl.input.Mouse;

public class GuiChooseBlocksToBreak extends GuiScreen {
	
	EntityMyPerson clone;
	
	GuiScreen parent;
	
	public GuiChooseBlocksToBreak(EntityMyPerson clone, GuiScreen parent){
		this.clone = clone;
		this.parent = parent;
	}

	ArrayList<BreakBlockEntry> visibleEntries = new ArrayList<BreakBlockEntry>();
	
	GuiSlotChooseBlocksToBreak slot;
	
	@Override
	public void drawScreen(int par1, int par2, float par3) {
		slot.drawScreen(par1, par2, par3);
		search.drawTextBox();
		super.drawScreen(par1, par2, par3);
	}

	@Override
	protected void keyTyped(char par1, int par2) {
		if(par2 == 1){
			mc.displayGuiScreen(parent);
		}else{
			if(!search.isFocused()){
				search.setFocused(true);
			}
		}
		search.textboxKeyTyped(par1, par2);
	}

	public void onRemove(BreakBlockEntry entry) {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeBreak.id, new Object[]{clone.entityId/*, clone.worldObj.getWorldInfo().getDimension()*/, entry.id, entry.meta, true});
	}
	
	public void onAdd(BreakBlockEntry entry) {
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverChangeBreak.id, new Object[]{clone.entityId/*, clone.worldObj.getWorldInfo().getDimension()*/, entry.id, entry.meta, false});
	}
	
	GuiTextFieldClearable search = null;
	
	@Override
	public void initGui() {
		slot = new GuiSlotChooseBlocksToBreak(clone, this);
		slot.registerScrollButtons(buttonList, 0, 1);
		for(int a = 0; a < allEntries.size(); a++){
			visibleEntries.add(allEntries.get(a));
		}
		search = new GuiTextFieldClearable(mc.fontRenderer, width/2 - 205, 5, 200, 20);
		buttonList.add(new GuiButton(2, width/2 + 5, 5, 200, 20, "Un Select All"));
		buttonList.add(new GuiButton(3, width/2 - 205, height-60, 200, 20, "Select All Ores"));
		buttonList.add(new GuiButton(4, width/2 + 5, height-60, 200, 20, "Select All Logs"));
		buttonList.add(new GuiButton(5, (width-150)/2, height-30, 150, 20, "Back"));
	}
	

	@Override
	protected void mouseClicked(int par1, int par2, int par3) {
		search.mouseClicked(par1, par2, par3);
		super.mouseClicked(par1, par2, par3);
	}

	String lastText = "";
	boolean lastClicked = false;
	@Override
	public void updateScreen() {
		if(!lastText.equals(search.getText())){
			lastText = search.getText();
			updateValuesBySearch(lastText);
		}
		search.updateCursorCounter();
		if(Mouse.getEventButtonState()){
			if(Mouse.getEventButton() == 1 && !lastClicked){
				if(search.isFocused()){
					search.setText("");
				}else{
			        int var1 = Mouse.getEventX() * this.width / this.mc.displayWidth;
			        int var2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
			        if(search.isInRange(var1, var2)){
			        	search.setFocused(true);
			        }
				}
			}
			lastClicked = true;
		}else{
			lastClicked = false;
		}
	}
	
	public void updateValuesBySearch(String param){
		visibleEntries.clear();
		if(param.equals("")){
			for(int a = 0; a < allEntries.size(); a++){
				visibleEntries.add(allEntries.get(a));
			}
		}else{
			String compare = param.toLowerCase();
			for(int a = 0; a < allEntries.size(); a++){
				BreakBlockEntry entry = allEntries.get(a);
				if(entry.getBlockName().toLowerCase().contains(compare)){
					visibleEntries.add(entry);
				}
			}
		}
	}

	@Override
	protected void actionPerformed(GuiButton gb) {
		if(gb.id == 2){
			for(int a = 0; a < allEntries.size(); a++){
				if(clone.options.remove(allEntries.get(a))){
					onRemove(allEntries.get(a));
				}
			}
		}else if(gb.id == 3){
			for(int a = 0; a < allEntries.size(); a++){
				if(clone.options.containsBreak(allEntries.get(a))){
					
				}
				BreakBlockEntry entry = allEntries.get(a);
				Block block = entry.getBlock();
				if(block != null && (block instanceof BlockOre || block instanceof BlockRedstoneOre)){
					if(!clone.options.containsBreak(allEntries.get(a))){
						clone.options.blocksCanBreak.add(entry);
						onAdd(entry);
					}
				}
			}
		}else if(gb.id == 4){
			for(int a = 0; a < allEntries.size(); a++){
				BreakBlockEntry entry = allEntries.get(a);
				Block block = entry.getBlock();
				if(block != null && (block instanceof BlockLog)){
					if(!clone.options.containsBreak(allEntries.get(a))){
						clone.options.blocksCanBreak.add(entry);
						onAdd(entry);
					}
				}
			}
		}else if(gb.id == 5){
			mc.displayGuiScreen(parent);
		}
	}



	static{
		getAllValidBlocks();
	}

	static ArrayList<BreakBlockEntry> allEntries;
	
	private static void getAllValidBlocks() {
		if(allEntries == null){
			allEntries = new ArrayList<BreakBlockEntry>();
		}
		System.out.println(Block.blocksList.length);
		for(int a = 0; a < Block.blocksList.length; a++){
			Block block = Block.blocksList[a];
			if(block != null && block.blockMaterial != Material.air){
				ArrayList<ItemStack> subTypes = new ArrayList<ItemStack>();
				block.getSubBlocks(a, null, subTypes);
				try{
					if(MyPeopleFieldGrabbers.blockHardness != null && MyPeopleFieldGrabbers.blockHardness(block) == -1.0F){
						continue;
					}
/*					if(block.getBlockHardness(null, 0, 0, 0) == -1.0F){
						continue;
					}*/
				}catch(Exception e){
					System.out.println("Dammit!");
					e.printStackTrace();
				}
				
				Material mat = block.blockMaterial;
				if(mat != null){
					if(mat.isLiquid()){
						continue;
					}
				}
				if(block instanceof BlockCrops || block.blockID == Block.crops.blockID){
					allEntries.add(new BreakBlockEntry(block.blockID, 7));
				}else{
					for(int b = 0; b < subTypes.size(); b++){
						ItemStack stack = subTypes.get(b);
						if(stack != null){
							if(stack.getItem() != null && stack.getDisplayName() != null && !stack.getDisplayName().equals("") && stack.getDisplayName().length() > 0){
								allEntries.add(new BreakBlockEntry(stack.itemID, stack.getItemDamage()));
							}
						}
					}
				}

			}
		}
		
	}

	public Minecraft getMc() {
		return mc;
	}
	
	
}
