package net.minecraft.mypeople;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerIncubator extends Container{

	InventoryPlayer playerInven = null;
	
	TileEntityIncubator te;
	
	int lastBurnTime = 0, lastItemBurnTime = 0, lastIncubateTime = 0;
	
	public ContainerIncubator(InventoryPlayer playerInven, TileEntityIncubator te) {
		this.playerInven = playerInven;
		this.te = te;
		this.addSlotToContainer(new SlotFuel(te, 0, 80, 50));
		
		for(int a = 0; a < 9; a++){
			this.addSlotToContainer(new SlotUnincubatedCapsule(te, a+1, 8 + (a * 18), 8));
		}
		
		
		
        for (int j = 0; j < 9; j++)
        {
        	addSlotToContainer(new Slot(playerInven, j, 8 + j * 18, 142));
        }
		
        for (int i = 0; i < 3; i++)
        {
            for (int k = 0; k < 9; k++)
            {
            	addSlotToContainer(new Slot(playerInven, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
	}
	
	

	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();

        for (int i = 0; i < this.crafters.size(); ++i)
        {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);

            if (this.lastIncubateTime != this.te.timeIncubated)
            {
                icrafting.sendProgressBarUpdate(this, 0, this.te.timeIncubated);
            }

            if (this.lastBurnTime != this.te.furnaceBurnTime)
            {
                icrafting.sendProgressBarUpdate(this, 1, this.te.furnaceBurnTime);
            }

            if (this.lastItemBurnTime != this.te.currentItemBurnTime)
            {
                icrafting.sendProgressBarUpdate(this, 2, this.te.currentItemBurnTime);
            }
        }

        this.lastIncubateTime = this.te.timeIncubated;
        this.lastBurnTime = this.te.furnaceBurnTime;
        this.lastItemBurnTime = this.te.currentItemBurnTime;
	}

    @SideOnly(Side.CLIENT)
    public void updateProgressBar(int par1, int par2)
    {
        if (par1 == 0)
        {
            this.te.timeIncubated = par2;
        }

        if (par1 == 1)
        {
            this.te.furnaceBurnTime = par2;
        }

        if (par1 == 2)
        {
            this.te.currentItemBurnTime = par2;
        }
    }


	@Override
	public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)inventorySlots.get(i);
        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if(i >= 0 && i < 10){
            	if(!te.isIncubating()){
                	if(!this.mergeItemStack(itemstack1, 10, 46, true)){
                		return null;
                	}
            	}
            }else{
            	if(SpawnData.isUnincubated(itemstack1)){
            		if(!te.isIncubating()){
            			if(!mergeItemStack(itemstack1, 1, 10, true)){
                			return null;
                		}
            		}
            	}else if(TileEntityFurnace.isItemFuel(itemstack1)){
            		if(!mergeItemStack(itemstack1, 0, 1, true)){
            			return null;
            		}
            	}else{
            		if(i >= 10 && i < 19){
            			if(!mergeItemStack(itemstack1, 19, 46, true)){
                			return null;
                		}
            		}else{
            			if(!mergeItemStack(itemstack1, 10, 19, true)){
                			return null;
                		}
            		}
            	}
            }
            if (itemstack1.stackSize == 0)
            {
                slot.putStack(null);
            }
            else
            {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize)
            {
                slot.onPickupFromSlot(par1EntityPlayer, itemstack1);
            }
            else
            {
                return null;
            }
        }
        return itemstack;
	}



	@Override
	protected void retrySlotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
	}



	@Override
	public boolean canInteractWith(EntityPlayer entityplayer) {
		return true;
	}

}
