package net.minecraft.mypeople;

import java.util.Random;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class TileEntityIncubator extends TileEntity implements IInventory{

	ItemStack[] items = new ItemStack[10];
	
	int furnaceBurnTime = 0, currentItemBurnTime = 0;//, timeSpun = 0;
	
	int totalTime = 300;//12000;
	
	int timeIncubated = 0;
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		NBTTagList itemss = nbt.getTagList("items");
		for(int a = 0; a < itemss.tagCount(); a++){
			NBTTagCompound item = (NBTTagCompound)itemss.tagAt(a);
			int slotID = item.getInteger("slotID");
			items[slotID] = ItemStack.loadItemStackFromNBT(item);
		}
		timeIncubated = nbt.getInteger("timeIncubated");
		furnaceBurnTime = nbt.getInteger("furnaceBurnTime");
		currentItemBurnTime = nbt.getInteger("currentItemBurnTime");
	}

	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		NBTTagList itemss = new NBTTagList();
		for(int a = 0; a < items.length; a++){
			if(items[a] != null){
				NBTTagCompound item = new NBTTagCompound();
				item.setInteger("slotID", a);
				items[a].writeToNBT(item);
				itemss.appendTag(item);
			}
		}
		nbt.setTag("items", itemss);
		nbt.setInteger("timeIncubated", timeIncubated);
		nbt.setInteger("furnaceBurnTime", furnaceBurnTime);
		nbt.setInteger("currentItemBurnTime", currentItemBurnTime);
	}
	
	public float getFuelDone() {
		return (((float) furnaceBurnTime / ((float) currentItemBurnTime)));
	}
	
	public float getIncubateDone(){
		return ((float)timeIncubated) / ((float)totalTime);
	}

	@Override
	public void updateEntity() {
		if (furnaceBurnTime > 0) {
			furnaceBurnTime--;
			if(furnaceBurnTime < 1 && !(furnaceBurnTime == 0 && canIncubate(true))){
				worldObj.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 0, 2);
			}
		}

		if (furnaceBurnTime == 0 && canIncubate(true)) {
			currentItemBurnTime = furnaceBurnTime = TileEntityFurnace.getItemBurnTime(items[0]);
			if(worldObj.getBlockMetadata(xCoord, yCoord, zCoord) == 0){
				worldObj.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 1, 2);
			}
			if (furnaceBurnTime > 0) {
				items[0].stackSize--;
				if (items[0].stackSize <= 0) {
					items[0] = null;
				}
			}
		}
		
		if(isBurning() && canIncubate(false)){
			timeIncubated++;
			if(timeIncubated >= totalTime){
				timeIncubated = 0;
				onIncubated();
			}
		}else if(!isBurning() && isIncubating()){
			timeIncubated = 0;
		}
	}
	
	public void onIncubated(){
		for(int a = 1; a < getSizeInventory(); a++){
			ItemStack stack = items[a];
			if(stack != null){
				if(stack.itemID == MyPeople.customSpawnEgg.itemID){
					stack.setItemDamage(1);
					SpawnData data = SpawnData.get(stack);
					data.incubated = true;
					stack.setTagCompound(data.toTagCompound());
				}
			}
		}
	}
	
	public boolean isIncubating(){
		return timeIncubated > 0;
	}
	
	public boolean isBurning(){
		return furnaceBurnTime > 0;
	}
	
	public boolean canIncubate(boolean fuelCheck){
		if(!fuelCheck || (items[0] != null && TileEntityFurnace.isItemFuel(items[0]))){
			for(int a = 1; a < this.getSizeInventory(); a++){
				if(items[a] != null && items[a].itemID == MyPeople.customSpawnEgg.itemID && SpawnData.isUnincubated(items[a])){
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public int getSizeInventory() {
		return items.length;
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return items[i];
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		if (items[i] != null) {
			if (items[i].stackSize <= j) {
				ItemStack itemstack = items[i];
				items[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = items[i].splitStack(j);
			if (items[i].stackSize == 0) {
				items[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int i) {
        if (items[i] != null)
        {
            ItemStack itemstack = items[i];
            items[i] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		items[i] = itemstack;
		if (itemstack != null && itemstack.stackSize > getInventoryStackLimit()) {
			itemstack.stackSize = getInventoryStackLimit();
		}
	}

	@Override
	public String getInvName() {
		return "Incubator";
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public int getInventoryStackLimit() {
		return 64;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		}
		return entityplayer.getDistanceSq((double) xCoord + 0.5D,
				(double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
	}

	@Override
	public void openChest() {}

	@Override
	public void closeChest() {}

	@Override
	public boolean isStackValidForSlot(int i, ItemStack itemstack) {
		return false;
	}
	

	public void dropAllItems(World world, int x, int y, int z) {
		if(!world.isRemote){
			Random r = new Random();
			for(int a = 0; a < items.length; a++){
				if(items[a] != null){
					EntityItem item = new EntityItem(world, x+.5, y+.5, z+.5, items[a]);
					item.delayBeforeCanPickup = 10;
					item.setVelocity(r.nextFloat()/10.0f, .2f, r.nextFloat()/10.0f);
					world.spawnEntityInWorld(item);
				}
			}
		}
	}

}
