package net.minecraft.mypeople;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityHumanEgg extends TileEntity{
	
	public TileEntityHumanEgg(){
		timeStarted = 0;
	}
	
	public TileEntityHumanEgg(World var1){
		timeStarted = 0;
	}
	
	public TileEntityHumanEgg(World var1, String owner){
		timeStarted = 0;
		this.owner = owner;
	}
	
	String owner = "";
	
	int timeout = 0;

	long timeStarted = 0;
	Random r = new Random();
	boolean zapped = false;
	long size = 0;
	int ticksSinceLastUpdate = 0;
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		size = nbt.getLong("size");
		zapped = nbt.getBoolean("zapped");
		owner = nbt.getString("owner");
	}
	
	



	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		nbt.setLong("size", size);
		nbt.setBoolean("zapped", zapped);
		nbt.setString("owner", owner);
	}

    private float getSoundPitch()
    {
    	return (r.nextFloat() - r.nextFloat()) * 0.2F + 1.0F;
    }
    
    public long getDiff(){
    	return size - worldObj.getWorldTime();
    }
    
    public float getFloatDone(){
    	return (float)(((double)getDiff()) / ((double)getTimeInTicks()));
    }
    
    public float percentDone(){
    	return (float)((48000d-(double)getDiff())/48000d);
    }

	@Override
	public void updateEntity() {
		if(zapped){
			if(worldObj.isRemote && timeout-- < 1){
				float f = r.nextFloat();
				if(f < ((.5 * percentDone()) + .1f)){
					worldObj.playSoundEffect(((double)xCoord)+.5D, ((double)yCoord)+.5D, ((double)zCoord)+.5D, "step.gravel", (.6f*percentDone())+.2f, getSoundPitch());
					spawnParticles(-1);
				}
				timeout = 80;
			}
			if(worldObj.getWorldTime()>size){
				if(!worldObj.isRemote){
					Minecraft.getMinecraft().sndManager.playSound(Block.blocksList[MyPeople.humanEgg.blockID].stepSound.getStepSound(), (float)xCoord + 0.5F, (float)yCoord + 0.5F, (float)zCoord + 0.5F, (Block.blocksList[MyPeople.humanEgg.blockID].stepSound.getVolume() + 1.0F) / 8F, Block.blocksList[MyPeople.humanEgg.blockID].stepSound.getPitch() * 0.5F);
					worldObj.setBlock(xCoord, yCoord, zCoord, 0, 0, 2);
					EntityMyPerson clone = new EntityMyPerson(worldObj);
					clone.setPosition(xCoord+.5, yCoord+.1, zCoord+.5);
					clone.setOwner(owner);
					worldObj.spawnEntityInWorld(clone);
					for(int a = 0; a < 5; a++){
						worldObj.playSoundEffect(((double)xCoord)+.5D, ((double)yCoord)+.5D, ((double)zCoord)+.5D, "random.fizz", 1.2f, getSoundPitch());
					}
					for(int a = 0; a < 5; a++){
						worldObj.playSoundEffect(((double)xCoord)+.5D, ((double)yCoord)+.5D, ((double)zCoord)+.5D, "step.gravel", 1.2f, getSoundPitch());
					}
				}
				spawnParticles(200);
			}
			if(timeStarted < System.currentTimeMillis()){
				timeStarted += 1000;
				size += (1f-(1f*worldObj.getLightBrightness(xCoord, yCoord, zCoord)))*20;
				if(timeStarted +1000 < System.currentTimeMillis()){
					timeStarted = System.currentTimeMillis();
				}
			}
		}
		if(!worldObj.isRemote){
			if(ticksSinceLastUpdate++ >= 20){
				updateToUnknownPlayers();
				ticksSinceLastUpdate = 0;
			}
		}
	}

	ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
	
	private void updateToUnknownPlayers() {
		List list = worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox(xCoord, yCoord, zCoord, xCoord+1, yCoord+1, zCoord+1).expand(64, 32, 64));
		ArrayList<EntityPlayer> playersOut = new ArrayList<EntityPlayer>();
		ArrayList<EntityPlayer> newPlayers = new ArrayList<EntityPlayer>();
		for(int a = 0; a < list.size(); a++){
			Object o = list.get(a);
			if(o != null && o instanceof EntityPlayer){
				EntityPlayer player = (EntityPlayer)o;
				if(!players.contains(player)){
					newPlayers.add(player);
				}
				playersOut.add(player);
			}
		}
		players = playersOut;
		for(int a = 0; a < newPlayers.size(); a++){
			EntityPlayer pl = newPlayers.get(a);
			if(pl instanceof EntityPlayerMP){
				EntityPlayerMP player = (EntityPlayerMP)pl;
				NBTTagCompound nbt = new NBTTagCompound();
				writeToNBT(nbt);
				System.out.println("Sending to " + player.username);
				MyPeople.packetHandler.sendPacketToClient(MyPeoplePacketType.clientUpdateEggInfo.id, nbt, player);
			}
		}
	}
	
	private void spawnParticles(int amount) {
		
			if(amount <= 0){
				int done = (int)Math.floor(percentDone()*50d);
				if(done < 1){done=1;};
				amount = (int)Math.floor(percentDone()*50d)+r.nextInt(done);
			}
//			System.out.println("Spawing " + amount + " on " + (worldObj.isRemote?"Client":"Server") + "side");
			if(!worldObj.isRemote){
				for(int a = 0; a < players.size(); a++){
					EntityPlayer ep = players.get(a);
					if(ep instanceof EntityPlayerMP){
						MyPeople.packetHandler.sendPacketToClient(MyPeoplePacketType.clientEggParticles.id, new Object[]{xCoord, yCoord, zCoord, amount}, (EntityPlayerMP)ep);
					}
				}
			}else{
				particle(xCoord, yCoord, zCoord, amount, worldObj);
			}
	}
	
	public static void particle(int xCoord, int yCoord, int zCoord, int amount, World worldObj){
		Random r = new Random();
		for(int a = 0; a < amount; a++){
			worldObj.spawnParticle("tilecrack_" + MyPeople.humanEgg.blockID + "_0", (double)xCoord + ((r.nextFloat()*2d)-1d)/2d+.5d, (double)yCoord + ((r.nextFloat()))/2d+.2d, (double)zCoord + ((r.nextFloat()*2d)-1d)/2d+.5d, ((r.nextFloat())-.5f), r.nextFloat(), ((r.nextFloat())-.5f));
		}	
	}

	public void onPowered() {
		if(zapped == false){
			zapped = true;
			size = worldObj.getWorldTime() + getTimeInTicks();
			for(int a = 0; a < 6; a++){
				worldObj.playSoundEffect(((double)xCoord)+.5D, ((double)yCoord)+.5D, ((double)zCoord)+.5D, "random.fizz", 2f, getSoundPitch());
			}
		}else if(zapped == true){
			size = size - 20;
		}
	}
	
    public int timeLeft(){
    	return ((int)(size-worldObj.getWorldTime())/20);
    }
	
	public int getTimeInSeconds(){
		return 2400;
	}
	
	public int getTimeInTicks(){
		return getTimeInSeconds() * 20;
	}

	

	public String getTime(long seconds){
		int yearsRemaining = (int)((seconds/31536000));
		seconds-= yearsRemaining*31536000;
		
		int daysRemaining = (int)((seconds/86400) % 365);
		seconds-= daysRemaining*86400;
		
		int hoursRemaining = (int)((seconds/3600) % 24);
		seconds-= hoursRemaining*3600;
		
		int minutesRemaining = (int)((seconds/60) % 60);
		seconds-= minutesRemaining*60;
		
		int secondsRemaining = (int)(seconds);
		seconds-= secondsRemaining;
		
		ArrayList<String> datas = new ArrayList<String>();
		
		if(yearsRemaining > 0){
			datas.add((yearsRemaining + " year" + (yearsRemaining>1?"s":"")));
		}
		if(daysRemaining > 0){
			datas.add((daysRemaining + " day" + (daysRemaining>1?"s":"")));
		}
		if(hoursRemaining > 0){
			datas.add((hoursRemaining + " hour" + (hoursRemaining>1?"s":"")));
		}
		if(minutesRemaining > 0){
			datas.add((minutesRemaining + " minute" + (minutesRemaining>1?"s":"")));
		}
		if(secondsRemaining > 0){
			datas.add((secondsRemaining + " second" + (secondsRemaining>1?"s":"")));
		}
		String returnString = "";
		while(datas.size() > 0){
			String value = datas.remove(0);
			returnString = returnString + " " + value + (datas.size()==1?" and":(datas.size()>1?",":""));
		}
		return returnString.trim();
	}

	
	public String getTimeRemainingMC(){
		return getTime((int)(timeLeft()*72));
	}

	public String getTimeRemaining() {
		
		return getTime(timeLeft());
	}
	
	
	//
	
	
}
