package net.minecraft.mypeople;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import cpw.mods.fml.common.network.IGuiHandler;

public class MyPersonGuiHandler implements IGuiHandler{

	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if(ID == CENTRIFUGE){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityCentrifuge){
				return new ContainerCentrifuge(player.inventory, (TileEntityCentrifuge)te);
			}else{
				System.out.println("Server: TileEntityCentrifuge does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONEINVEN){
			Entity e = world.getEntityByID(x);
			if(e instanceof EntityMyPerson){
				EntityMyPerson clone = (EntityMyPerson)e;
				return new ContainerTransferPlayerItems(player, clone);
			}else{
				System.out.println("Entity doesn't exist on server");
			}
		}else if(ID == SPLICER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntitySplicer){
				return new ContainerSplicer(player.inventory, (TileEntitySplicer)te);
			}else{
				System.out.println("Server: TileEntitySplicer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == INCUBATOR){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityIncubator){
				return new ContainerIncubator(player.inventory, (TileEntityIncubator)te);
			}else{
				System.out.println("Server: TileEntityIncubator does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityDnaCloner){
				System.out.println("Ret1");
				return new ContainerDnaCloner(player.inventory, (TileEntityDnaCloner)te);
			}else{
				System.out.println("Server: TileEntityDnaCloner does not exist at " + x + ", " + y + ", " + z);
			}
		}
		return null;
	}

	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if(ID == CENTRIFUGE){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityCentrifuge){
				return new GuiCentrifuge(player, (TileEntityCentrifuge)te);
			}else{
				System.out.println("Client: TileEntityCentrifuge does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONEINVEN){
			Entity e = world.getEntityByID(x);
			if(e instanceof EntityMyPerson){
				EntityMyPerson clone = (EntityMyPerson)e;
				return new GuiTransferPlayerItems(clone, player, false);
			}else{
				System.out.println("EntityClone doesn't exist on client");
			}
		}else if(ID == PERSONFINDER){
			return new GuiCloneTracker();
		}else if(ID == SPLICER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntitySplicer){
				return new GuiSplicer(player.inventory, (TileEntitySplicer)te);
			}else{
				System.out.println("Client: TileEntitySplicer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == INCUBATOR){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityIncubator){
				return new GuiIncubator(player.inventory, (TileEntityIncubator)te);
			}else{
				System.out.println("Server: TileEntityIncubator does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONER){

			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityDnaCloner){
				System.out.println("Ret2");
				return new GuiDnaCloner(player.inventory, (TileEntityDnaCloner)te);
			}else{
				System.out.println("Server: TileEntityDnaCloner does not exist at " + x + ", " + y + ", " + z);
			}
		}
		return null;
	}
	public static int CLONER = 5;
	public static int INCUBATOR = 4;
	public static int SPLICER = 3;
	public static int PERSONFINDER = 2;
	public static int CLONEINVEN = 1;
	public static int CENTRIFUGE = 0;


}
