package net.minecraft.mypeople;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;

public class MyPeoplePacketHandler implements IPacketHandler{

	@Override
	public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
/*		System.out.println("Player:" + player);
		if(player != null) System.out.println(player.getClass());*/
		
		if(packet.channel.equals("MyPeopleClient")){
			if(player != null && player instanceof EntityClientPlayerMP){
				MyPeople.clientHandler.processPacket(((EntityClientPlayerMP)player).sendQueue, packet);
			}
		}else if(packet.channel.equals("MyPeopleServer")){
			if(player != null && player instanceof EntityPlayerMP){
				MyPeople.serverHandler.processPacket(((EntityPlayerMP)player).playerNetServerHandler, packet);
			}

		}else{
			System.out.println("Unknown channel type");
		}
	}
	
	
	
	
	
	public void sendPacketToServer(int id, Object[] data){
		Packet250CustomPayload packet = create(id, data, Side.SERVER);
		PacketDispatcher.sendPacketToServer(packet);
	}
	
	public void sendPacketToServer(int id, NBTTagCompound data){
		Packet250CustomPayload packet = create(id, data, Side.SERVER);
		PacketDispatcher.sendPacketToServer(packet);
	}
	
	public void sendPacketToClient(int id, NBTTagCompound data, EntityPlayerMP player){
		Packet250CustomPayload packet = create(id, data, Side.CLIENT);
		player.playerNetServerHandler.sendPacketToPlayer(packet);
	}
	
	public void sendPacketToClient(int id, Object[] data, EntityPlayerMP player){
		Packet250CustomPayload packet = create(id, data, Side.CLIENT);
		player.playerNetServerHandler.sendPacketToPlayer(packet);
	}
	
	public static Packet250CustomPayload create(int type, NBTTagCompound nbt, Side sideToSendTo){
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(output);
		try {
			out.writeInt(type);
			CompressedStreamTools.write(nbt, out);
		} catch (Exception e) {
			e.printStackTrace();
		}
		Packet250CustomPayload custom = new Packet250CustomPayload(sideToSendTo == Side.CLIENT?"MyPeopleClient":"MyPeopleServer", output.toByteArray());
		try{
			out.close();
			output.close();
		}catch(Exception e){
			e.printStackTrace();
		}
		return custom;
	}
	
	public static Packet250CustomPayload create(int type, Object[] datas, Side sideToSendTo){
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(output);
		try {
			out.writeInt(type);
		} catch (Exception e) {
			e.printStackTrace();
		}
		for(int a = 0; a < datas.length; a++){
			try{
				if(datas[a] != null){
					if(datas[a] instanceof String){
						out.writeUTF((String)datas[a]);
					}else if(datas[a] instanceof Integer){
						out.writeInt((Integer)datas[a]);
					}else if(datas[a] instanceof Double){
						out.writeDouble((Double)datas[a]);
					}else if(datas[a] instanceof Float){
						out.writeFloat((Float)datas[a]);
					}else if(datas[a] instanceof Short){
						out.writeShort((Short)datas[a]);
					}else if(datas[a] instanceof Long){
						out.writeLong((Long)datas[a]);
					}else if(datas[a] instanceof Boolean){
						out.writeBoolean((Boolean)datas[a]);
					}else if(datas[a] instanceof Character){
						out.writeChar((Character)datas[a]);
					}else if(datas[a] instanceof ItemStack){
						Packet.writeItemStack((ItemStack)datas[a], out);
					}else{
						System.out.println("!!Error!!  Unknown Type: " + datas[a].getClass());
					}
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		Packet250CustomPayload custom = new Packet250CustomPayload(sideToSendTo == Side.CLIENT?"MyPeopleClient":"MyPeopleServer", output.toByteArray());
		try{
			out.close();
			output.close();
		}catch(Exception e){
			e.printStackTrace();
		}
		return custom;
	}

	public void sendPacketToServer(Packet packet) {
		PacketDispatcher.sendPacketToServer(packet);
	}
	public void sendPacketToClient(Packet packet, EntityPlayerMP e) {
		e.playerNetServerHandler.sendPacketToPlayer(packet);
	}

}
