package net.minecraft.mypeople;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class MyPeopleEggRecipes implements IRecipe{

	@Override
	public boolean matches(InventoryCrafting inventorycrafting, World world) {
		ItemStack needle = null, bonemeal = null, egg = null;
		for(int a = 0; a < inventorycrafting.getSizeInventory(); a++){
			ItemStack stack = inventorycrafting.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == MyPeople.needleDNA.itemID){
					if(needle == null){
						needle = stack;
					}else{
						return false;
					}
				}else if(stack.itemID == Item.egg.itemID){
					if(egg == null){
						egg = stack;
					}else{
						return false;
					}
				}else if(stack.itemID == Item.dyePowder.itemID && stack.getItemDamage() == 15){
					if(bonemeal == null){
						bonemeal = stack;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}
		}
		return needle != null && bonemeal != null && egg != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
		ItemStack needle = null, bonemeal = null, egg = null;
		for(int a = 0; a < inventorycrafting.getSizeInventory(); a++){
			ItemStack stack = inventorycrafting.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == MyPeople.needleDNA.itemID){
					if(needle == null){
						needle = stack;
					}else{
						return null;
					}
				}else if(stack.itemID == Item.egg.itemID){
					if(egg == null){
						egg = stack;
					}else{
						return null;
					}
				}else if(stack.itemID == Item.dyePowder.itemID && stack.getItemDamage() == 15){
					if(bonemeal == null){
						bonemeal = stack;
					}else{
						return null;
					}
				}else{
					return null;
				}
			}
		}
		if(needle != null && bonemeal != null && egg != null){
			if(needle.getItemDamage() == 0 || needle.getItemDamage() == MyPeople.cloneID){
				return new ItemStack(MyPeople.humanEgg, 1, 0);
			}else{
				return new ItemStack(Item.monsterPlacer, 1, needle.getItemDamage());
			}
			
		}
		return null;
	}

	@Override
	public int getRecipeSize() {
		return 10;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return null;
	}

}
