package net.minecraft.mypeople;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import org.lwjgl.opengl.GL11;

public class GuiIncubator extends GuiContainer{

	TileEntityIncubator te;

	
	public GuiIncubator(InventoryPlayer playerInven, TileEntityIncubator te) {
		super(new ContainerIncubator(playerInven, te));
		this.te = te;
	}


	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		GL11.glPushMatrix();
    	int k = mc.renderEngine.getTexture("/MyPeople/incubator.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        drawTexturedModalRect(8+l, 72+i1, 0, 166, (int)Math.round(160d*te.getIncubateDone()), 6);
        mc.renderEngine.resetBoundTexture();
        GL11.glPopMatrix();
        if(te.isBurning()){
        	GL11.glPushMatrix();
        	GL11.glTranslatef(l, i1, 0);
        	GL11.glDisable(GL11.GL_LIGHTING);
        	GL11.glEnable(GL11.GL_BLEND);
        	GL11.glBlendFunc (GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 0.6F);
            GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        	int minus = (int)Math.round(14d*te.getFuelDone());
        	drawTexturedModalRect(81, 51+(14-minus), 177, 1+(14-minus), 14, minus);
        	GL11.glDisable(GL11.GL_BLEND);
        	zLevel += 2;
        	drawHeat();
        	zLevel -= 2;
        	mc.renderEngine.resetBoundTexture();
        	GL11.glEnable(GL11.GL_LIGHTING);
        	GL11.glPopMatrix();
        }
	}

	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {

	}
	
	
	
	@Override
	protected void handleMouseClick(Slot par1Slot, int par2, int par3, int par4) {
        if (par1Slot != null){
            par2 = par1Slot.slotNumber;
            if(par2 > 0 && par2 < 10){
            	if(te.isIncubating()){
            		return;
            	}
            }
        }

        this.mc.playerController.windowClick(this.inventorySlots.windowId, par2, par3, par4, this.mc.thePlayer);
	}
	
	int heatTimer = 0;

	@Override
	public void updateScreen() {
		super.updateScreen();
		if(te.isBurning()){
			heatTimer++;
			if(heatTimer >= 240){
				heatTimer = 0;
			}
		}else if(heatTimer > 0){
			heatTimer = 0;
		}
	}
	
	public void drawHeat(){
		//0, 172   148, 24
		//14, 25
		
		float alpha = 1.0f;
		
		int leftOver = (heatTimer % 120) / 5;
		int stage = heatTimer / 120;
		int yAdd = 0;
		int height = 0;
		if(stage == 0){
			yAdd = (24- leftOver);
			height = leftOver;
			alpha = (((float)(heatTimer%120)) / 120.0f);
		}else if(stage == 1){
			yAdd = 0;
			height = 24-leftOver;
			alpha = (((float)(120 - (heatTimer%120))) / 120.0f);
		}
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glColor4f(1.0f, 1.0f, 1.0f, alpha);
		this.drawTexturedModalRect(14, 25+yAdd, 0, 172+yAdd, 148, height);
		
		GL11.glDisable(GL11.GL_BLEND);
	}
	
	

}
