package net.minecraft.mypeople;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiDnaCloner extends GuiContainer{

	TileEntityDnaCloner te;
	
	public GuiDnaCloner(InventoryPlayer p, TileEntityDnaCloner t) {
		super(new ContainerDnaCloner(p, t));
		this.te = t;
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		GL11.glPushMatrix();
    	int k = mc.renderEngine.getTexture("/MyPeople/dnaCloner.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        drawTexturedModalRect(8+l, 72+i1, 0, 166, (int)Math.round(160d*te.getCopyDone()), 6);
        mc.renderEngine.resetBoundTexture();
        GL11.glPopMatrix();
        drawLiquids(l, i1);
        if(te.isBurning()){
        	GL11.glPushMatrix();
        	GL11.glTranslatef(l, i1, 0);
        	GL11.glDisable(GL11.GL_LIGHTING);
        	GL11.glEnable(GL11.GL_BLEND);
        	GL11.glBlendFunc (GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 0.6F);
            GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        	int minus = (int)Math.round(14d*te.getFuelDone());
        	drawTexturedModalRect(87, 43+(14-minus), 177, 1+(14-minus), 14, minus);
        	GL11.glDisable(GL11.GL_BLEND);
        	zLevel += 2;
        	zLevel -= 2;
        	mc.renderEngine.resetBoundTexture();
        	GL11.glEnable(GL11.GL_LIGHTING);
        	GL11.glPopMatrix();
        }
	}
	
	public void drawLiquids(int x, int y){
		GL11.glPushMatrix();
		GL11.glTranslatef(x, y, 0);
		if(te.blood > 0){
			this.drawRect(110, 59-te.blood, 126, 59, 0xffc81414);
		}
		if(te.water > 0){
			this.drawRect(132, 59-te.water, 148, 59, 0xff4343b4);
		}
		if(te.souls > 0){
			this.drawRect(152, 59-te.souls, 168, 59, 0xff553322);
		}
		GL11.glPopMatrix();
	}


}
