package net.minecraft.mypeople;

import java.util.ArrayList;
import java.util.Random;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class GuiCloneTracker extends GuiScreen{

	GuiListBox box;
	static ArrayList<EntityMyPerson> entities = new ArrayList<EntityMyPerson>();
	GuiButton edit, goTo, comeTo;
	int x = 0, xSize = 240;
	int y = 0, ySize = 224;
	double errorDisplayTime = 0d;
	
	
	@Override
	public void initGui() {
		x = (width-xSize)/2;
		y = (height-ySize)/2;
		buttonList.add(box = new GuiListBox(0, x+8, y+8, 160, 206, new String[0][0], 4));
		buttonList.add(new GuiButton(1, x+178, y+10, 50, 20, "Clear"));
		buttonList.add(new GuiButton(2, x+178, y+35, 50, 20, "Done"));
		buttonList.add(edit = new GuiButton(3, x+178, y+85, 50, 20, "Edit"));
		buttonList.add(goTo = new GuiButton(4, x+178, y+120, 50, 20, "GoTo"));
		buttonList.add(comeTo = new GuiButton(5, x+178, y+145, 50, 20, "ComeTo"));
		if(MyPeople.instance.cloneToFind != null){
			for(int a = 0; a < entities.size(); a++){
				if(entities.get(a).entityId == MyPeople.instance.cloneToFind.entityId){
					box.idSelected = a;
				}
			}
		}
		getAllClones(false);
	}
	
	public void drawScreen(int i, int j, float f) {
		drawDefaultBackground();

		GL11.glTranslatef(0, 0, 100F);
		GL11.glBindTexture(GL11.GL_TEXTURE_2D, mc.renderEngine.getTexture("/MyPeople/findplayers.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		drawTexturedModalRect(x, y, 0, 0, xSize, ySize);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		this.drawCenteredString(mc.fontRenderer, "You or the clone must have redstone to do that function.", width/2, height-9, getColour());
		GL11.glDisable(GL11.GL_BLEND);
		GL11.glColor4f(1, 1, 1, 1);
		super.drawScreen(i, j, f);
		GL11.glTranslatef(0, 0, -100F);
		renderPlayerStuff(i, j);
	}
	
	
	
	

	private void renderPlayerStuff(int i, int j) {
		if(box != null && box.idSelected > -1 && box.idSelected < entities.size()){
			EntityLiving e = entities.get(box.idSelected);
			if(e instanceof EntityMyPerson){
				EntityMyPerson p = (EntityMyPerson)e;
				renderEntity(e, i, j, 50, 200, 10, 50);
				if(e != null && e instanceof EntityMyPerson){
					if(p.entityToAttack != null){
						renderEntity((EntityLiving)p.entityToAttack, i, j, width-50, 200, -300, 90);
					}
				}
			}
		}
		
	}
	
	public void renderEntity(EntityLiving thePlayer, int i, int l, int X, int Y, int mouseX, int mouseY){
		GL11.glPushMatrix();
        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        GL11.glEnable(GL11.GL_COLOR_MATERIAL);
        GL11.glPushMatrix();
        GL11.glTranslatef(X, Y, 50F);
        float f = 50F;
        GL11.glScalef(-f, f, f);
        GL11.glRotatef(180F, 0.0F, 0.0F, 1.0F);
        float f1 = thePlayer.renderYawOffset;
        float f2 = thePlayer.rotationYaw;
        float f3 = thePlayer.rotationPitch;
        float f4 = (float)(10 + 51) - i - mouseX;
        float f5 = (float)((40 + 75) - 50) - l + mouseY;
        GL11.glRotatef(135F, 0.0F, 1.0F, 0.0F);
        RenderHelper.enableStandardItemLighting();
        GL11.glRotatef(-135F, 0.0F, 1.0F, 0.0F);
        GL11.glRotatef(-(float)Math.atan(f5 / 40F) * 20F, 1.0F, 0.0F, 0.0F);
        thePlayer.renderYawOffset = (float)Math.atan(f4 / 40F) * 20F;
        thePlayer.rotationYaw = (float)Math.atan(f4 / 40F) * 40F;
        thePlayer.rotationPitch = -(float)Math.atan(f5 / 40F) * 20F;
        thePlayer.rotationYawHead = thePlayer.rotationYaw;
        GL11.glTranslatef(0.0F, thePlayer.yOffset, 0.0F);
        RenderManager.instance.playerViewY = 180F;
        RenderManager.instance.renderEntityWithPosYaw(thePlayer, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F);
        thePlayer.renderYawOffset = f1;
        thePlayer.rotationYaw = f2;
        thePlayer.rotationPitch = f3;
        GL11.glPopMatrix();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
        GL11.glDisable(GL11.GL_COLOR_MATERIAL);
        GL11.glPopMatrix();
	}

	private int getColour() {
		int alpha = (int)Math.round((errorDisplayTime/100d) *255d);
		if(alpha < 8){
			alpha = 8;
		}
		int out = 0;
		out = (out | alpha) << 24;
		out |= 0xee3300;
		return out;
	}

	@Override
	protected void actionPerformed(GuiButton gb) {
		Random r = new Random();
		if(gb.id == 1){
			if(box != null){
				box.idSelected = -1;
			}
		}else if(gb.id == 2){
			mc.displayGuiScreen(null);
		}else if(gb.id == 3){
			int selected = box.idSelected;
			if(selected >= 0 && selected < entities.size()){
				mc.displayGuiScreen(new GuiMyPersonOptions(entities.get(selected).options, entities.get(selected), this));
			}
		}else if(gb.id == 4){
			int selected = box.idSelected;
			if(selected >= 0 && selected < entities.size()){
				EntityMyPerson e = entities.get(box.idSelected);
				if(e != null){
					MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverTeleportClone.id, new Object[]{true, e.entityId/*, e.worldObj.getWorldInfo().getDimension()*/});
				}
			}
		}else if(gb.id == 5){
			int selected = box.idSelected;
			if(selected >= 0 && selected < entities.size()){
//				boolean tp = true;
				EntityMyPerson e = entities.get(box.idSelected);
				if(e != null){
					MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverTeleportClone.id, new Object[]{false, e.entityId/*, e.worldObj.getWorldInfo().getDimension()*/});
				}
			}
		}
	}
	
	public static void throwParticles(EntityLiving e, Random r, World theWorld) {
		theWorld.playSoundEffect(e.posX, e.posY, e.posZ, "random.explode", 4F, (1.0F + (theWorld.rand.nextFloat() - theWorld.rand.nextFloat()) * 0.1F) * 0.7F);
		double outof = r.nextInt(10)+30;
		for(int a = 0; a < outof; a++){
			double d = ((double)a)/outof*360d;
			double x = 1;
			double z = 1;
			if(d >= 0 && d < 90){
				x *= (90-(d%90));
				z *= (d%90);
			}else if(d >= 90 && d < 180){
				x *= (90-(d%90))*-1;
				z *= (d%90);
			}else if(d >= 180 && d < 270){
				x *= (90-(d%90));
				z *= (d%90)*-1;
			}else{
				x *= (90-(d%90))*-1;
				z *= (d%90)*-1;
			}
			x /= 90;
			z /= 90;
			theWorld.spawnParticle("explode", e.posX+gd(r), e.posY+gd(r), e.posZ+gd(r), x, r.nextDouble()/3, z);
			theWorld.spawnParticle("smoke", e.posX+gd(r), e.posY+gd(r), e.posZ+gd(r), x, r.nextDouble()/3, z);
		}
		for(int a = 0; a < 40; a++){
			theWorld.spawnParticle("reddust", e.posX+gd(r), e.posY+gd(r), e.posZ+gd(r), 1d, r.nextDouble()/6, r.nextDouble()/6);
		}
	}

	
	public static double gd(Random r){
		return (r.nextDouble()*1.5d)-.75d;
	}
	


	boolean isLoading = false;

	public void setClones(NBTTagCompound nbt){
		isLoading = false;
		entities.clear();
		NBTTagList list = nbt.getTagList("Datas");
		String[][] data = new String[list.tagCount()][3];
		for(int a = 0; a < list.tagCount(); a++){
			NBTTagCompound entry = (NBTTagCompound)list.tagAt(a);
			EntityMyPerson person = new EntityMyPerson(mc.theWorld);
			person.readFromNBT(entry);
			int entityId = entry.getInteger("theEntityId");
			person.entityId = entityId;
			entities.add(person);
			
			boolean isAttacking = entry.getBoolean("isAttacking");
			String attacker = "";
			if(isAttacking){
				attacker = entry.getString("attacker");
			}
			boolean walking = entry.getBoolean("walking");
			
			data[a][0] = person.name + "  (Health: " + person.getHealth() + "/"+ person.getMaxHealth() + ")";
			data[a][1] = "X: " + Math.round(person.posX) + "   Y: " + Math.round(person.posY) + "   Z: " + Math.round(person.posZ);
			data[a][2] = "Status: " + (isAttacking?"Attacking " + attacker:(walking?"Walking":"Waiting"));
		}
		box.idSelected = -1;
		if(MyPeople.instance.cloneToFind != null){
			for(int a = 0; a < entities.size(); a++){
				if(entities.get(a).entityId == MyPeople.instance.cloneToFind.entityId){
					box.idSelected = a;
				}
			}
		}
		box.set(data);//getInfoFromPlayers(entities));
	}

	private void getAllClones(boolean reset) {
		if(reset){
			isLoading = true;
			box.set(new String[0][0]);
		}
		MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverUpdateTracker.id, new Object[]{-1});
	}


	public String[][] getInfoFromPlayers(ArrayList<EntityMyPerson> entities) {
		String[][] data = new String[entities.size()][3];
		for(int a = 0; a < entities.size(); a++){
			EntityMyPerson e = entities.get(a);
			data[a][0] = e.username + "  (Health: " + e.getHealth() + "/"+ e.getMaxHealth() + ")";
			data[a][1] = "X: " + Math.round(e.posX) + "   Y: " + Math.round(e.posY) + "   Z: " + Math.round(e.posZ);
			data[a][2] = "Status: " + (e.entityToAttack!=null?"Attacking " + e.entityToAttack.getEntityName():(e.getNavigator().getPath() != null?"Walking":"Waiting"));
		}
		return data;
	}
	
	
	int lastSelected = -1;

	long ticks = 0;
	
	@Override
	public void updateScreen() {
		ticks++;
		if(box.idSelected != lastSelected){
			lastSelected = box.idSelected;
			if(box.idSelected < 0){
				MyPeople.instance.cloneToFind = null;
			}else if(entities.size() > box.idSelected){
				EntityMyPerson clone = entities.get(box.idSelected);
				if(clone != null){
					MyPeople.instance.cloneToFind = clone;
				}
			}
		}
		if(box.idSelected >= 0 && box.idSelected < entities.size()){
			edit.enabled = true;
			comeTo.enabled = true;
			goTo.enabled = true;
		}else{
			edit.enabled = false;
			comeTo.enabled = false;
			goTo.enabled = false;
			if(box.idSelected >= 0){
				box.idSelected = -1;
				MyPeople.instance.cloneToFind = null;
			}
		}
		if(ticks > 10){
			getAllClones(false);
			ticks = 0;
		}
		if(errorDisplayTime > 0){
			errorDisplayTime--;
		}
		
		
	}





	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}

	public void onTeleport(boolean result, boolean type, int entityId) {
		if(result){
			EntityMyPerson clone = null;
			for(int a = 0; a < entities.size(); a++){
				if(entities.get(a).entityId == entityId){
					clone = entities.get(a);
				}
			}
			if(clone != null){
				if(type){
					mc.thePlayer.setPosition(clone.posX, clone.posY, clone.posZ);
					throwParticles(clone, new Random(), clone.worldObj);
				}else{
					clone.setPosition(mc.thePlayer.posX, mc.thePlayer.posY, mc.thePlayer.posZ);
					throwParticles(mc.thePlayer, new Random(), mc.theWorld);
				}
			}
		}else{
			errorDisplayTime = 100;
		}
		
	}
	
	
	
	
	
	
	
}
