package net.minecraft.mypeople;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ContainerSplicer extends Container{
	
	InventoryPlayer playerInven = null;
	
	TileEntitySplicer splicer = null;
	
	int lastBurnTime = 0, lastItemBurnTime = 0, lastSpliceTime = 0;
	
	
	public ContainerSplicer(InventoryPlayer playerInven, TileEntitySplicer tes){
		this.playerInven = playerInven;
		this.splicer = tes;
		this.addSlotToContainer(new SlotFuel(tes, 0, 80, 63));
		this.addSlotToContainer(new SlotType(MyPeople.emptyCapsule.itemID, 1, tes, 1, 80, 29));
		
		this.addSlotToContainer(new SlotType(MyPeople.needleDNA.itemID, 1, tes, 2, 8, 8));
		this.addSlotToContainer(new SlotType(MyPeople.needleDNA.itemID, 1, tes, 3, 8, 29));
		this.addSlotToContainer(new SlotType(MyPeople.needleDNA.itemID, 1, tes, 4, 8, 50));
		this.addSlotToContainer(new SlotType(MyPeople.needleDNA.itemID, 1, tes, 5, 152, 8));
		this.addSlotToContainer(new SlotType(MyPeople.needleDNA.itemID, 1, tes, 6, 152, 29));
		this.addSlotToContainer(new SlotType(MyPeople.needleDNA.itemID, 1, tes, 7, 152, 50));
		
        for (int j = 0; j < 9; j++)
        {
        	addSlotToContainer(new Slot(playerInven, j, 8 + j * 18, 142));
        }
		
        for (int i = 0; i < 3; i++)
        {
            for (int k = 0; k < 9; k++)
            {
            	addSlotToContainer(new Slot(playerInven, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }


	}
	
	
    public void detectAndSendChanges()
    {
        super.detectAndSendChanges();

        for (int i = 0; i < this.crafters.size(); ++i)
        {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);

            if (this.lastSpliceTime != this.splicer.timeSpliced)
            {
                icrafting.sendProgressBarUpdate(this, 0, this.splicer.timeSpliced);
            }

            if (this.lastBurnTime != this.splicer.furnaceBurnTime)
            {
                icrafting.sendProgressBarUpdate(this, 1, this.splicer.furnaceBurnTime);
            }

            if (this.lastItemBurnTime != this.splicer.currentItemBurnTime)
            {
                icrafting.sendProgressBarUpdate(this, 2, this.splicer.currentItemBurnTime);
            }
        }

        this.lastSpliceTime = this.splicer.timeSpliced;
        this.lastBurnTime = this.splicer.furnaceBurnTime;
        this.lastItemBurnTime = this.splicer.currentItemBurnTime;
    }

    @SideOnly(Side.CLIENT)
    public void updateProgressBar(int par1, int par2)
    {
        if (par1 == 0)
        {
            this.splicer.timeSpliced = par2;
        }

        if (par1 == 1)
        {
            this.splicer.furnaceBurnTime = par2;
        }

        if (par1 == 2)
        {
            this.splicer.currentItemBurnTime = par2;
        }
    }
    
    protected void retrySlotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer)
    {
//        this.slotClick(par1, par2, 1, par4EntityPlayer);
    }

	public ItemStack transferStackInSlot(EntityPlayer p, int i){
		IInventory tile = splicer;
		IInventory play = playerInven;
		Slot slot = this.getSlot(i);
		ItemStack stack = null;
		if(slot != null && slot.getHasStack()){
			stack = slot.getStack();
			ItemStack stack1 = stack.copy();
			if(i < 8){
				if(!mergeItemStack(stack, 8, 44, true)){
					return null;
				}
			}else if(i >= 8 && i < 17){
				if(!mergeItemStack(stack, 17, 44, true)){
					return null;
				}
			}else if(i >= 17 && i < 44){
				if(TileEntityFurnace.isItemFuel(stack)){
					if(!mergeItemStack(stack, 0, 1, true)){
						return null;
					}
				}else if(stack.itemID == MyPeople.needleDNA.itemID){
					if(!mergeItemStack(stack, 2, 8, true)){
						return null;
					}
				}
			}
	        if (stack.stackSize == 0)
	        {
	            slot.putStack(null);
	        }
	        else
	        {
	            slot.onSlotChanged();
	        }
	        if (stack.stackSize != stack1.stackSize)
	        {
	            slot.onPickupFromSlot(p, stack);
	        }
	        else
	        {
	            return null;
	        }
		}

		return stack;
    }
    
	@Override
	public boolean canInteractWith(EntityPlayer entityplayer) {
		return true;
	}

	
	
	
	
	
}
